use std::ffi::CString;
use std::ptr::null;

mod obsdffi {
    use std::ffi::{c_char, c_int};

    unsafe extern "C" {
        pub fn pledge(promises: *const c_char, execpromises: *const c_char) -> c_int;
        pub fn unveil(path: *const c_char, permissions: *const c_char) -> c_int;

        // TODO Use std::ffi::c_size_t once it is stable.
        pub fn sendsyslog(msg: *const c_char, len: usize, flags: c_int) -> c_int;
    }
}

pub fn pledge(promises: &str, execpromises: &str) -> bool {
    matches!(
        unsafe {
            obsdffi::pledge(
                CString::new(promises).unwrap().as_ptr(),
                CString::new(execpromises).unwrap().as_ptr(),
            )
        },
        0
    )
}

pub fn pledge_execpromises(execpromises: &str) -> bool {
    matches!(
        unsafe { obsdffi::pledge(null(), CString::new(execpromises).unwrap().as_ptr(),) },
        0
    )
}

pub fn pledge_promises(promises: &str) -> bool {
    matches!(
        unsafe { obsdffi::pledge(CString::new(promises).unwrap().as_ptr(), null()) },
        0
    )
}

pub fn unveil(path: &str, permissions: &str) -> bool {
    matches!(
        unsafe {
            obsdffi::unveil(
                CString::new(path).unwrap().as_ptr(),
                CString::new(permissions).unwrap().as_ptr(),
            )
        },
        0
    )
}

pub fn unveil_final() -> bool {
    matches!(unsafe { obsdffi::unveil(null(), null()) }, 0)
}

pub fn sendsyslog_simple(msg: &str) {
    unsafe { obsdffi::sendsyslog(CString::new(msg).unwrap().as_ptr(), msg.len(), 0) };
}
