use std::fs::read_to_string;
use std::path::Path;

use crate::index_parser::parse_index;
use crate::settings::Settings;

pub fn print_index_file(settings: &Settings, path: &Path) {
    let index = read_to_string(path).expect("Could not read .INDEX file");

    let relative_to = path
        .parent()
        .unwrap()
        .strip_prefix(&settings.docroot)
        .unwrap();
    print!("{}", parse_index(settings, &index, relative_to));
}
