use std::fs::File;
use std::io::{BufRead, BufReader, Write, stdout};
use std::path::Path;

pub fn print_file(path: &Path) {
    let mut fp = BufReader::new(File::open(path).expect("Could not open file"));

    loop {
        let buf = fp.fill_buf().expect("I/O error while reading file");
        if buf.is_empty() {
            return;
        }

        stdout()
            .write_all(buf)
            .expect("I/O error while writing chunk to stdout");

        // It is crucial to assign the length to a new variable: fill_buf() takes a mutable
        // borrow to 'fp' and that reference is held as long as 'buf' is still used or can still
        // be used. consume() takes another mutable borrow, which won't work if there already is
        // one. By assigning the length to another variable, the first borrow can be dropped and
        // then the consume() call will succeed.
        let length = buf.len();
        fp.consume(length);
    }
}
