use std::fs::canonicalize;
use std::path::{Path, PathBuf};

use crate::settings::Settings;

pub fn normalize_if_allowed(settings: &Settings, path: &Path) -> Result<PathBuf, String> {
    let docroot_path = PathBuf::from(&settings.docroot);

    if let Ok(canon) = canonicalize(docroot_path.join(path)) {
        if canon.starts_with(docroot_path) {
            Ok(canon)
        } else {
            Err(String::from("Path not allowed"))
        }
    } else {
        Err(String::from("Could not canonicalize"))
    }
}
