use std::path::Path;

use crate::settings::Settings;

pub fn parse_index(settings: &Settings, index: &str, relative_to: &Path) -> String {
    let mut result = String::new();

    let mut relative_to_string: String = relative_to.to_string_lossy().into_owned();
    if !relative_to_string.starts_with('/') {
        relative_to_string = format!("/{relative_to_string}");
    }
    if !relative_to_string.ends_with('/') {
        relative_to_string = format!("{relative_to_string}/");
    }

    for line in index.lines() {
        if line.starts_with('[') {
            let line = line.strip_prefix('[').unwrap_or(line);
            let line = line.strip_suffix(']').unwrap_or(line);
            let fields: Vec<_> = line.split('|').collect();

            if fields.len() == 5 {
                let menutype = fields[0].to_string();
                let display = fields[1].to_string();
                let mut target = fields[2].to_string();
                let mut servername = fields[3].to_string();
                let mut serverport = fields[4].to_string();

                if !target.starts_with("URL:") && !target.starts_with('/') {
                    target = format!("{relative_to_string}{target}");
                }

                if servername == "server" {
                    servername = settings.servername.clone();
                }

                if serverport == "port" {
                    serverport = format!("{}", settings.serverport);
                }

                result.push_str(&format!(
                    "{menutype}{display}\t{target}\t{servername}\t{serverport}\r\n"
                ));
                continue;
            }
        }

        // Fallthrough on invalid "[...]" lines -- also applies to all other lines.

        // We won't try to retain the original alignment when tabs are used. Just replace them with
        // spaces. The manpage mentions that you shouldn't use tabs.
        let expanded = line.replace("\t", "    ");

        result.push_str(&format!("i{expanded}\t-\t-\t0\r\n"));
    }

    result
}
