#!/bin/sh
# $Id: sddns.sh 17 2016-04-30 19:07:21Z umaxx $
# Copyright (c) 2016 Joerg Jung <mail@umaxx.net>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

PATH=$PATH:/usr/local/bin

readonly R_V="0.6" R_YR="2016"

s_err() {
    logger -i -p user.err -s -t "sddns" "error: ${1}"; exit 1
}

s_up() {
    ssh -T "${1}" "sed -e 's/${4} ; ${3}/${5} ; ${3}/' \
                       -e 's/${6} ; Serial/${7} ; Serial/' -i ${2}"
    printf "update: %s %s\n" "${3}" "${5}"
}

s_run() {
    local ns="${1##*@}" ip ip_n sn sn_n
    ip=$(dig +short @"${ns}" "${3}" A) || s_err "dig failed"
    ip_n=$(ssh "${1}" 'printf ${SSH_CONNECTION} | cut -d" " -f1') ||
        s_err "ssh failed"
    sn=$(dig +short @"${ns}" "${3#*.}" SOA | cut -d' ' -f3) ||
        s_err "dig soa failed"
    sn_n=$(date +"%Y%m%d01") || s_err "date failed"
    [ -z "${ip}" ] || [ -z "${ip_n}" ] || [ -z "${sn}" ] || [ -z "${sn_n}" ] &&
        s_err "data failed"
    [ "${sn_n}" -le "${sn}" ] && { sn_n=${sn}; sn_n=$((++sn_n)); }
    [ "${ip_n}" != "${ip}" ] &&
        s_up "${1}" "${2}" "${3}" "${ip}" "${ip_n}" "${sn}" "${sn_n}"
}

s_main() {
    [ $# -eq 1 ] && [ "${1}" = "version" ] &&
        { printf "sddns %s (c) %s Joerg Jung\n" ${R_V} ${R_YR}; exit 0; }
    [ $# -ne 2 ] &&
        { printf "usage: sddns <user@ns:/zone> <fqdn>\n%7ssddns version\n" " ";
          exit 1; }
    s_run "${1%%:*}" "${1##*:}" "${2}"
}

s_main "$@"
