/* $Id: insult.c 27 2016-10-16 19:35:15Z umaxx $
 * Copyright (c) 2015 Ted Unangst <tedu@openbsd.org>
 * Copyright (c) 2015 Reyk Floeter <reyk@openbsd.org>
 * Copyright (c) 2016 Joerg Jung <jung@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <err.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <sys/wait.h>

#define I_V "0.4"
#define I_YR "2015-2016"

static const char *i_msgs[] = {
    "No lollygagging!", "PEBKAC detected.", "Better luck next time.",
    "Duh... nope.  KTHXBYE.", "Shit should not be shared.",
    "Just stab yourself in the eye.", "For once, I have nothing to say.", 
    "I would explain, but I am too drunk.",
    "My cats are more observant than you.",
    "You can call it fart if you want to.",
    "That's what happens when you're lazy.",
    "Here is the weapon, there's your foot.",
    "No sane people allowed here.  Go home.",
    "You're not allowed to have an opinion.",
    "You have to stop peeing on your breakfast.",
    "It is clear that this has not been thought through.",
    "The people who wrote this code are not on your side.",
    "Well I could agree with you, but then we'd both be wrong.",
    "Well finally everyone can see that the shit is really shitty.",
    "That's the most ridiculous thing I've heard in the last two or three minutes!",
    "Complaint forms are handled in another department." };

static unsigned long i_rnd(unsigned long l) {
#ifdef __GLIBC__
    srandom(time(NULL));
    return random() % l;
#else
    return arc4random_uniform(l);
#endif
}

#define I_RED "\x1b[31m"
#define I_RST "\x1b[0m"

static void i_err(void) {
    fprintf(stderr, isatty(fileno(stderr)) ? I_RED "%s" I_RST "\n" : "%s\n",
        i_msgs[i_rnd(sizeof(i_msgs) / sizeof(i_msgs[0]))]);
    exit(1);
}

static void i_run(char *argv[], char *envp[]) {
    pid_t p;
    int s;

    if ((p = fork()) == -1)
        warn("fork"), i_err();
    if (!p) { /* child */
        if (execvpe(argv[0], argv, envp) == -1)
            err(1, argv[0]);
        _exit(0);
    }
    waitpid(p, &s, 0);
    if (WIFEXITED(s) && WEXITSTATUS(s))
        i_err();
}

int main(int argc, char *argv[], char *envp[]) {
    if (argc == 2 && !strcmp(argv[1], "version")) {
        puts("insult "I_V" (c) "I_YR" Reyk Floeter, Joerg Jung");
        return 0;
    }
    if (argc == 1)
        errx(1, "usage: insult <cmd> [<args>]\n%15sinsult version", "");
    argc -= 1, argv += 1;
    i_run(argv, envp);
    return 0;
}
