#!/usr/bin/sed -Enuf
# $Id: filter-fqdn.sed 66 2024-04-14 16:44:05Z umaxx $
# Copyright (c) 2019-2024 Joerg Jung <mail@umaxx.net>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# filter-fqdn - opensmtpd filter for HELO/EHLO FQDN filtering
#
# version: 0.4
# year: 2019-2024

# uncomment for debug
#s/(.*)/\1/w /dev/stderr

/^config|ready$/ { a\
register|filter|smtp-in|helo\
register|filter|smtp-in|ehlo\
register|ready
}

/^filter\|0.7\|.*\|smtp-in\|.*/ {
    # skip address literals
    /^.*smtp-in\|(.*)\|(.*)\|\[.*$/ {
        bproceed
    }
    # reject leading dot
    /^.*smtp-in\|(.*)\|(.*)\|(.*)\|\..*$/ {
        s//filter-result\|\2|\3\|reject\|554 5.7.1 \1 failed/p
    }
    # reject trailing dot
    /^.*smtp-in\|(.*)\|(.*)\|(.*)\|.*\.$/ {
        s//filter-result\|\2|\3\|reject\|554 5.7.1 \1 failed/p
    }
    # reject without dots (non-FQDN)
    /^.*smtp-in\|(.*)\|(.*)\|(.*)\|[^\.]*$/ {
        s//filter-result\|\2|\3\|reject\|554 5.7.1 \1 failed/p
    }
:proceed
    /^.*smtp-in\|.*\|(.*)\|(.*)\|.*$/ {
        s//filter-result\|\1|\2\|proceed/p
    }
}
