#!/bin/sh
dir="$1"
if [ -z "$dir" ]
then
    echo "Usage: geomyidae.sh DIR"
    echo ""
    echo "Converts all gophermap files in DIR to index.gph for geomyidae."
    echo ""
    exit 0
fi

find "$dir" -type f -name gophermap | while read f
do
    d=$(dirname $f)
    awk -f map2gph.awk "$f" >"$d/index.gph"
done

find "$dir" -type f -name gophermap -print0 | xargs -0 rm
