#!/usr/bin/awk -f
# map2gph.awk version 1 by Ben Collver
# Convert gophernicus to geomyidae gophermap
# usage: awk -f map2gph.awk gophermap >index.gph

BEGIN {
    FS = "\t"
}

/^i/ {
    sub(/\r$/, "")
    sub(/^i/, "", $1)
    print $1
    next
}

{
    sub(/\r$/, "")
    type = substr($1, 1, 1)
    userstr = substr($1, 2)
    gsub(/\|/, "\\|", userstr)
    printf "[%s|%s|%s|%s|%s]\n", type, userstr, $2, $3, $4
}
