function detect_archive(url,     retval, str) {
    str = tolower(url)
    if (str ~ /\.iso$/ ||
        str ~ /\.zip$/)
    {
        retval = 1
    } else {
        retval = 0
    }
    return retval
}

function detect_html(url,     retval, str) {
    str = tolower(url)
    if (str ~ /\.html?$/ ||
        str ~ /\.php$/)
    {
        retval = 1
    } else {
        retval = 0
    }
    return retval
}

function detect_image(url,     retval, str) {
    str = tolower(url)
    if (str ~ /\.bmp$/  ||
        str ~ /\.gif$/  ||
        str ~ /\.jpg$/  ||
        str ~ /\.jpeg$/ ||
        str ~ /\.png$/  ||
        str ~ /\.webp$/)
    {
        retval = 1
    } else {
        retval = 0
    }
    return retval
}

function gettemp(     result, retval) {
    while ((cmd_mktemp | getline) > 0) {
        retval = $0
    }
    result = close(cmd_mktemp)
    if (result != 0) {
        print "Error: mktemp failed exit status: " result
        exit
    }
    if (length(retval) == 0) {
        print "Error: mktemp failed, no tmpfile"
        exit
    }
    return retval
}

# heapsort
#
# Unstable, and unlike merge and quicksort it relies on random-access
# so has poorer cache performance.
#
# Advantage over quicksort is that its worst-case same as avg: O(n log n)
#
# This presentation based on http://dada.perl.it/shootout/heapsort.lua5.html
#
# From: <https://raw.githubusercontent.com/
# dubiousjim/awkenough/refs/heads/master/library.awk>
#
# Requires 1-based numerically indexed arrays.

function hsort(A, n,   c, p, t, i) {
    if (!n) {
        n = 1
        while (n in A) n++
        n--
    }
    i = int(n/2) + 1
    while (1) {
        if (i > 1) {
            i--
            t = A[i]
        } else {
            t = A[n]
            A[n] = A[1]
            n--
            if (n == 1) {
                A[1] = t
                return
            }
        }
        for (p = i; (c = 2*p) <= n; p = c) {
            if ((c < n) && (A[c] < A[c + 1]))
                c++
            if (t < A[c])
                A[p] = A[c]
            else break
        }
        A[p] = t
    }
}

function human_size(bytes,     retval) {
    if (bytes > size_gb) {
        retval = sprintf("%.1fG", bytes / size_gb)
    } else if (bytes > size_mb) { 
        retval = sprintf("%.1fM", bytes / size_mb)
    } else if (bytes > size_kb) { 
        retval = sprintf("%.1fK", bytes / size_kb)
    } else {
        retval = sprintf("%dB", bytes)
    }
    return retval
}

function print_not_found(output, url) {
    print "Item cannot be found" >>output
    print "" >>output
    print "Items may be taken down for various reasons," >>output
    print "including by decision of the uploader or" >>output
    print "due to a violation of the Terms of Use." >>output
    print "" >>output
    printf "[h|Metadata|URL:%s|%s|%s]\n", url, server, port >>output
    print "" >>output
    url = api_ssl_endpoint "/about/terms.php"
    printf "[0|Terms of Use|%s/text/%%09%s|%s|%s]\n", cgipath,
        url, server, port >>output
    print "" >>output
    printf "[1|PHAROS|%s|%s|%s]\n", cgipath, server, port >>output
    return
}

function read_file(name,    retval) {
    while ((getline <name) > 0) {
        retval = retval $0 "\n"
    }
    close(name)
    return retval
}

function shorten_left(str, len,     retval) {
    if (length(str) > len) {
        retval = "..." substr(str, 3 + length(str) - len)
    } else {
        retval = str
    }
    return retval
}

function shorten(str, len,     retval) {
    if (length(str) > len) {
        retval = substr(str, 0, len - 3) "..."
    } else {
        retval = str
    }
    return retval
}

function unlink(name) {
    system(cmd_rm " " name)
    return
}

function util_init() {
    licenseurl[""] = "None"
    licenseurl["https://creativecommons.org/publicdomain/zero/1.0/"] = \
        "Public Domain"
    licenseurl["https://creativecommons.org/licenses/by/4.0/"] = \
        "Attribution 4.0 International"
    licenseurl["https://creativecommons.org/licenses/by-sa/4.0/"] = \
        "Attribution-ShareAlike 4.0 International"
    licenseurl["https://creativecommons.org/licenses/by-nd/4.0/"] = \
        "Attribution-NoDerivs 4.0 International"
    licenseurl["https://creativecommons.org/licenses/by-nc/4.0/"] = \
        "Attribution-NonCommercial 4.0 International"
    licenseurl["https://creativecommons.org/licenses/by-nc-sa/4.0/"] = \
        "Attribution-NonCommercial-ShareAlike 4.0 International"
    licenseurl["https://creativecommons.org/licenses/by-nc-nd/4.0/"] = \
        "Attribution-NonCommercial-NoDerivs 4.0 International"

    mediatype["audio"]      = "aud"
    mediatype["collection"] = "col"
    mediatype["data"]       = "dat"
    mediatype["etree"]      = "aud"
    mediatype["image"]      = "img"
    mediatype["movies"]     = "mov"
    mediatype["software"]   = "bin"
    mediatype["texts"]      = "txt"
    mediatype["web"]        = "web"

    size_kb = 1024
    size_mb = 1024 * 1024
    size_gb = 1024 * 1024 * 1024
    return
}
