include(config.m4)dnl
#!__CMD_AWK__ -f

# lists/index.dcgi
#
# Show a list of a user's lists

include(src/config.awk)
incl(src/api.awk)
incl(src/cache.awk)
incl(src/cgi.awk)
incl(src/sqlite.awk)
incl(src/util.awk)

function main(     cmd, count, fields, iaout, i, id, is_private, item,
    item_count, item_id, label, name, output, record, records,
    signature, str, url)
{
    signature = sprintf("%s/lists", search)
    str = cache_init(signature)
    if (length(str) > 0) {
        print str
        return
    }

    output = cache_begin()
    iaout = gettemp()

    url = api_ssl_endpoint "/services/users/" search "/lists"
    api_request(url, "GET", iaout)

    # format list as a gopher directory (menu)
    cmd = sprintf("%s <%s 2>&1", cmd_json2tsv, iaout)
    FS = "\t"
    count = 0
    delete fields[0]
    id = 0
    is_private = 0
    item = ""
    item_count = 0
    item_id = ""
    name = ""
    record = ""
    delete records[0]

    while ((cmd | getline) > 0) {
        if ($1 == ".value[]" && $2 == "o") {
            # add information for previous list
            if (!is_private && length(name) > 0 && item_count > 0) {
                label = shorten_left(name, 50)
                item = sprintf("[1|%4d Items: %-50s|%s/list/%%09%s/%d|%s|%s]", 
                    item_count, label, cgipath, search, id, server, port)
                record = label "\t" id "\t" item
                count++
                records[count] = record
            }
        } else if ($1 == ".value[].list_name" && $2 == "s") {
            name = $3
            id = 0
            is_private = 0
            item_count = 0
        } else if ($1 == ".value[].is_private" && $2 == "b") {
            if ($3 == "true") {
                is_private = 1
            }
        } else if ($1 == ".value[].id" && $2 == "n") {
            id = $3
        } else if ($1 == ".value[].members[].identifier" && $2 == "s") {
            item_count++
        }
    }
    close(cmd)

    # add information for previous list
    if (!is_private && length(name) > 0 && item_count > 0) {
        label = shorten_left(name, 50)
        item = sprintf("[1|%4d Items: %-50s|%s/list/%%09%s/%d|%s|%s]",
            item_count, label, cgipath, search, id, server, port)
        record = label "\t" id "\t" item
        count++
        records[count] = record
    }

    # sort lists by label and id
    hsort(records, count)

    print search "'s Lists" >>output
    print "" >>output

    for (i = 1; i <= count; i++) {
        record = records[i]
        split(record, fields, /\t/)
        item = fields[3]
        print item >>output
    }

    print "" >>output
    printf "[1|PHAROS|%s|%s|%s]\n", cgipath, server, port >>output

    cache_end()
    unlink(iaout)
    return
}

BEGIN {
    config_init()

    cgi_init()
    uri_encode_init()
    main()
}
