include(config.m4)dnl
#!__CMD_AWK__ -f

# list/index.dcgi
#
# Show a specific list

include(src/config.awk)
incl(src/api.awk)
incl(src/cache.awk)
incl(src/cgi.awk)
incl(src/sqlite.awk)
incl(src/util.awk)

function main(     acct, client_url, cmd, count, creator, iaout, id,
    is_private, items, label, list_id, name, name_slug, numfound,
    order, order_name, order_names, order_param, output, page, pages,
    rows, query, sort_param, signature, str, title, type, url)
{
    order_names["creator"] = "creatorSorter"
    order_names["date"] = "date"
    order_names["title"] = "titleSorter"
    order_names["week"] = "week"

    rows = 15
    page = 1
    order = ""
    sort_param = ""

    # parse out page number and sort order
    for (i in parts) {
        if (parts[i] ~ /^rows[0-9][0-9]*$/) {
            rows = substr(parts[i], 5)
        } else if (parts[i] ~ /^page[0-9][0-9]*$/) {
            page = substr(parts[i], 5)
        } else if (parts[i] ~ /^sort/) {
            if (length(order) == 0) {
                sort_param = parts[i]
                order = substr(parts[i], 5)
            }
        }
    }

    split(search, parts, "/")
    acct = parts[1]
    list_id = parts[2]

    signature = sprintf("list/%s/%s", input, search)
    str = cache_init(signature)
    if (length(str) > 0) {
        print str
        return
    }

    output = cache_begin()
    iaout = gettemp()

    url = api_ssl_endpoint "/services/users/" acct "/lists/" list_id
    api_request(url, "GET", iaout)

    # fetch identifiers of list members

    cmd = sprintf("%s <%s 2>&1", cmd_json2tsv, iaout)
    FS = "\t"
    id = ""
    is_private = 0
    name = ""
    numfound = 0
    query = ""

    while ((cmd | getline) > 0) {
        if ($1 == ".value.list_name" && $2 == "s") {
            name = $3
            is_private = 0
        } else if ($1 == ".value.is_private" && $2 == "b") {
            if ($3 == "true") {
                is_private = 1
            }
        } else if ($1 == ".value.members[].identifier" && $2 == "s") {
            if (!is_private) {
                id = $3
                numfound++
                if (length(query) == 0) {
                    query = id
                } else {
                    query = query "+OR+" id
                }
            }
        }
    }
    close(cmd)
    unlink(iaout)

    # get metadata of list member items

    name_slug = uri_encode(name)
    gsub(/%20/, "-", name_slug)
    client_url = api_ssl_endpoint "/details/" acct "/lists/" list_id \
        "/" name_slug
    order_param = ""
    if (length(order) > 0) {
        split(order, parts, " ")
        order_name = order_names[parts[1]]
        if (length(order_name) > 0) {
            if (parts[2] == "desc") {
                client_url = client_url "?-" parts[1]
            } else {
                client_url = client_url "?" parts[1]
            }
            order_param = "&sort=" uri_encode(order_name ":" parts[2])
        }
    }
    url = api_ssl_endpoint "/services/search/beta/page_production/" \
        "?user_query=identifier:(" query ")"                        \
        "&hits_per_page=" rows                                      \
        "&page=" page                                               \
        order_param                                                 \
        "&aggregations=false"                                       \
        "&client_url=" client_url
    api_request(url, "GET", iaout)

    pages = int(numfound / rows)
    if (numfound % rows != 0) {
        pages++
    }

    # format as a gopher directory (menu)

    print acct "'s Lists" >>output
    print "" >>output
    printf "# List: %s, page %d of %d\n", name, page, pages >>output
    print "" >>output

    cmd = sprintf("%s <%s 2>&1", cmd_json2tsv, iaout)
    FS = "\t"
    count = 0
    creator = ""
    id = ""
    title = ""
    type = ""
    while ((cmd | getline) > 0) {
        if ($1 == ".response.body.hits.hits[].fields.creator[]" &&
            $2 == "s" && length(creator) == 0)
        {
            creator = $3
        } else if ($1 == ".response.body.hits.hits[].fields.identifier" &&
            $2 == "s")
        {
            id = $3
        } else if ($1 == ".response.body.hits.hits[].fields.mediatype" &&
            $2 == "s")
        {
            type = $3
        } else if ($1 == ".response.body.hits.hits[].fields.title" &&
            $2 == "s")
        {
            title = $3
        } else if ($1 == ".response.body.hits.hits[]._score") {
            # the _score field happens to be toward the end of each item
            if (length(title) > 0) {
                if (length(creator) > 0) {
                    label = sprintf("[%s] %s by %s", mediatype[type],
                        gph_encode(shorten(title, 40)), shorten(creator, 18))
                } else {
                    label = sprintf("[%s] %s", mediatype[type],
                        gph_encode(shorten(title, 58)))
                }
                printf "[1|%s|%s/details/%s|%s|%s]\n", label, cgipath, id,
                    server, port >>output
                count++
            }
            creator = ""
            descr = ""
            id = ""
            type = ""
        }
    }
    close(cmd)

    print "" >>output

    # only show "page back" if the user is past page 1
    if (page > 1) {
        printf "[1|[<<] Page %d|%s/list/page%d/rows%d/%s%%09%s/%d|%s|%s]\n",
            page - 1, cgipath, page - 1, rows, sort_param,
            acct, list_id, server, port >>output
    }

    # only show "next page" if the current page is completely full
    if (count == rows) {
        printf "[1|[>>] Page %d|%s/list/page%d/rows%d/%s%%09%s/%d|%s|%s]\n",
            page + 1, cgipath, page + 1, rows, sort_param,
            acct, list_id, server, port >>output
    }

    # only show "sort" if there's more than one item to sort
    if (numfound > 1) {
        printf "[1|[^v] Sort|%s/listsort/%%09%s/%d|%s|%s]\n", cgipath,
            acct, list_id, server, port >>output
    }

    printf "[1|Account %s|%s/account/%s|%s|%s]\n", acct, cgipath,
        acct, server, port >>output
 
    print "" >>output
    printf "[1|PHAROS|%s|%s|%s]\n", cgipath, server, port >>output

    cache_end()
    unlink(iaout)
    exit 0
}

BEGIN {
    config_init()

    cgi_init()
    uri_encode_init()
    util_init()
    main()
}
