include(config.m4)dnl
#!__CMD_AWK__ -f

# download/index.dcgi
#
# Show file downloads using either direct http or gopher proxy links

include(src/config.awk)
incl(src/api.awk)
incl(src/cgi.awk)
incl(src/util.awk)

function main(cmd, dir, files, file_size, format, iaout, is_archive,
    is_proxy, item_server, label, mtime, name, source, url)
{
    dir = parts[2]
    item_id = parts[3]

    if (dir == "download") {
        is_proxy = 1
    } else {
        # dir == "direct"
        is_proxy = 0
    }

    iaout = gettemp()

    url = api_endpoint "/metadata/" item_id
    api_request(url, "GET", iaout)

    # format search results as a gopher directory (menu)
    cmd = sprintf("%s <%s 2>&1", cmd_json2tsv, iaout)
    FS = "\t"
    dir = ""
    files = 0
    delete format
    item_server = ""
    delete mtime
    delete name
    delete file_size
    delete source

    while ((cmd | getline) > 0) {
        if ($1 == ".dir" && $2 == "s") {
            dir = $3
        } else if ($1 == ".files[]" && $2 == "o") {
            files++
        } else if ($1 == ".files[].format" && $2 == "s") {
            format[files] = $3
        } else if ($1 == ".files[].mtime" && $2 == "s") {
            mtime[files] = $3
        } else if ($1 == ".files[].name" && $2 == "s") {
            name[files] = $3
        } else if ($1 == ".files[].size" && $2 == "s") {
            file_size[files] = $3
        } else if ($1 == ".files[].source" && $2 == "s") {
            source[files] = $3
        } else if ($1 == ".server" && $2 == "s") {
            item_server = $3
        }
    }
    close(cmd)

    for (i = 1; i <= files; i++) {
        label = sprintf("%s %s %s",
            shorten_left(name[i], 40),
            strftime("%Y-%m-%d %H:%M", mtime[i]),
            human_size(file_size[i]))
        url = sprintf("http://%s%s/%s", item_server, dir, name[i])
        if (is_proxy) {
            if (max_bin_size > 0 && file_size[i] > max_bin_size * size_mb) {
                printf "[h|%s|URL:%s|%s|%s]\n", label, uri_encode(url),
                    server, port
            } else {
                printf "[1|%s|%s/links/%%09%s|%s|%s]\n", label, cgipath,
                    url, server, port
            }
        } else {
            printf "[h|%s|URL:%s|%s|%s]\n", label, uri_encode(url),
                server, port
        }
        is_archive = detect_archive(url)
        if (is_archive) {
            url = sprintf("http://%s/view_archive.php?archive=%s/%s",
                item_server, dir, name[i])
            printf "[h|%s (View Contents)|URL:%s|%s|%s]\n",
                shorten_left(name[i], 40), uri_encode(url),
                server, port
        }
    }

    printf "[1|Downloads via http|%s/direct/%s|%s|%s]\n", cgipath,
        item_id, server, port

    unlink(iaout)
    exit 0
}

BEGIN {
    config_init()

    cgi_init()
    uri_encode_init()
    util_init()
    main()
}
