include(config.m4)dnl
#!__CMD_AWK__ -f

# details/index.dcgi
#
# Show details for an item

include(src/config.awk)
incl(src/api.awk)
incl(src/cache.awk)
incl(src/cgi.awk)
incl(src/sqlite.awk)
incl(src/util.awk)
incl(src/web.awk)

function main(     add_date, col, cols, cmd, creator, descr, dir, i,
    iaout, id, item_id, item_server, item_size, label, language,
    license, output, pub_date, scanner, signature, str, thumb, title,
    topic, topics, type, uploader_account, uploader_email, url)
{
    item_id = parts[3]

    signature = "details/" item_id
    str = cache_init(signature)
    if (length(str) > 0) {
        print str
        return
    }

    iaout = gettemp()
    output = cache_begin()

    url = api_endpoint "/metadata/" item_id
    api_request(url, "GET", iaout)
    
    # format search results as a gopher directory (menu)
    cmd = sprintf("%s <%s 2>&1", cmd_json2tsv, iaout)
    FS = "\t"
    cols = 0
    delete col
    add_date = ""
    creators = 0
    delete creator
    descr = ""
    dir = ""
    id = ""
    item_server = ""
    item_size = 0
    language = ""
    license = ""
    pub_date = ""
    scanner = ""
    thumb = ""
    title = ""
    topics = 0
    delete topic
    type = ""
    uploader_account = ""
    uploader_email = ""
    while ((cmd | getline) > 0) {
        if ($1 == ".dir" && $2 == "s") {
            dir = $3
        } else if ($1 == ".files[].name" && $2 == "s") {
            if ($3 == "__ia_thumb.jpg") {
                thumb = $3
            }
        } else if ($1 == ".item_size" && $2 == "n") {
            item_size = $3
        } else if ($1 == ".metadata.addeddate" && $2 == "s") {
            added_date = $3
        } else if ($1 == ".metadata.collection" && $2 == "s") {
            cols++
            col[cols] = $3
        } else if ($1 == ".metadata.collection[]" && $2 == "s") {
            cols++
            col[cols] = $3
        } else if ($1 == ".metadata.creator" && $2 == "s") {
            creators++
            creator[creators] = $3
        } else if ($1 == ".metadata.creator[]" && $2 == "s") {
            creators++
            creator[creators] = $3
        } else if ($1 == ".metadata.description" && $2 == "s") {
            descr = $3
        } else if ($1 == ".metadata.identifier" && $2 == "s") {
            id = $3
        } else if ($1 == ".metadata.language" && $2 == "s") {
            language = $3
        } else if ($1 == ".metadata.license" && $2 == "s") {
            license = licenseurl[$3]
        } else if ($1 == ".metadata.mediatype" && $2 == "s") {
            type = $3
        } else if ($1 == ".metadata.publicdate" && $2 == "s") {
            pub_date = $3
        } else if ($1 == ".metadata.scanner" && $2 == "s") {
            scanner = $3
        } else if ($1 == ".metadata.subject" && $2 == "s") {
            topics++
            topic[topics] = $3
        } else if ($1 == ".metadata.subject[]" && $2 == "s") {
            topics++
            topic[topics] = $3
        } else if ($1 == ".metadata.title" && $2 == "s") {
            title = $3
        } else if ($1 == ".metadata.uploader" && $2 == "s") {
            uploader_email = $3
        } else if ($1 == ".server" && $2 == "s") {
            item_server = $3
        }
    }
    close(cmd)

    if (length(id) == 0) {
        print_not_found(output, url)
        cache_end()
        unlink(iaout)
        return
    }

    print shorten(title, 70) >>output
    if (creators == 1) {
        label = "by " shorten(creator[1], 70)
        printf "[1|%s|%s/search/%%09creator:(%s)|%s|%s]\n", label,
            cgipath, creator[1], server, port >>output
    } else if (creators > 1) {
        printf "\nby:\n" >>output
        for (i = 1; i <= creators; i++) {
            label = shorten(creator[i], 70)
            printf "[1|%s|%s/search/%%09creator:(%s)|%s|%s]\n", label,
                cgipath, creator[i], server, port >>output
        }
        printf "\n" >>output
    }
    if (length(thumb) > 0) {
        url = sprintf("http://%s%s/%s", item_server, dir, thumb)
        printf "[I|Thumbnail|%s/raw/%%09%s|%s|%s]\n",
            cgipath, url, server, port >>output
    }

    printf "[1|Download|%s/download/%s|%s|%s]\n", cgipath,
        item_id, server, port >>output
    printf "[h|Web page|URL:%s/details/%s|%s|%s]\n",
        api_ssl_endpoint, uri_encode(id), server, port >>output
    print "" >>output

    print_html(output, descr)

    print "" >>output
    if (length(add_date) > 0) {
        printf "%-20s %s\n", "Date Added:", add_date >>output
    }
    if (pub_date != add_date) {
        printf "%-20s %s\n", "Date Published:", pub_date >>output
    }
    printf "%-20s %s\n", "Identifier:", id >>output
    if (item_size > 0) {
        printf "%-20s %d\n", "Item Size:", item_size >>output
    }
    if (length(language) > 0) {
        printf "%-20s %s\n", "Language:", language >>output
    }
    if (length(license) > 0) {
        printf "%-20s %s\n", "License:", license >>output
    }
    printf "%-20s %s\n", "Media Type:", type >>output
    
    if (topics > 0) {
        print "" >>output
        print "# Topics" >>output
        for (i = 1; i <= topics; i++) {
            label = shorten(topic[i], 40)
            printf "[1|%s|%s/search/%%09subject:(%s)|%s|%s]\n", label,
                cgipath, topic[i], server, port >>output
        }
    }

    # scrape uploader name from item web page HTML
    url = api_ssl_endpoint "/details/" item_id
    api_request(url, "GET", iaout)
    while ((getline <iaout) > 0) {
        if (/item-upload-info__uploader-name/ &&
            match($0, /\/details\/[^"]*"/))
        {
            uploader_account = substr($0, RSTART + 9, RLENGTH - 10)
        }
    }
    close(iaout)

    if (cols > 0) {
        print "" >>output
        print "# Collections" >>output
        for (i = 1; i <= cols; i++) {
            label = shorten(col[i], 40)
            printf "[1|%s|%s/search/%%09collection:(%s)|%s|%s]\n",
                label, cgipath, col[i], server, port >>output
        }
    }

    print "" >>output
    print "# Uploaded by" >>output
    if (length(uploader_account) > 0) {
        label = shorten(uploader_account, 70)
        printf "[1|%s|%s/account/%s%%09%s|%s|%s]\n", label, cgipath,
            uploader_account, uploader_email, server, port >>output
    } else {
        label = shorten(uploader_email, 70)
        printf "[1|%s|%s/search/%%09uploader:%s|%s|%s]\n", label,
            cgipath, uploader_email, server, port >>output
    }

    print "" >>output
    print "# Similar items" >>output
    printf "[1|View similar items|%s/search/%%09similar:%s|%s|%s]\n",
        cgipath, item_id, server, port >>output

    print "" >>output
    printf "[1|PHAROS|%s|%s|%s]\n", cgipath, server, port >>output

    cache_end()
    unlink(iaout)
    return
}

BEGIN {
    config_init()

    uri_encode_init()
    cgi_init()
    main()
}
