function block_msg(ip, extra) {
    print "Access Denied"
    print "============="
    print ""
    print "This service only allows access from vetted client IP addresses."
    print "The intent is to thwart abusive bots and crawlers."
    print ""
    print "To gain access:"
    print ""
    print "* Email your client IP address (" ip ") to:"
    print "    " contact
    print ""
    print "* Include the word \"friendly\" in your message."
    print ""
    print "Service admin will reply when granted."
    print extra
    return
}

function cgi_init(     extra, ip) {
    ip = ENVIRON["REMOTE_ADDR"]

    search = ARGV[1]
    arguments = ARGV[2]
    traversal = ARGV[5]
    selector = ARGV[6]

    if (geomyidae_version < 0.96) {
        input = arguments

        # geomyidae 0.69 doesn't populate selector, so do it manually
        path = ENVIRON["PATH_TRANSLATED"]

        # remove leading text up through beginning of cgipath
        if (match(path, cgipath)) {
            selector = substr(path, RSTART)
        }

        # remove trailing text from beginning of script name
        if (match(selector, ENVIRON["SCRIPT_NAME"])) {
            selector = substr(selector, 1, RSTART - 1)
        }
        selector = selector input
    } else {
        input = traversal
    }

    if (length(search) == 0 && match(input, /%09.*/)) {
        # This is a hack to include a search in the URL.
        # everything before %09 is considered arguments
        # everything after %09 is considered the search
        search = substr(input, RSTART + 3, RLENGTH - 3)
        args = substr(input, 0, RSTART - 1)
    } else {
        args = input
    }

    # query is everything after ? in the gopher selector
    # this is NOT the same as the gopher search string
    query = args

    # parse the path out of the selector
    path = selector
    if (substr(path, 1, length(cgipath)) == cgipath) {
        path = substr(path, length(cgipath) + 1)
    }
    if (match(path, /%09/)) {
        path = substr(path, 1, RSTART - 1)
    }

    split(path, parts, "/")
    topdir = parts[2]

    if (pass_enabled) {
        # default deny access except client IP addresses in pass list
        blocked = 1
        FS = "\t"
        while ((getline < pass_list) > 0) {
            if (match(/^#/, $0)) {
                # ignore comments
                continue
            }
            if (ip == $1) {
                blocked = 0
                break
            }
        }
        close(pass_list)
        if (blocked) {
            extra = ""
            if (topdir == "details") {
                extra = "\nIn the meanwhile, see:\n\n" \
                    sprintf("[h|Web page|URL:%s/details/%s|%s|%s]\n",
                    api_ssl_endpoint,
                    uri_encode(parts[3]),
                    server,
                    port)
            }
            block_msg(ip, extra)
            exit(0)
        }
    }

    return
}

function gph_encode(str,     retval) {
    retval = str
    gsub(/\|/, "\\|", retval)
    return retval
}

function uri_encode_init(     i, c) {
    for (i = 0; i <= 255; i++) {
        c = sprintf("%c", i)
        uri_encode_ord[c] = i
        uri_encode_tab[i] = c
    }

    # Percent encode only control characters so that the higher unicode
    # block characters are left plainly visible.
    for (i = 0; i < 33; i++) {
        uri_encode_tab[i] = sprintf("%%%02X", i)
    }

    # Percent encode higher unicode block characters too
    for (i = 128; i <= 255; i++) {
         uri_encode_tab[i] = sprintf("%%%02X", i)
    }

    # DEL
    uri_encode_tab[127] = sprintf("%%%02X", 127)

    return
}

function uri_encode(str,     i, c, len, retval) {
    len = length(str)
    retval = ""
    for (i = 1; i <= len; i++) {
        c = substr(str, i, 1)
        retval = retval uri_encode_tab[uri_encode_ord[c]]
    }
    return retval
}
