# cache or memo-ize to reduce Internet Archive API calls

function cache_begin() {
    if (cache_enabled || !awk_ext) {
        cache_output = gettemp()
    } else {
        # awk_ext micro-optimization for gawk and mawk:
        # when cache is disabled, print directly to stdout
        cache_output = "/dev/stdout"
    }
    return cache_output
}

function cache_end(    value) {
    if (cache_enabled || !awk_ext) {
        close(cache_output)
        value = read_file(cache_output)
        print value
        cache_set_value(value)
        unlink(cache_output)
    }
    return
}

function cache_init(signature,    retval, sql) {
    if (!cache_enabled) {
        return
    }
    cache_signature = signature
    sql = "CREATE TABLE IF NOT EXISTS cache ( \
        id TEXT PRIMARY KEY,                  \
        ip TEXT,                              \
        epoch INTEGER,                        \
        result TEXT)"
    sqlite_exec(cache_db, sql)
    retval = cache_get_value()
    return retval
}

function cache_get_value(    retval, sql) {
    if (!cache_enabled) {
        return retval
    }
    sql = sprintf("SELECT result FROM cache WHERE id = '%s'",
        sqlite_escape(cache_signature))
    retval = sqlite_exec(cache_db, sql)
    return retval
}

function cache_set_value(value,    sql) {
    if (!cache_enabled) {
        return
    }

    # don't cache "not found", may be outage or scheduled maintenance
    if (value ~ /^Item cannot be found/) {
        return
    }

    sql = "REPLACE INTO cache(id, ip, epoch, result) VALUES('" \
        sqlite_escape(cache_signature) "', '" \
        ENVIRON["REMOTE_ADDR"] "', unixepoch(), '" \
        sqlite_escape(value) "')"
    sqlite_exec(cache_db, sql)
    return
}
