include(config.m4)dnl
#!__CMD_AWK__ -f

# account/index.dcgi
#
# Show details for an account

include(src/config.awk)
incl(src/api.awk)
incl(src/cache.awk)
incl(src/cgi.awk)
incl(src/sqlite.awk)
incl(src/util.awk)
incl(src/web.awk)

function main(     acct, cmd, col, cols, descr, dir, email, iaout, id,
    item_server, item_size, output, signature, str, thumb, title,
    type, url)
{
    acct = parts[3]
    email = search

    signature = sprintf("account/%s/%s", acct, email)
    str = cache_init(signature)
    if (length(str) > 0) {
        print str
        return
    }

    output = cache_begin()
    iaout = gettemp()

    url = api_endpoint "/metadata/" acct
    api_request(url, "GET", iaout)
    
    # format search results as a gopher directory (menu)
    cmd = sprintf("%s <%s 2>&1", cmd_json2tsv, iaout)
    FS = "\t"
    cols = 0
    delete col
    descr = ""
    dir = ""
    id = ""
    item_server = ""
    item_size = 0
    title = ""
    thumb = ""
    type = ""
    while ((cmd | getline) > 0) {
        if ($1 == ".dir" && $2 == "s") {
            dir = $3
        } else if ($1 == ".files[].name" && $2 == "s") {
            if ($3 == "__ia_thumb.jpg") {
                thumb = $3
            }
        } else if ($1 == ".item_size" && $2 == "n") {
            item_size = $3
        } else if ($1 == ".metadata.collection" && $2 == "s") {
            cols++
            col[cols] = $3
        } else if ($1 == ".metadata.collection[]" && $2 == "s") {
            cols++
            col[cols] = $3
        } else if ($1 == ".metadata.description" && $2 == "s") {
            descr = $3
        } else if ($1 == ".metadata.identifier" && $2 == "s") {
            id = $3
        } else if ($1 == ".metadata.mediatype" && $2 == "s") {
            type = $3
        } else if ($1 == ".metadata.title" && $2 == "s") {
            title = $3
        } else if ($1 == ".server" && $2 == "s") {
            item_server = $3
        }
    }
    close(cmd)

    if (length(id) == 0) {
        print_not_found(output, url)
        cache_end()
        unlink(iaout)
        return
    }

    print "Account: " acct >>output
    if (length(thumb) > 0) {
        url = sprintf("http://%s%s/%s", item_server, dir, thumb)
        printf "[I|Thumbnail|%s/raw/%%09%s|%s|%s]\n", cgipath, url,
            server, port >>output
    }
    print_html(output, descr)

    if (length(email) > 0) {
        printf "[1|Uploads|%s/search/sortaddeddate desc%%09uploader:%s|" \
            "%s|%s]\n",
            cgipath, email, server, port >>output
    }
    printf "[1|Items|%s/search/sortaddeddate desc%%09anyfield:%s|%s|%s]\n",
        cgipath, acct, server, port >>output
    printf "[1|Lists|%s/lists/%%09%s|%s|%s]\n", cgipath, acct,
        server, port >>output

    print "" >>output
    printf "%-20s %s\n", "Identifier:", id >>output
    if (item_size > 0) {
        printf "%-20s %d\n", "Item Size:", item_size >>output
    }
    printf "%-20s %s\n", "Media Type:", type >>output
    
    print "" >>output
    printf "[h|Account web page|URL:%s/details/%s|%s|%s]\n",
        api_ssl_endpoint, uri_encode(id), server, port >>output
    printf "[1|PHAROS|%s|%s|%s]\n", cgipath, server, port >>output

    cache_end()
    unlink(iaout)
    exit 0
}

BEGIN {
    config_init()

    cgi_init()
    uri_encode_init()
    main()
}
