#!/bin/sh
DESTDIR=pharos
SRC=src

build() {
    dir=$1
    in=$2
    out=$3
    echo "m4 $in >$out && chmod a+rx $out"
    m4 $in >$out && chmod a+rx $out
}

# PLAIN
for f in index.gph              \
    account/index.dcgi      \
    audio/index.gph         \
    books/index.gph         \
    images/index.gph        \
    details/index.dcgi      \
    download/index.dcgi     \
    list/index.dcgi         \
    lists/index.dcgi        \
    listsort/index.dcgi     \
    raw/index.cgi           \
    search/index.dcgi       \
    software/index.gph      \
    sort/index.dcgi         \
    video/index.gph         \
    wizard/step1/index.dcgi \
    wizard/step2/index.dcgi \
    wizard/step3/index.dcgi
do
    build $SRC ${SRC}/${f}.m4 ${DESTDIR}/$f
done

# WEIRD
build $SRC ${SRC}/raw/index.cgi.m4 ${DESTDIR}/debug/index.cgi
build $SRC ${SRC}/raw/index.cgi.m4 ${DESTDIR}/text/index.cgi
build $SRC ${SRC}/download/index.dcgi.m4 ${DESTDIR}/direct/index.dcgi
build $SRC ${SRC}/raw/index.cgi.m4 ${DESTDIR}/links/index.dcgi
cp pass.tsv ${DESTDIR}/pass.tsv
exit 0
