#ifndef __dj_include_wchar_h_
#define __dj_include_wchar_h_

#include <stddef.h>

__DJ_wint_t
#undef __DJ_wint_t
#define __DJ_wint_t

#ifndef WEOF
#define WEOF ((wint_t)(-1))
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
  int shift_state;
} mbstate_t;

wchar_t * wmemchr(const wchar_t *_s, wchar_t _c, size_t _n);

int wmemcmp(const wchar_t *_s1, const wchar_t *_s2, size_t _n);
wchar_t *  wmemcpy(wchar_t *_dest, const wchar_t *_src, size_t _n);
wchar_t *  wmemmove(wchar_t *_s1, const wchar_t *_s2, size_t _n);
wchar_t *  wmemset(wchar_t *_s, wchar_t _c, size_t _n);

wchar_t *  wcscat(wchar_t *_s1, const wchar_t *_s2);
wchar_t *  wcschr(const wchar_t *_s, wchar_t _c);
int wcscmp(const wchar_t *_s1, const wchar_t *_s2);
int wcscoll(const wchar_t *_s1, const wchar_t *_s2);
wchar_t * wcscpy(wchar_t *_s1, const wchar_t *_s2);
size_t	wcscspn(const wchar_t *_s1, const wchar_t *_s2);
size_t	wcslen(const wchar_t *_s);
wchar_t * wcsncat(wchar_t *_s1, const wchar_t *_s2, size_t _n);
int wcsncmp(const wchar_t *_s1, const wchar_t *_s2, size_t _n);
wchar_t *  wcsncpy(wchar_t *_s1, const wchar_t *_s2, size_t _n);
wchar_t *  wcspbrk(const wchar_t *_s1, const wchar_t *_s2);
wchar_t *  wcsrchr(const wchar_t *_s, int _c);
size_t	wcsspn(const wchar_t *_s1, const wchar_t *_s2);
wchar_t * wcsstr(const wchar_t *_s1, const wchar_t *_s2);
wchar_t * wcstok(wchar_t *_s1, const wchar_t *_s2);
size_t wcsxfrm(wchar_t *_s1, const wchar_t *_s2, size_t _n);

#ifdef __cplusplus
}
#endif

#endif

