; based on dosclip.a86 by Veit Kannegieser 2000-03-03

DOS_INTERRUPT		equ 0x21
DOS_WRITE_STR_STDOUT	equ 0x09
DOS_SET_INT_VECTOR	equ 0x25
DOS_SET_INT_MUX		equ 0x252F
DOS_GET_INT_VECTOR	equ 0x35
DOS_GET_INT_MUX		equ 0x352F
DOS_GET_OS_TYPE		equ 0x4452
DOS_ALLOC_MEMORY	equ 0x48
DOS_FREE_MEMORY		equ 0x49
DOS_RESIZE_MEMORY	equ 0x4A
DOS_EXIT		equ 0x4C
DOS_EXIT_CODE_0		equ 0x4C00
DOS_EXIT_CODE_8		equ 0x4C08
DOS_GET_MALLOC_STRATEGY	equ 0x5800
DOS_SET_MALLOC_STRATEGY equ 0x5801
DOS_GET_UMB_LINK_STATE	equ 0x5802
DOS_SET_UMB_LINK_STATE	equ 0x5803

DRDOS_SINGLE_USER	equ 0x10

; http://www.delorie.com/djgpp/doc/rbinter/it/79/16.html
STRATEGY_HIGH		equ 0x82

_64K_IN_BYTES		equ 0xFFFF
_64K_IN_KB		equ 64
_64K_IN_PARAGRAPHS	equ 0x1000
PARAGRAPH_IN_BYTES	equ 16

; usbdos/usbuhci.a36 documents the MCB data structure
MCB_OWNER_ID		equ 1
MCB_OWNER_NAME		equ 8
MCB_OWNER_NAME_LEN_W	equ 4

MCB_OWNER_DRDOS_XMSUMB	equ 6

; usbdos/usbuhci.a36 documents the PSP data structure
PSP_ARGS_LEN		equ 0x80
PSP_ARGS_STR		equ 0x81

MUX_INTERRUPT		equ 0x2F
MUX_WINOLDAP		equ 0x17
MUX_XMS_INSTALL_CHECK	equ 0x4300
MUX_XMS_GET_DRV_ADDR	equ 0x4310

WOA_VERSION		equ 0
WOA_OPEN_CLIP		equ 1
WOA_EMPTY_CLIP		equ 2
WOA_SET_CLIP_DATA	equ 3
WOA_GET_CLIP_SIZE	equ 4
WOA_GET_CLIP_DATA	equ 5
WOA_CLOSE_CLIP		equ 8
WOA_COMPACT_CLIP	equ 9

FMT_TEXT_CP1252		equ 1
FMT_OEMTEXT_CP437	equ 7

XMS_INSTALLED		equ 0x80

; XMS driver functions
XMS_ALLOC		equ 0x09
XMS_FREE		equ 0x0A
XMS_MOVE		equ 0x0B

; Use segment:offset instead of real 32-bit memory address
XMS_HANDLE_REAL		equ 0

struc ExtMemMoveStruct
xms_Length:		resd 1
xms_SrcHandle:		resw 1
xms_SrcOffsetLo:	resw 1
xms_SrcOffsetHi:	resw 1
xms_DstHandle:		resw 1
xms_DstOffsetLo:	resw 1
xms_DstOffsetHi:	resw 1
endstruc

TSR_ARG_INSTALL		equ 0
TSR_ARG_UNINSTALL	equ 1
TSR_NOT_YET_INST	equ 0

org 0x100
jmp setup

; reserve paragraph
align PARAGRAPH_IN_BYTES

; tsr_start points here
; ----------------------------------------------------------------------
is_open:		db 0
clipboard_data_size:	dw 0
odd_byte:		db 0

; Program -> Clipboard
; ====================

copyblock1:
istruc ExtMemMoveStruct
at xms_Length,		dd 0
at xms_SrcHandle,	dw XMS_HANDLE_REAL
at xms_SrcOffsetLo,	dw 0	; bx
at xms_SrcOffsetHi,	dw 0	; es
at xms_DstHandle,	dw 'HA'
at xms_DstOffsetLo,	dw 0
at xms_DstOffsetHi,	dw 0
iend

; Clipboard -> Program
; ====================

copyblock2:
istruc ExtMemMoveStruct
at xms_Length,		dd 0
at xms_SrcHandle,	dw 'HA'
at xms_SrcOffsetLo,	dw 0
at xms_SrcOffsetHi,	dw 0
at xms_DstHandle,	dw XMS_HANDLE_REAL
at xms_DstOffsetLo,	dw 0	; bx
at xms_DstOffsetHi,	dw 0	; es
iend

; new interrupt 0x2F handler
handler_new:

cmp ah, MUX_WINOLDAP
je winoldap_id_version

not_winoldap:
jmp far [cs:handler_old]

handler_old:
handler_old_offset	dw 0
handler_old_segment	dw 0

; ax = winoldap_id_version(ax)
; ============================

winoldap_id_version:

cmp al, WOA_VERSION
jne winoldap_open_clipboard

mov ax, 1		; WinOldAp version "0.1"
iret

; ax = winoldap_open_clipboard(ax)
; ================================

winoldap_open_clipboard:

cmp al, WOA_OPEN_CLIP
jne winoldap_empty_clipboard

call is_clipboard_open
je .done

; 1=open, effectively locking the clipboard
mov byte [cs:is_open], 1

inc ax			; 1=success

.done:
iret

; ax = winoldap_empty_clipboard(ax)
; =================================

winoldap_empty_clipboard:

cmp al, WOA_EMPTY_CLIP
jne winoldap_set_clipboard_data

call is_clipboard_open
jne .done

mov word [cs:clipboard_data_size], 0
inc ax			; 1=success

.done:
iret

; ax = winoldap_set_clipboard_data(ax, dx, es:bx, si:cx)
; ======================================================
; es:bx = data
; si:cx = size of data

winoldap_set_clipboard_data:

cmp al, WOA_SET_CLIP_DATA
jne winoldap_get_clipboard_size

; more than 4 variables referenced, so set ds=cs
push ds
push cs
pop ds

call is_clipboard_open
jne .done

call is_format_any_text
jne .done

cmp si, 0		; does data fit in 64K buffer?
jne .done

push si
mov word [clipboard_data_size], cx

test cl, 1
jz .move_block_word_aligned

; move last byte
mov si, cx
mov al, [es:bx + si - 1]
mov [odd_byte], al

.move_block_word_aligned:
mov word [copyblock1+xms_SrcOffsetLo], bx
mov word [copyblock1+xms_SrcOffsetHi], es
mov si, copyblock1
call move_xms_block

pop si
mov ax, 1		; 1=success

.done:
pop ds
iret

; dx:ax = winoldap_get_clipboard_size(ax, dx)
; ===========================================

winoldap_get_clipboard_size:

cmp al, WOA_GET_CLIP_SIZE
jne winoldap_get_clipboard_data

call is_clipboard_open
jne .done

call is_format_any_text
jne .done

; with 64K buffer size, the high word (dx) is always 0
sub dx, dx
mov ax, word [cs:clipboard_data_size]

.done:
iret

; ax = winoldap_get_clipboard_data(ax, dx, es:bx)
; ===============================================
; es:bx = buffer

winoldap_get_clipboard_data:

cmp al, WOA_GET_CLIP_DATA
jne winoldap_close_clipboard

; more than 4 variables referenced, so set ds=cs
push ds
push cs
pop ds

call is_clipboard_open
jne .done

call is_format_any_text
jne .done

push si

mov si, word [clipboard_data_size]
test si, 1
jz .move_block_word_aligned

; move last byte
mov al, [odd_byte]
mov [es:bx + si - 1], al

.move_block_word_aligned:
mov word [copyblock2+xms_DstOffsetLo], bx
mov word [copyblock2+xms_DstOffsetHi], es
mov si, copyblock2
call move_xms_block

pop si
mov ax, 1		; 1=success

.done:
pop ds
iret

; ax = winoldap_close_clipboard(ax)
; =================================

winoldap_close_clipboard:

cmp al, WOA_CLOSE_CLIP
jne winoldap_compact_clipboard

; 0=closed, effectively unlocking the clipboard
mov byte [cs:is_open], 0

mov ax, 1		; 1=success

.done:
iret

; dx:ax = winoldap_compact_clipboard(ax, si:cx)
; =============================================

winoldap_compact_clipboard:

cmp al, WOA_COMPACT_CLIP
jne not_winoldap

; return 64K buffer size available
sub dx, dx
mov ax, _64K_IN_BYTES
iret

; zf = is_clipboard_open(ax)
; ==========================
; side-effects: ax becomes zero

is_clipboard_open:
sub ax, ax
cmp byte [cs:is_open], 1
ret

; zf = is_format_any_text(dx)
; ===========================
is_format_any_text:
cmp dx, FMT_TEXT_CP1252
jne is_format_oem_text
ret

is_format_oem_text:
cmp dx, FMT_OEMTEXT_CP437
ret

; move_xms_block(ds:si)
; =====================
; ds:si = Extended Memory Move Structure
; returns status in ax
;
; This is only called from:
; * winoldap_get_clipboard_data()
; * winoldap_set_clipboard_data()

move_xms_block:

push bx

; round clipboard data size down to the nearest word
mov ax, [clipboard_data_size]
and al, 0xFE

mov word [si], ax	; set xms_Length = ax

mov ah, XMS_MOVE
call far [xms_entry_point]

; ignore error code and preserve original value in bx
pop bx
ret

xms_entry_point:	db 'XXXX'

; ----------------------------------------------------------------------
tsr_end:

align PARAGRAPH_IN_BYTES
memoryerror_text:	db `\aerror on memory allocation\r\n$`

lh_old_umb		dw 0
lh_old_strategy		dw 0
lh_tsr_segment		dw 0

COM_OFFSET		dw 0x100

; tsr starts at one paragraph after the .com offset
tsr_start		equ 0x110 ; COM_OFFSET + PARAGRAPH_IN_BYTES

; es,ax = request_high_memory(ds:program_name, tsr_end)
; =====================================================
; side-effects: changes ax, bx, cs, si, di, es

request_high_memory:
%define _prog_name	bp+4
%define _tsr_end	bp+6
enter 0, 0

; reduce my allocated memory to 64K .. with Stack
mov ah, DOS_RESIZE_MEMORY
mov bx, _64K_IN_PARAGRAPHS
; mov es, cs
int DOS_INTERRUPT

mov ax, DOS_GET_UMB_LINK_STATE
int DOS_INTERRUPT
mov ah, 0
mov [lh_old_umb], ax

mov ax, DOS_GET_MALLOC_STRATEGY
int DOS_INTERRUPT
mov [lh_old_strategy], ax

mov ax, DOS_SET_UMB_LINK_STATE
%ifdef not_umb
mov bx, 0		; -UMB ; <640K
%else
mov bx, 1		; +UMB ; .. FFFF
%endif
int DOS_INTERRUPT

mov ax, DOS_SET_MALLOC_STRATEGY
mov bx, STRATEGY_HIGH
int DOS_INTERRUPT

mov ah, DOS_ALLOC_MEMORY
mov bx, [_tsr_end]
sub bx, tsr_start - PARAGRAPH_IN_BYTES
shr bx, 4		; paragraphs to allocate
int DOS_INTERRUPT
jnc .alloc_done
sub ax, ax		; zero out ax to indicate failed alloc

.alloc_done:
mov [lh_tsr_segment], ax

mov ax, DOS_SET_UMB_LINK_STATE
mov bx, [lh_old_umb]
int DOS_INTERRUPT

mov ax, DOS_SET_MALLOC_STRATEGY
mov bx, [lh_old_strategy]
int DOS_INTERRUPT

mov ax, [lh_tsr_segment]
cmp ax, 0		; did the alloc fail?
jz .error

dec ax			; rewind es back one paragraph to the MCB
mov es, ax
inc ax

push ax			; save segment of newly allocated memory
push dx
mov bx, ax		; MCB of this program
			; OS/2 Mem shows not "--------"

mov ax, DOS_GET_OS_TYPE
int DOS_INTERRUPT
jc .not_drdos

cmp ah, DRDOS_SINGLE_USER
jnz .not_drdos

; Mem Shows Name and
mov bx, MCB_OWNER_DRDOS_XMSUMB

.not_drdos:
pop dx
pop ax

; set MCB owner id to newly allocated memory.
; This is a new id, different than the current PSP.
; Because of this new id, DOS won't free this memory on exit.
; Thus the code in this new memory becomes TSR.
push bx
mov word [es:MCB_OWNER_ID], bx

; set MCB owner name, 4 words is 8 bytes
mov si, [_prog_name]
mov di, MCB_OWNER_NAME
cld
movsw
movsw
movsw
movsw

; set es to newly allocated memory
mov es, ax

; copy my original code to the newly allocated memory
mov si, tsr_start
mov di, 0
mov cx, [_tsr_end]
sub cx, si
; copy cx/2 words of my program code
inc cx
shr cx, 1
rep movsw

; save segment of my original code 
sub ax, tsr_start / PARAGRAPH_IN_BYTES
mov es, ax

leave
ret 2 * 2

.error:
mov ah, DOS_WRITE_STR_STDOUT
mov dx, memoryerror_text
int DOS_INTERRUPT

mov ax, DOS_EXIT_CODE_8
int DOS_INTERRUPT
				
; release_high_memory(program_name, tsr_old_seg)
; ==============================================

release_high_memory:
%define _prog_name	bp+4
%define _tsr_old_seg	bp+6
enter 0, 0

push ax
push cx
push si
push di
push es

; find the old MCB
mov ax, [_tsr_old_seg]
add ax, tsr_start / PARAGRAPH_IN_BYTES

; rewind one paragraph to MCB
dec ax

; set es to the MCB
mov es, ax

; verify that this MCB still belongs to me
mov si, [_prog_name]
mov di, MCB_OWNER_NAME
mov cx, MCB_OWNER_NAME_LEN_W
cld
rep cmpsw
jnz .cannot_release

; this MCB still belongs to me
; this code is necessary to avoid errors on OS/2
mov [es:MCB_OWNER_ID], cs

; set es to memory block, one paragraph past MCB
inc ax
mov es, ax

; free the allocated memory
mov ah, DOS_FREE_MEMORY
int DOS_INTERRUPT

.cannot_release:
pop es
pop di
pop si
pop cx
pop ax

leave
ret 2 * 2

; dx = is_already_installed(int_number, prog_name, ip_expected)
; =============================================================

is_already_installed:
%define _int_number	bp+4
%define _prog_name	bp+6
%define _ip_expected	bp+8
enter 0, 0

push ax
push bx
push cx
push si
push di
push es

mov ax, [_prog_name]
mov ax, [_ip_expected]
mov al, [_int_number]

mov ah, DOS_GET_INT_VECTOR
mov al, [_int_number]
int DOS_INTERRUPT
                            
mov dx, es

cmp bx, [_ip_expected]
jnz .no_match
                            
; set es to MCB
mov ax, es
add ax, (tsr_start / PARAGRAPH_IN_BYTES) - 1
mov es, ax

; check whether MCB matches my name
mov si, [_prog_name]
mov di, MCB_OWNER_NAME
mov cx, MCB_OWNER_NAME_LEN_W
cld
rep cmpsw
jz .name_match

.no_match:
; set dx to 0 = TSR_NOT_YET_INSTALLED
sub dx, dx

.name_match:
pop es
pop di
pop si
pop cx
pop bx
pop ax

leave
ret 3 * 2

; simple_tsr()
; ============
; side-effects: changes ax, bx, cx, dx, cs, si, di, es

simple_tsr:

push handler_new
push program_name
push byte MUX_INTERRUPT
call is_already_installed
push dx

; cx=TSR_ARG_INSTALL when args have neither /u nor /r
mov cx, TSR_ARG_INSTALL
mov si, PSP_ARGS_STR
cld

.args_loop:
lodsb

cmp al, ' '
jz .args_loop
cmp al, '/'
jz .args_loop
cmp al, '-'
jz .args_loop
cmp al, 9
jz .args_loop

; convert arg to lower case
or al, ('a' - 'A')

; cx=TSR_ARG_UNINSTALL when args have either /u or /r
cmp al, 'u'
jnz .not_arg_u
inc cx

.not_arg_u:
cmp al, 'r'
jnz .not_arg_r
inc cx

.not_arg_r:

pop dx

cmp cx, TSR_ARG_INSTALL
jnz .deinstallation

; check whether this TSR is already installed
mov ah, DOS_WRITE_STR_STDOUT
cmp dx, TSR_NOT_YET_INST
jz .ok_to_install

; let user know this TSR is already installed
mov dx, duplicate_text
int DOS_INTERRUPT

mov ax, DOS_EXIT_CODE_8
int DOS_INTERRUPT

.ok_to_install:
mov dx, installation_text
int DOS_INTERRUPT

push tsr_end
push program_name
call request_high_memory

; At this point, our TSR code has been duplicated into high memory.
;
; Until termination winoldap.com will:
; * continue to execute in base memory.
; * use cs/ds to reference the copy in base memory.
; * use es to reference the copy in high memory.
;
; After termination, winoldap.com will execute in high memory.

; get old MUX interrupt handler
push es
mov ax, DOS_GET_INT_MUX
int DOS_INTERRUPT
mov ax, es
pop es

; save old MUX interrupt handler
mov [es:handler_old+0], bx
mov [es:handler_old+2], ax

; allocate XMS for buffer
mov ah, XMS_ALLOC
mov dx, _64K_IN_KB
call far [xms_entry_point]

cmp ax, 1
je .success

mov ah, DOS_WRITE_STR_STDOUT
mov dx, text_error_xms_malloc
int DOS_INTERRUPT

mov ax, DOS_EXIT_CODE_8
int DOS_INTERRUPT

.success:
mov [es:copyblock1+xms_DstHandle], dx
mov [es:copyblock2+xms_SrcHandle], dx

; set new MUX interrupt handler (es:handler_new)
mov ax, DOS_SET_INT_MUX
mov dx, handler_new
push ds
mov bx, es
mov ds, bx
int DOS_INTERRUPT
pop ds

ret

.deinstallation:

cmp dx, 0
jz .error

mov es, dx

; free buffer XMS
mov ah, XMS_FREE
mov dx, [es:copyblock1+xms_DstHandle]
call far [xms_entry_point]

mov ah, DOS_WRITE_STR_STDOUT
mov dx, deinstallation_text
int DOS_INTERRUPT

; restore original MUX interrupt handler
push ds
mov ax, DOS_SET_INT_MUX
mov dx, [es:handler_old+0]
mov ds, [es:handler_old+2]
int DOS_INTERRUPT
pop ds

push es
push program_name
call release_high_memory

ret

.error:
mov ah, DOS_WRITE_STR_STDOUT
mov dx, not_active_text
int DOS_INTERRUPT

ret

; ----------------------------------------------------------------------
program_name:		db 'WINOLDAP'

installation_text:	db `loading WINOLDAP\r\n$`
deinstallation_text:	db `unloading WINOLDAP\r\n$`
duplicate_text:		db `WINOLDAP already installed!\r\n$`
not_active_text:	db `WINOLDAP not found active in memory!\r\n$`
text_no_xms:		db `no XMS-driver loaded.\r\n$`
text_error_xms_malloc:  db `error allocating 64 KB of XMS.\r\n$`

; setup()
; =======

setup:

mov ax, MUX_XMS_INSTALL_CHECK
int MUX_INTERRUPT
cmp al, XMS_INSTALLED
je .xms_found

mov ah, DOS_WRITE_STR_STDOUT
mov dx, text_no_xms
int DOS_INTERRUPT

mov ax, DOS_EXIT_CODE_8
int DOS_INTERRUPT

.xms_found:

; get and save the XMS driver entry point
push es
mov ax, MUX_XMS_GET_DRV_ADDR
int MUX_INTERRUPT
mov [xms_entry_point+0], bx
mov [xms_entry_point+2], es
pop es

call simple_tsr

; At this point we terminate and DOS will free the base memory portion
; of winoldap.com.  The copy in high memory will continue to execute
; because its MCB owner ID has been changed to a different "process"
; than the one that is terminating.

mov ax, DOS_EXIT_CODE_0
int DOS_INTERRUPT
