; nasm -f bin -o paste.com paste.asm
;
; To redirect the Windows clipboard to a file:
; paste.com >file.txt
;
; References:
; * MS KB Q67675: Access to the Windows Clipboard by MS-DOS-Based App
; * w16select.c in GNU Emacs

STDIN			equ	0
STDOUT			equ	1
STDERR			equ	2

; DOS system calls
DOS_INTERRUPT		equ	0x21
DOS_READ_HANDLE		equ	0x3F
DOS_WRITE_HANDLE	equ	0x40
DOS_EXIT		equ	0x4C

; Windows system calls
MUX_INTERRUPT		equ	0x2F
MUX_WINOLDAP		equ	0x17
WOA_VERSION		equ	0x1700
WOA_OPEN_CLIP		equ	0x1701
WOA_EMPTY_CLIP		equ	0x1702
WOA_GET_CLIP_SIZE	equ	0x1704
WOA_GET_CLIP_DATA	equ	0x1705
WOA_CLOSE_CLIP		equ	0x1708

; clipboard formats.  Windows converts these on the fly.
FMT_TXT_CP1252		equ	1
FMT_OEMTXT_CP437	equ	7

; buffer size in various units
_64K_IN_PAR		equ	0x1000
_64K_IN_BYTES		equ	0xFFFF
_64K_TERMINATED		equ	0xFFFE	; 64K - terminating byte

cpu 386
section .text align=2
org 0x100

; DOS assigns all free conventional memory to the program.
; The first 64K is used by segment shared by CS/DS/SS.

; make sure we have enough free memory to hold a 64K buffer.
mov bx, [2]		;    PSP next segment
mov ax, ds		; -  data segment
sub bx, ax		; =  size of memory
cmp bx, _64K_IN_PAR
mov dx, lacksmem
mov cx, lacksmemlen
jb  error

; save amount of free memory paragraphs
mov [free_memory_par], bx

; allocate 64K buffer es:0000
mov ax, ds
add ax, _64K_IN_PAR
mov es, ax

; zero out the buffer
mov cx, _64K_IN_BYTES
mov di, 0
zero_buffer:
mov byte [es:di], 0
inc di
loop zero_buffer

; check WinOldAp version
mov ax, WOA_VERSION
int MUX_INTERRUPT
cmp ax, WOA_VERSION
mov dx, noclipboard
mov cx, noclipboardlen
jz  error

; open clipboard
mov ax, WOA_OPEN_CLIP
int MUX_INTERRUPT
or  ax, ax		; nonzero status means error
mov dx, openclip
mov cx, opencliplen
jz  error
mov byte [is_open], 1

; get clipboard data size
mov ax, WOA_GET_CLIP_SIZE
mov dx, FMT_OEMTXT_CP437
int MUX_INTERRUPT

; clipboard size is a 32-bit value in dx:ax
; if high word dx is zero then the clipboard fits in 64K
; in that case we can skip the buffer math
cmp dx, 0
jz fits64k

; convert clipboard size from bytes to paragraphs
; dx:ax >> 4 == (ax >> 4) | ((dx & 0xf) << 12)
push ax
push dx
shr ax, 4
and dx, 0xf
shl dx, 12
or ax, dx

; check whether clipboard fits in free conventional memory
mov bx, [free_memory_par]
cmp ax, bx
pop dx
pop ax
jna fitsmem

toobig:
mov dx, toobigerr
mov cx, toobigerrlen
jmp error

fitsmem:
; Clipboard fits in free conventional memory.
; However, it is larger than the 64K buffer.
; WINOLDAP only allows us to read the entire clipboard.
; Go ahead and read all that into conventional memory.
; But paste.com will only print the first 64K.
mov ax, _64K_IN_BYTES

fits64k:
mov [data_len], ax

; get clipboard data
mov ax, WOA_GET_CLIP_DATA
xor bx, bx
mov dx, FMT_OEMTXT_CP437
int MUX_INTERRUPT
or  ax, ax		; nonzero status means error
mov dx, getclip
mov cx, getcliplen
jz  error

; get length of clipboard data minus trailing \0 characters
mov cx, [data_len]
mov si, 0

strlen_start:
cmp byte [es:si], 0
jz strlen_done
inc si
loop strlen_start

strlen_done:
mov cx, si

; write buffer to STDOUT
push ds
push es
pop ds
mov ah, DOS_WRITE_HANDLE
mov bx, STDOUT
; ds:dx = buffer
xor dx, dx
int DOS_INTERRUPT
pop ds

mov dx, writeerr
mov cx, writeerrlen
jc  error

; exit with code 0
mov al, 0
jmp exit

error:
; write message to STDERR
; cx contains the error message length
; dx points to the error message
mov bx, STDERR
mov ah, DOS_WRITE_HANDLE
int DOS_INTERRUPT

; exit with code 1
mov al, 1
jmp exit

exit:
; close clipboard if needed
cmp byte [is_open], 0
jz exit_now

push ax
mov ax, WOA_CLOSE_CLIP
int MUX_INTERRUPT
pop ax

exit_now:
mov ah, DOS_EXIT
int DOS_INTERRUPT

section .data	align=2
lacksmem:		db `not enough base memory for 64K buffer\r\n`
lacksmemlen:		equ $-lacksmem
toobigerr:		db `not enough base memory for clipboard data\r\n`
toobigerrlen:		equ  $-toobigerr
noclipboard:		db `no clipboard\r\n`
noclipboardlen:		equ $-noclipboard
openclip:		db `can't open clipboard\r\n`
opencliplen:		equ $-openclip
getclip:		db `can't get clipboard data\r\n`
getcliplen:		equ $-getclip
writeerr:		db `can't write data to stdout\r\n`
writeerrlen:		equ $-writeerr
free_memory_par:	dw 0
data_len:		dw 0
is_open:		db 0
