; nasm -f bin -o clip.com clip.asm
;
; To redirect a file to the Windows clipboard:
; clip.com <file.txt
;
; References:
; * MS KB Q67675: Access to the Windows Clipboard by MS-DOS-Based App
; * w16select.c in GNU Emacs

STDIN			equ	0
STDOUT			equ	1
STDERR			equ	2

; DOS system calls
DOS_INTERRUPT		equ	0x21
DOS_READ_HANDLE		equ	0x3F
DOS_WRITE_HANDLE	equ	0x40
DOS_EXIT		equ	0x4C

; Windows system calls
MUX_INTERRUPT		equ	0x2F
MUX_WINOLDAP		equ	0x17

WOA_VERSION		equ	0x1700
WOA_OPEN_CLIP		equ	0x1701
WOA_EMPTY_CLIP		equ	0x1702
WOA_SET_CLIP_DATA	equ	0x1703
WOA_CLOSE_CLIP		equ	0x1708 
WOA_COMPACT_CLIP	equ	0x1709

; clipboard formats.  Windows converts these on the fly.
FMT_TXT_CP1252		equ	1
FMT_OEMTXT_CP437	equ	7

; buffer size in various units
_64K_IN_PAR		equ	0x1000
_64K_IN_BYTES		equ	0xFFFF
_64K_TERMINATED 	equ	0xFFFE	; 64K - terminating byte

cpu 386
section .text align=2
org 0x100

; DOS assigns all free conventional memory to the program.
; The first 64K is used by the .com segment shared by CS/DS/ES/SS.

; make sure the buffer will fit in free conventional memory
mov bx, [2]		;    PSP next segment
mov ax, ds		; -  data segment
sub bx, ax		; =  size of memory
cmp bx, _64K_IN_PAR
mov dx, lacksmem
mov cx, lacksmemlen
jb  error

; allocate buffer es:0000
mov ax, ds
add ax, _64K_IN_PAR
mov es, ax

; zero out the buffer
mov cx, _64K_IN_BYTES
mov di, 0
zero_buffer:
mov byte [es:di], 0
inc di
loop zero_buffer

; check WinOldAp version
mov ax, WOA_VERSION
int MUX_INTERRUPT
cmp ax, WOA_VERSION
mov dx, noclipboard
mov cx, noclipboardlen
jz  error

; open clipboard
mov ax, WOA_OPEN_CLIP
int MUX_INTERRUPT
or  ax, ax		; nonzero status means error
mov dx, openclip
mov cx, opencliplen
jz  error
mov byte [is_open], 1

; empty clipboard
mov ax, WOA_EMPTY_CLIP
int MUX_INTERRUPT
or  ax, ax		; nonzero status means error
mov dx, emptyclip
mov cx, emptycliplen
jz  error

; read data from STDIN
push ds
push es
pop ds
mov ah, DOS_READ_HANDLE
mov bx, STDIN
mov cx, _64K_TERMINATED
; ds:dx = data buffer
xor dx, dx
int DOS_INTERRUPT
pop ds

mov dx, readerr
mov cx, readerrlen
jc  error

inc ax			; include terminating byte in data size

xor si, si
mov cx, ax		; data size

; verify that the clipboard has space to hold the data
mov ax, WOA_COMPACT_CLIP
xor si, si
int MUX_INTERRUPT
cmp dx, 0
ja clip_big_enough
cmp ax, cx
jae clip_big_enough

clip_too_small:
mov dx, smallcliperr
mov cx, smallcliperrlen
jmp error

clip_big_enough:

; copy data into the clipboard
mov ax, WOA_SET_CLIP_DATA
; es:bx = data
xor bx, bx
; si:cx = size of data
mov dx, FMT_OEMTXT_CP437
int MUX_INTERRUPT
or  ax, ax		; nonzero status means error
mov dx, pasteerr
mov cx, pasteerrlen
jz  error

; exit with code 0
mov al, 0
jmp exit

error:
; write message to STDERR
; cx contains the error message length
; dx points to the error message
mov bx, STDERR
mov ah, DOS_WRITE_HANDLE
int DOS_INTERRUPT

; exit with code 1
mov al, 1
jmp exit

exit:
; close clipboard if needed
cmp byte [is_open], 0
jz exit_now
push ax
mov ax, WOA_CLOSE_CLIP
int MUX_INTERRUPT
pop ax

exit_now:
mov ah, DOS_EXIT
int DOS_INTERRUPT

section .data	align=2
lacksmem:		db `not enough base memory for 64K buffer\r\n`
lacksmemlen:		equ $-lacksmem
noclipboard:		db `no clipboard\r\n`
noclipboardlen:		equ $-noclipboard
emptyclip:		db `can't empty clipboard\r\n`
emptycliplen:		equ $-emptyclip
openclip:		db `can't open clipboard\r\n`
opencliplen:		equ $-openclip
readerr:		db `can't read data from stdin\r\n`
readerrlen:		equ $-readerr
smallcliperr:		db `not enough clipboard memory for data\r\n`
smallcliperrlen:	equ $-smallcliperr
pasteerr:		db `can't paste data to clipboard\r\n$`
pasteerrlen:		equ $-pasteerr
is_open:		db 0
