DECLARE SUB Comline(N AS INTEGER, A() AS STRING, Max AS INTEGER)
DECLARE FUNCTION GameGetCharacter$(validCharacters AS STRING, prompt AS STRING, allowQuit AS INTEGER)
DECLARE FUNCTION GameGetYesNo%(message AS STRING, allowQuit AS INTEGER)
DECLARE FUNCTION GameWrap$(str AS STRING, w AS INTEGER)
DECLARE FUNCTION GodGetMood%(troubleLevel AS INTEGER)
DECLARE SUB GodRecInit (self AS INTEGER, key1 AS STRING, nameL AS STRING, nameN AS STRING, nameC AS STRING)
DECLARE FUNCTION PlayerAscendLevel%()
DECLARE FUNCTION PlayerAscendLevelChance%()
DECLARE FUNCTION PlayerCostHitPoints%(cost AS INTEGER)
DECLARE FUNCTION PlayerCostItemPoints%(cost AS INTEGER)
DECLARE FUNCTION PlayerDescendLevel%()
DECLARE FUNCTION PlayerDescendLevelChance%()
DECLARE FUNCTION PlayerFindAltar%()
DECLARE FUNCTION PlayerFindAltarChance%()
DECLARE FUNCTION PlayerGetEpithet$()
DECLARE FUNCTION PlayerGetGoodie%()
DECLARE FUNCTION PlayerGetGoodieChance%()
DECLARE FUNCTION PlayerIsAlive%()
DECLARE FUNCTION PlayerLoseAltar%()
DECLARE FUNCTION PlayerLoseAltarChance%()
DECLARE SUB PlayerSetLevel(level AS INTEGER)
DECLARE SUB RaceInit (self AS INTEGER, key1 AS STRING, name1 AS STRING, alignmentRestrictions AS STRING)
DECLARE SUB RoleInit (self AS INTEGER, key1 AS STRING, nameFemale AS STRING, nameMale AS STRING, pluralName AS STRING, titleFemale AS STRING, titleMale AS STRING, alignmentRestrictions AS STRING, raceRestrictions AS STRING, greeting AS STRING)

TYPE AlignmentRec
    alignment AS INTEGER
    key1 AS STRING * 1
END TYPE

TYPE Game
    alignment AS INTEGER
    discovery AS INTEGER
    god AS INTEGER
    role AS INTEGER
END TYPE

TYPE God
    answered AS INTEGER
    ignored AS INTEGER
    index AS INTEGER
    minions AS INTEGER
    punished AS INTEGER
    role AS INTEGER
    sacrifices AS INTEGER
    alignment AS INTEGER
END TYPE

TYPE GodRec
    index AS INTEGER
    key1 AS STRING * 1
END TYPE

TYPE Player
    alignment AS INTEGER
    amulet AS INTEGER
    discovery AS INTEGER
    dungeonLevel AS INTEGER
    experienceLevel AS INTEGER
    gender AS INTEGER
    hp AS INTEGER
    itemPoints AS INTEGER
    maxHp AS INTEGER
    nearAltar AS INTEGER
    prayerTimeout AS INTEGER
    quit AS INTEGER
    race AS INTEGER
    role AS INTEGER
    score AS LONG
    stackedMonsters AS INTEGER
    timeout AS INTEGER
    turns AS INTEGER
    turnsOnLevel AS INTEGER
    won AS INTEGER
END TYPE

TYPE Race
    key1 AS STRING * 1
    alignmentRestrictions AS STRING * 8
END TYPE

TYPE Role
    key1 AS STRING * 1
    alignmentRestrictions AS STRING * 8
    raceRestrictions AS STRING * 8
END TYPE

COMMON SHARED alignmentData() AS AlignmentRec
COMMON SHARED alignmentMap() AS INTEGER
COMMON SHARED alignmentNames() AS STRING
COMMON SHARED argv() AS STRING
COMMON SHARED genderData() AS STRING
COMMON SHARED godData() AS GodRec
COMMON SHARED godNames() AS STRING
COMMON SHARED pcEvents() AS STRING
COMMON SHARED pcTurnsOnLevels() AS INTEGER
COMMON SHARED raceData() AS Race
COMMON SHARED raceMap() AS INTEGER
COMMON SHARED raceNames() AS STRING
COMMON SHARED roleData() AS Role
COMMON SHARED roleGreeting() AS STRING
COMMON SHARED roleMap() AS INTEGER
COMMON SHARED roleNameFemale() AS STRING
COMMON SHARED roleNameMale() AS STRING
COMMON SHARED rolePluralName() AS STRING
COMMON SHARED roleTitleFemale() AS STRING
COMMON SHARED roleTitleMale() AS STRING
COMMON SHARED GENERICBLESSINGPRAYERS() AS STRING
COMMON SHARED GENERICHELPPRAYERS() AS STRING
COMMON SHARED GENERICSACRIFICEPRAYERS() AS STRING
COMMON SHARED GodsRoleMap() AS INTEGER

COMMON SHARED alignmentValid AS STRING
COMMON SHARED argc AS INTEGER
COMMON SHARED game AS Game
COMMON SHARED god AS God
COMMON SHARED godAlignmentName AS STRING
COMMON SHARED godName AS STRING
COMMON SHARED pc AS Player
COMMON SHARED pcHe AS STRING
COMMON SHARED pcHim AS STRING
COMMON SHARED pcHis AS STRING
COMMON SHARED pcLowerHe AS STRING
COMMON SHARED pcLowerHim AS STRING
COMMON SHARED pcLowerHis AS STRING
COMMON SHARED pcRaceName AS STRING
COMMON SHARED pcRoleName AS STRING
COMMON SHARED pcTitle AS STRING
COMMON SHARED roleValid AS STRING
COMMON SHARED HEALINGPERTURN AS SINGLE

DIM alignmentData(3) AS AlignmentRec
DIM alignmentMap(255) AS INTEGER
DIM alignmentNames(3) AS STRING
DIM argv(10) AS STRING
DIM genderData(2, 4) AS STRING
DIM godData(12) AS GodRec
DIM godNames(12, 3) AS STRING
DIM pcEvents(5) AS STRING
DIM pcTurnsOnLevels(65) AS INTEGER
DIM raceData(5) AS Race
DIM raceMap(255) AS INTEGER
DIM raceNames(5) AS STRING
DIM roleData(13) AS Role
DIM roleGreeting(13) AS STRING
DIM roleMap(255) AS INTEGER
DIM roleNameFemale(13) AS STRING
DIM roleNameMale(13) AS STRING
DIM rolePluralName(13) AS STRING
DIM roleTitleFemale(13) AS STRING
DIM roleTitleMale(13) AS STRING
DIM GENERICBLESSINGPRAYERS(2) AS STRING
DIM GENERICHELPPRAYERS(7) AS STRING
DIM GENERICSACRIFICEPRAYERS(2) AS STRING
DIM GodsRoleMap(255) AS INTEGER

DIM VERSION AS STRING
VERSION = "1.1"

' Constants
' =========

' Some magic constants. These are multipliers which allow you to
' tweak the scoring system and the difficulty of the game.

' Relative NetHack point value of WFTM gold
CONST GOLDCONSTANT = 7

' Relative "usefulness" of WFTM item points
CONST ITEMCONSTANT = 1

' Relative maximum difficulty of monsters
CONST MONSTERTOUGHNESSCONSTANT = 7

' Level the player must descend to to win the game (amulet is on 50)
CONST MAXDUNGEONLEVEL = 65

' Monster point value = monster HP * dungeon level-dependent number * this
CONST SCOREMULTIPLIER = .5

HEALINGPERTURN = 50 / 8

DIM c AS STRING
DIM i AS INTEGER

' Alignments
CONST LAWFUL = 1
CONST NEUTRAL = 2
CONST CHAOTIC = 3
CONST ALIGNMAX = 3

CALL AlignmentRecInit(LAWFUL, "l", "Lawful")
CALL AlignmentRecInit(NEUTRAL, "n", "Neutral")
CALL AlignmentRecInit(CHAOTIC, "c", "Chaotic")

FOR i = 1 TO 255
    alignmentMap(i) = 0
NEXT i
alignmentValid = ""
FOR i = 1 TO ALIGNMAX
    c = alignmentData(i).key1
    alignmentMap(ASC(c)) = i
    alignmentValid = alignmentValid + c
NEXT i

' Type of prayers
CONST INTERCESSORYPRAYER = "help"
CONST SACRIFICIALPRAYER = "sacrifice"
CONST BLESSINGPRAYER = "blessing"

GENERICHELPPRAYERS(1) = CHR$(34) + "Oh mighty &, hear my plea..." + CHR$(34)
GENERICHELPPRAYERS(2) = CHR$(34) + "Dear &, I need your help." + CHR$(34)
GENERICHELPPRAYERS(3) = CHR$(34) + "Help me, &!" + CHR$(34)
GENERICHELPPRAYERS(4) = CHR$(34) + "HELP!" + CHR$(34)
GENERICHELPPRAYERS(5) = CHR$(34) + "Hey, &, how about a hand for your chosen one..." + CHR$(34)
GENERICHELPPRAYERS(6) = CHR$(34) + "&, if you help me out here I'll never ask you for anything  again..." + CHR$(34)
GENERICHELPPRAYERS(7) = CHR$(34) + "&, you are generous and wise, your virtue far surpassing that of all other gods..." + CHR$(34)
CONST GENERICHELPPRAYERSMAX = 7

GENERICSACRIFICEPRAYERS(1) = CHR$(34) + "O &, accept this humble sacrifice..." + CHR$(34)
GENERICSACRIFICEPRAYERS(2) = CHR$(34) + "Accept this sacrifice into your heavens, oh &..." + CHR$(34)
CONST GENERICSACRIFICEPRAYERSMAX = 2

GENERICBLESSINGPRAYERS(1) = CHR$(34) + "O great and powerful &, I crave a boon." + CHR$(34)
GENERICBLESSINGPRAYERS(2) = CHR$(34) + "&, I beseech thee, bestow upon me some sign of favor." + CHR$(34)
CONST GENERICBLESSINGPRAYERSMAX = 2

' Roles
CONST ARCHAEOLOGIST = 1
CONST BARBARIAN = 2
CONST CAVEMAN = 3
CONST HEALER = 4
CONST KNIGHT = 5
CONST MONK = 6
CONST PRIEST = 7
CONST RANGER = 8
CONST ROGUE = 9
CONST SAMURAI = 10
CONST TOURIST = 11
CONST VALKYRIE = 12
CONST WIZARD = 13
CONST ROLEMAX = 13

CALL RoleInit(ARCHAEOLOGIST, "a", "Archaeologist", "", "Archaeologists", "Digger", "", "ln", "", "")
CALL RoleInit(BARBARIAN, "b", "Barbarian", "", "Barbarians", "Plunderess", "Plunderer", "nc", "ho", "")
CALL RoleInit(CAVEMAN, "c", "Cavewoman", "Caveman", "Cavemen", "Troglodyte", "", "ln", "", "")
CALL RoleInit(HEALER, "h", "Healer", "", "Healers", "Rhizotomist", "", "n", "", "")
CALL RoleInit(KNIGHT, "k", "Knight", "", "Knights", "Gallant", "", "l", "h", "Salutations")
CALL RoleInit(MONK, "m", "Monk", "", "Monks", "Candidate", "", "", "h", "")
CALL RoleInit(PRIEST, "p", "Priestess", "Priest", "", "Aspirant", "", "", "", "")
CALL RoleInit(RANGER, "r", "Ranger", "", "Rangers", "Tenderfoot", "", "nc", "", "")
CALL RoleInit(ROGUE, "R", "Rogue", "", "Rogues", "Footpad", "", "c", "ho", "")
CALL RoleInit(SAMURAI, "s", "Samurai", "", "Samurai", "Hatamoto", "", "l", "h", "Konnichi wa")
CALL RoleInit(TOURIST, "t", "Tourist", "", "Tourists", "Rambler", "", "n", "h", "Aloha")
CALL RoleInit(VALKYRIE, "v", "Valkyrie", "", "Valkyries", "Stripling", "", "ln", "hd", "")
CALL RoleInit(WIZARD, "w", "Wizard", "", "Wizards", "Evoker", "", "nc", "heo", "")

FOR i = 1 TO 255
    roleMap(i) = 0
NEXT i

roleValid = ""
FOR i = 1 TO ROLEMAX
    c = roleData(i).key1
    roleMap(ASC(c)) = i
    roleValid = roleValid + c
NEXT i

CONST RACEMAX = 5

CALL RaceInit(1, "h", "human", "lnc")
CALL RaceInit(2, "d", "dwarf", "l")
CALL RaceInit(3, "e", "elf", "c")
CALL RaceInit(4, "g", "gnome", "n")
CALL RaceInit(5, "o", "orc", "c")

FOR i = 1 TO 255
    raceMap(i) = 0
NEXT i

FOR i = 1 TO RACEMAX
    c = raceData(i).key1
    raceMap(ASC(c)) = i
NEXT i

CONST FEMALE = 1
CONST MALE = 2
CONST GENDERMAX = 2
CONST GENDERNAME = 1
CONST GENDERHE = 2
CONST GENDERHIM = 3
CONST GENDERHIS = 4

genderData(1, 1) = "female"
genderData(1, 2) = "she"
genderData(1, 3) = "her"
genderData(1, 4) = "her"
genderData(2, 1) = "male"
genderData(2, 2) = "he"
genderData(2, 3) = "him"
genderData(2, 4) = "his"

CONST GODRECMAX = 12
CALL GodRecInit(1, "a", "Quetzalcoatl", "Camaxtli", "Huhetotl")
CALL GodRecInit(2, "b", "Mitra", "Crom", "Set")
CALL GodRecInit(3, "c", "Anu", "Ishtar", "Anshar")
CALL GodRecInit(4, "h", "Athena", "Hermes", "Poseidon")
CALL GodRecInit(5, "k", "Lugh", "Brigit", "Manannan Mac Lir")
CALL GodRecInit(6, "m", "Shan Lai Ching", "Chih Sung-tzu", "Huan Ti")
CALL GodRecInit(7, "r", "Mercury", "Venus", "Mars")
CALL GodRecInit(8, "R", "Issek", "Mog", "Kos")
CALL GodRecInit(9, "s", "Amaterasu Omikami", "Raijin", "Susanowo")
CALL GodRecInit(10, "t", "Blind Io", "Lady Luck", "Offler")
CALL GodRecInit(11, "v", "Tyr", "Odin", "Loki")
CALL GodRecInit(12, "w", "Ptah", "Thoth", "Anhur")

FOR i = 1 TO 255
    GodsRoleMap(i) = 0
NEXT i

FOR i = 1 TO GODRECMAX
    c = godData(i).key1
    GodsRoleMap(ASC(c)) = i
NEXT i

CONST GETGOODIE = 1
CONST DESCENDLEVEL = 2
CONST FINDALTAR = 3
CONST ASCENDLEVEL = 4
CONST LOSEALTAR = 5
CONST PCEVENTSMAX = 5

pcEvents(GETGOODIE) = "getGoodie"
pcEvents(DESCENDLEVEL) = "descendLevel"
pcEvents(FINDALTAR) = "findAltar"
pcEvents(ASCENDLEVEL) = "ascendLevel"
pcEvents(LOSEALTAR) = "loseAltar"

CALL Comline(argc, argv(), 10)
RANDOMIZE TIMER MOD 32766

SUB AlignmentRecInit(alignment AS INTEGER, key1 AS STRING, name1 AS STRING)
    alignmentData(alignment).alignment = alignment
    alignmentData(alignment).key1 = key1
    alignmentNames(alignment) = name1
END SUB

SUB GodRecInit (self AS INTEGER, key1 AS STRING, nameL AS STRING, nameN AS STRING, nameC AS STRING)
    godData(self).index = self
    godData(self).key1 = key1
    godNames(self, LAWFUL) = nameL
    godNames(self, NEUTRAL) = nameN
    godNames(self, CHAOTIC) = nameC
END SUB

SUB RaceInit (self AS INTEGER, key1 AS STRING, name1 AS STRING, alignmentRestrictions AS STRING)
    raceData(self).key1 = key1
    raceNames(self) = name1
    IF LEN(alignmentRestrictions) = 0 THEN
        raceData(self).alignmentRestrictions = alignmentValid
    ELSE
        raceData(self).alignmentRestrictions = alignmentRestrictions
    END IF
END SUB

SUB RoleInit (self AS INTEGER, key1 AS STRING, nameFemale AS STRING, nameMale AS STRING, pluralName AS STRING, titleFemale AS STRING, titleMale AS STRING, alignmentRestrictions AS STRING, raceRestrictions AS STRING, greeting AS STRING)
    roleData(self).key1 = key1
    roleNameFemale(self) = nameFemale
    roleNameMale(self) = nameMale
    rolePluralName(self) = pluralName
    roleTitleFemale(self) = titleFemale
    roleTitleMale(self) = titleMale
    IF LEN(alignmentRestrictions) = 0 THEN
        roleData(self).alignmentRestrictions = alignmentValid
    ELSE
        roleData(self).alignmentRestrictions = alignmentRestrictions
    ENDIF
    roleData(self).raceRestrictions = raceRestrictions
    IF LEN(greeting) = 0 THEN
        roleGreeting(self) = "Hello"
    ELSE
        roleGreeting(self) = greeting
    END IF
END SUB

FUNCTION getch$
    DO
        Result$ = INKEY$
    LOOP UNTIL LEN(Result$) > 0
    getch$ = Result$
END FUNCTION

FUNCTION COMMANDX$
    ' QBASIC.EXE lacks COMMAND$ so use COMMANDX env var instead
    COMMANDX$ = ENVIRON$("COMMANDX")
END FUNCTION

SUB Comline(NumArgs AS INTEGER, Args() AS STRING, MaxArgs AS INTEGER) STATIC
    CONST TRUE = -1, FALSE = 0
    NumArgs = 0
    In = FALSE

    ' Get the command line using the COMMAND$ function.
    Cl$ = COMMANDX$
    L = LEN(Cl$)

    ' Go through the command line a character at a time.
    FOR I = 1 TO L
        C$ = MID$(Cl$, I, 1)
        ' Test for character being a blank or a tab.
        IF (C$ <> " " AND C$ <> CHR$(9)) THEN
            ' Neither blank nor tab.
            ' Test to see if you're already
            ' inside an argument.
            IF NOT In THEN
                ' You've found the start of a new argument.
                ' Test for too many arguments.
                IF NumArgs = MaxArgs THEN
                    EXIT FOR
                END IF
                NumArgs = NumArgs + 1
                In = TRUE
            END IF
            ' Add the character to the current argument.
            Args$(NumArgs) = Args$(NumArgs) + C$
        ELSE
            ' Found a blank or a tab.
            ' Set "In an argument" flag to FALSE.
            In = FALSE
        END IF
    NEXT I
END SUB

FUNCTION MAXSINGLE!(val1 AS SINGLE, val2 AS SINGLE)
    IF val1 > val2 THEN
        MAXSINGLE! = val1
    ELSE
        MAXSINGLE! = val2
    END IF
END FUNCTION

FUNCTION MAXINTEGER%(val1 AS INTEGER, val2 AS INTEGER)
    IF val1 > val2 THEN
        MAXINTEGER% = val1
    ELSE
        MAXINTEGER% = val2
    END IF
END FUNCTION

FUNCTION RandomExpovariate%(l AS INTEGER)
    DIM retval AS INTEGER
    retval = INT(LOG(1 - RND) / l) + 1
    RandomExpovariate% = retval
END FUNCTION

FUNCTION RandomRandint%(minval AS INTEGER, maxval AS INTEGER)
    DIM retval AS INTEGER
    retval = INT(RND * ((1 + maxval) - minval)) + minval
    RandomRandint% = retval
END FUNCTION

' The game proper
' ===============

SUB GameCollectInfoFromOptions
    DIM i AS INTEGER
    DIM opt1 AS STRING
    DIM opt2 AS STRING
    DIM result AS INTEGER

    FOR i = 1 TO argc
        opt1 = argv(i)
        IF i + 1 > argc THEN
            opt2 = ""
        ELSE
            opt2 = argv(i + 1)
        END IF
        IF LEFT$(opt1, 2) = "-a" THEN
            IF LEN(opt1) = 3 THEN
                opt2 = MID$(opt1, 3, 1)
            ELSE
                i = i + 1
            END IF
            result = INSTR(alignmentValid, opt2)
            IF result = 0 OR result > ALIGNMAX THEN
                PRINT USING "Invalid value &&& for -&; valid values are: &"; CHR$(34); opt2; CHR$(34); opt1; alignmentValid
            ELSE
                game.alignment = result
            END IF
        ELSEIF opt1 = "-D" THEN
            game.discovery = 1
        ELSEIF LEFT$(opt1, 2) = "-p" THEN
            IF LEN(opt1) = 3 THEN
                opt2 = MID$(opt1, 3, 1)
            ELSE
                i = i + 1
            END IF
            result = INSTR(roleValid, opt2)
            IF result = 0 OR result > ROLEMAX THEN
                PRINT USING "Invalid value &&& for -&; valid values are: &"; CHR$(34); opt2; CHR$(34); opt1; roleValid
            ELSE
                game.role = result
                opt2 = RTRIM$(roleData(game.role).alignmentRestrictions)
                IF LEN(opt2) = 1 THEN
                    game.alignment = alignmentMap(ASC(opt2))
                END IF
            END IF
        ELSE
            CALL GameUsage
            END
        END IF
    NEXT i
END SUB

SUB GameCollectInfoFromUser
    DIM acceptableChars AS STRING
    DIM acceptableKeys AS STRING
    DIM c AS STRING
    DIM i AS INTEGER
    DIM indent AS STRING
    DIM pick AS INTEGER
    DIM prompt AS STRING
    DIM role AS INTEGER
    DIM validAlignments AS STRING
    DIM whatToPick AS STRING

    indent = STRING$(35, " ")
    whatToPick = "a deity for you"
    IF game.alignment > 0 THEN
        whatToPick = "a role for your deity"
    ELSEIF game.role > 0 THEN
        whatToPick = "an alignment for your deity"
    END IF
    prompt = "Shall I pick " + whatToPick + "?"
    pick = GameGetYesNo%(prompt, 1)
    IF pick = 1 THEN
        IF game.role = 0 THEN
            DO WHILE game.role = 0 OR game.role = PRIEST
                game.role = RandomRandint%(1, ROLEMAX)
            LOOP
        END IF
        IF game.alignment = 0 THEN
            validAlignments = RTRIM$(roleData(game.role).alignmentRestrictions)
            c = MID$(validAlignments, RandomRandint%(1, LEN(validAlignments)), 1)
            game.alignment = alignmentMap(ASC(c))
        END IF
    ELSE
        IF game.role = 0 THEN
            CLS
            PRINT "Choose the profession from which you draw worshippers."
            acceptableKeys = ""
            FOR i = 1 TO ROLEMAX
                IF i <> PRIEST THEN
                    PRINT USING "&& - &"; indent; roleData(i).key1; rolePluralName(i)
                    acceptableKeys = acceptableKeys + roleData(i).key1
                END IF
            NEXT i
            PRINT indent; "* - Random"
            PRINT indent; "q - Quit"
            acceptableChars = acceptableKeys + "*q"
            prompt = indent + " (end)"
            c = GameGetCharacter$(acceptableChars, prompt, 0)
            IF c = "q" THEN
                END
            ELSEIF c = "*" THEN
                c = roleData(RandomRandint%(1, ROLEMAX)).key1
            END IF
            game.role = roleMap(ASC(c))
        END IF

        IF game.alignment = 0 THEN
            acceptableKeys = ""
            CLS
            indent = STRING$(9, " ")
            acceptableKeys = RTRIM$(roleData(game.role).alignmentRestrictions)
            IF LEN(acceptableKeys) = 1 THEN
                c = acceptableKeys
            ELSE
                PRINT "Choose an alignment."
                FOR I = 1 TO ALIGNMAX
                    c = alignmentData(i).key1
                    IF INSTR(acceptableKeys, c) > 0 THEN
                        PRINT USING "&& - &"; indent; c; alignmentNames(i)
                    END IF
                NEXT i
                PRINT indent; "* - Random"
                PRINT indent; "q - Quit"
                acceptableChars = acceptableKeys + "*q"
                prompt = indent + " (end)"
                c = GameGetCharacter$(acceptableChars, prompt, 0)
                IF c = "q" THEN
                    END
                ELSEIF c = "*" THEN
                    c = MID$(acceptableKeys, RandomRandint%(1, LEN(acceptableKeys)), 1)
                END IF
            END IF
            game.alignment = alignmentMap(ASC(c))
        END IF
    END IF
END SUB

FUNCTION GameGetCharacter$(validCharacters AS STRING, prompt AS STRING, allowQuit AS INTEGER)
    DIM input1 AS String

    IF LEN(prompt) > 0 THEN
        print PROMPT; " ";
    END IF
    IF allowQuit = 1 THEN
        IF LEN(validCharacters) > 0 THEN
            IF INSTR(validCharacters, "q") = 0 THEN
                validCharacters = validCharacters + "q"
            END IF
        ELSE
            validCharacters = "q"
        END IF
    END IF
    input1 = getch$
    DO WHILE LEN(validCharacters) > 0 AND INSTR(validCharacters, input1) = 0
        input1 = getch$
    LOOP
    IF allowQuit = 1 AND LCASE$(input1) = "q" THEN
        END
    END IF
    GameGetCharacter$ = input1
END FUNCTION

FUNCTION GameGetYesNo%(message AS STRING, allowQuit AS INTEGER)
    DIM result AS STRING
    DIM valid AS STRING
    valid = "yn"
    IF allowQuit = 1 THEN
        VALID = VALID + "q"
    END IF
    result = GameGetCharacter$(valid, message + " [" + valid + "]", 1)
    IF result = "q" THEN
        END
    END IF
    IF result = "y" THEN
        GameGetYesNo% = 1
    ELSE
        GameGetYesNo% = 0
    END IF
END FUNCTION

SUB GameMore(indent AS INTEGER)
    DIM col AS INTEGER
    DIM row AS INTEGER
    DIM result AS STRING

    row = CSRLIN
    col = POS(0)
    PRINT STRING$(indent, " ") + "--more";
    result = GameGetCharacter$("", "", 0)
    LOCATE row, col
    PRINT STRING$(indent + 6, " ")
    LOCATE row, col
END SUB

SUB GameObtainGod
    game.discovery = 0
    game.role = 0
    game.alignment = 0
    CALL GameCollectInfoFromOptions
    IF game.role = 0 OR game.alignment = 0 THEN
        CALL GameSplashScreen
        CALL GameCollectInfoFromUser
    END IF
    CALL GodInit(game.role, game.alignment)
END SUB

SUB GamePlay
    DIM end1 AS STRING
    DIM pluralScore AS STRING

    PRINT USING "&, &, & protector of &."; roleGreeting(god.role); godName; godAlignmentName; rolePluralName(god.role)
    PRINT "Your chosen one has just entered the dungeon."
    PRINT "..."
    DO WHILE PlayerIsAlive% = 1
        CALL PlayerTurn
    LOOP
    IF pc.won = 1 THEN
        end1 = "sacrificing the Amulet"
    ELSEIF pc.quit = 1 THEN
        PRINT USING "What the?!? Your chosen one just quit & quest!"; pcLowerHis
        PRINT "All the other gods laugh at you."
        end1 = "quitting"
    ELSE
        end1 = "dying"
        pc.score = INT(pc.score * .9)
        PRINT "Argh! Your chosen one just died!"            
        PRINT "All the other gods laugh at you."
    END IF
    PRINT ""
    CALL GameUpdateStatus
    GameMore(0)
    PRINT ""
    PRINT ""
    pluralScore = "s"
    IF pc.score = 1 THEN
        pluralScore = ""
    END IF
    PRINT "Your chosen one scored"; pc.score; " point"; pluralScore; " before "; end1; "."
    IF pc.quit = 1 THEN
        PRINT USING "Because & quit, you get none of that."; pcLowerHe
    ELSE
        PRINT "Your tithe of that is"; INT(pc.score * .1); " points."
    END IF
END SUB

SUB GamePrintIntro
    DIM s AS STRING
    PRINT "It is written in your most sacred book:"
    PRINT ""
    PRINT "   After the Creation, the cruel god Moloch rebelled against the"
    PRINT "   authority of Marduk the Creator.  Moloch stole from Marduk the most"
    PRINT "   powerful of all the artifacts of the gods, the Amulet of Yendor,"
    PRINT "   and he hid it in the dark cavities of Gehennom, the Under World,"
    PRINT "   where he now lurks, and bides his time."
    PRINT ""
    s = "You seek to possess the Amulet, and with it to gain deserved ascendance over the other gods."
    PRINT GameWrap$(s, 70)
    PRINT ""
    s = "One young " + pcRaceName + ", now a newly trained " + pcTitle + ", has been heralded from birth as your instrument.  " + pcHe + " is destined to recover the Amulet for you, or die in the attempt.  " + pcHis + " hour of destiny has come.  May " + pcLowerHe + " go bravely with you!"
    PRINT GameWrap$(s, 70)
    PRINT ""
    GameMore(0)
END SUB

SUB GameRun
    CALL GameObtainGod
    CALL GodGetWorshipper
    CLS
    CALL GamePrintIntro
    CLS
    CALL GamePlay
END SUB

SUB GameSplashScreen
    CLS
    PRINT "What Fools These Mortals, Copyright 2003"
    PRINT "        Adapted from code by Leonard Richardson."
    PRINT "                          See license for details."
    PRINT ""
END SUB

SUB GameUpdateStatus
    DIM col AS INTEGER
    DIM mood AS INTEGER
    DIM moods(3) AS STRING
    DIM row AS INTEGER

    moods(1) = ":("
    moods(2) = ":|"
    moods(3) = ":)"
    mood = GodGetMood%(0) + 2

    row = CSRLIN
    col = POS(0)
    LOCATE 1, 1
    PRINT STRING$(79, " ");
    LOCATE 1, 1
    PRINT "Deity:   "; godName; " "; godAlignmentName; " "; moods(mood); " sac:"; LTRIM$(STR$(god.sacrifices)); " ans:"; LTRIM$(STR$(god.answered)); " ign:"; LTRIM$(STR$(god.ignored)); " pun:"; LTRIM$(STR$(god.punished)); " minions:"; LTRIM$(STR$(pc.stackedMonsters)); "("; LTRIM$(STR$(god.minions)); ")";
    LOCATE 2, 1
    PRINT STRING$(79, " ");
    LOCATE 2, 1
    PRINT "Devotee: "; pcRaceName; " "; pcRoleName; " "; pcTitle; " "; "Dlvl:"; LTRIM$(STR$(pc.dungeonLevel)); " HP:"; LTRIM$(STR$(pc.hp)); "("; LTRIM$(STR$(pc.maxHp)); ") T:"; LTRIM$(STR$(pc.turns));
    LOCATE 3,1
    PRINT STRING$(79, "-");
    LOCATE row, col
END SUB

SUB GameUsage
    PRINT "Usage: fools -a alignment -p profession -D"
    PRINT ""
    PRINT "alignment:"
    PRINT "    l = Lawful, n = Neutral, c = Chaotic"
    PRINT ""
    PRINT "profession:"
    PRINT "    a = Archaeologist,  b = Barbarian,   c = Cave dweller"
    PRINT "    h = Healer,         k = Knight,      m = Monk"
    PRINT "    p = Priest,         r = Ranger,      R = Rogue"
    PRINT "    s = Samurai,        t = Tourist,     v = Valkyrie"
    PRINT "    w = Wizard"
    PRINT ""
    END
    SYSTEM
END SUB

FUNCTION GameWrap$(s AS STRING, w AS INTEGER)
    DIM after AS STRING
    DIM before AS STRING
    DIM buf AS STRING
    DIM chunk AS STRING
    DIM found AS INTEGER
    DIM p AS INTEGER
    DIM retval AS STRING

    retval = ""
    buf = s
    DO WHILE LEN(buf) > w
        chunk = RTRIM$(MID$(buf, 1, w))
        found = 0
        FOR p = LEN(chunk) TO 1 STEP -1
            IF MID$(chunk, p, 1) = " " THEN
                found = 1
                EXIT FOR
            END IF
        NEXT p
        IF found = 1 THEN
            before = MID$(buf, 1, p - 1)
            after = MID$(buf, p + 1)
            retval = retval + before + CHR$(10)
            buf = after
        ELSE
            EXIT DO
        END IF
    LOOP
    retval = retval + buf
    GameWrap$ = retval
END FUNCTION

SUB GodEndGame(whoGotAmulet AS STRING)
    DIM otherGods AS STRING
    IF LEN(whoGotAmulet) = 0 THEN
        whoGotAmulet = "self"
    END IF
    GameMore(0)
    CLS

    IF whoGotAmulet = "self" THEN
        PRINT GameWrap$("You feel a rush of power as your chosen one places the Amulet of Yendor on your altar. At last, the Amulet is yours!", 70)
        PRINT ""
        PRINT ""
        SELECT CASE god.alignment
        CASE LAWFUL
            otherGods = godNames(god.index, NEUTRAL) + " AND " + godNames(god.index, CHAOTIC)
        CASE NEUTRAL
            otherGods = godNames(god.index, LAWFUL) + " AND " + godNames(god.index, CHAOTIC)
        CASE CHAOTIC
            otherGods = godNames(god.index, LAWFUL) + " AND " + godNames(god.index, NEUTRAL)
        END SELECT
        PRINT GameWrap$("You rush to the Hall of Spoilers to review the Amulet's capabilities, already dreaming of primacy over " + otherGods, 70)
        PRINT ""
        PRINT "| Amulet of Yendor"
        PRINT "|"
        PRINT "| When carried, you get all of the following (mostly bad):"
        PRINT "|  * You get clairvoyance, if it is not blocked."
        PRINT "|  * When casting spells, your energy is drained."
        PRINT "|  * Hunger is increased (additional to normal amulet hunger)."
        PRINT "|  * Your luck timeout is increased."
        PRINT "|  * Monster difficulty will depend on your deepest level reached, not your"
        PRINT "|    current dungeon level."
        PRINT "|  * Monsters are less likely to be generated asleep."
        PRINT "..."
        PRINT ""
        PRINT "Hmm..."
        PRINT ""
        PRINT GameWrap$("Perhaps Moloch would be amenable to taking the Amulet back. You begin casting about for another chosen one to carry out this important task...", 70)
    END IF
END SUB

FUNCTION GodGetMood%(troubleLevel AS INTEGER)
    ' Translates the prayer timeout into:
    '  1 for pleased,
    '  0 for indifferent, and
    ' -1 for hostile.

    DIM cutoff AS INTEGER
    DIM mood AS INTEGER

    IF troubleLevel = 1 THEN
        cutoff = 200
    ELSE
        cutoff = 100
    END IF

    mood = 1
    IF pc.prayerTimeout > cutoff THEN
        mood = -1
    ELSEIF pc.prayerTimeout > cutoff * .5 THEN
        mood = 0
    ENDIF
    GodGetMood% = mood
END FUNCTION

SUB GodGetWorshipper
    CALL PlayerInit(god.role, god.alignment, game.discovery)
END SUB

SUB GodGrantBoon
    DIM points AS INTEGER
    IF pc.prayerTimeout < 50 AND RandomRandint%(0, 3) = 0 THEN
        PRINT USING "Okay, you send some magical junk & way."; pcLowerHis
        points = RandomRandint%(100, 500)
    ELSE
        PRINT USING "Okay, you bless some of & junk."; pcLowerHis
        points = RandomRandint%(10, 100)
    END IF
    pc.itemPoints = pc.itemPoints + points
END SUB

SUB GodHandlePrayer(type1 AS STRING, arg AS INTEGER)
    SELECT CASE type1
    CASE INTERCESSORYPRAYER
        CALL GodHandlePrayerHelp(arg)
    CASE SACRIFICIALPRAYER
        CALL GodHandlePrayerSacrifice(arg)
    CASE BLESSINGPRAYER
        CALL GodHandlePrayerBlessing
    END SELECT
END SUB

SUB GodHandlePrayerBlessing
    DIM a AS INTEGER
    DIM c AS STRING
    DIM mood AS INTEGER
    DIM options(3) AS STRING
    DIM order(3) AS INTEGER
    DIM what AS STRING

    options(1) = "[g]rant " + pcLowerHim + " a boon"
    options(2) = "[i]gnore " + pcLowerHim
    options(3) = "[s]mite " + pcLowerHim + " for " + pcLowerHis + " impudence"
    order(1) = 1
    order(2) = 2
    order(3) = 3
    mood = GodGetMood%(0)

    IF mood = 0 THEN
        PRINT USING "Hm, pretty presumptuous of & to ask for help."; pcLowerHim
        order(1) = 2
        order(2) = 1
        order(3) = 3
    ELSEIF mood < 0 THEN
        PRINT USING "That & has the audacity to ask for your help?"; PlayerGetEpithet$
        order(1) = 3
        order(2) = 2
        order(3) = 1
    END IF

    what = "Do you want to "
    a = 0
    FOR i = 1 TO 3
        what = what + options(order(i))
        a = a + 1
        IF a = 2 THEN
            what = what + ", or "
        ELSEIF a < 3 THEN
            what = what + ", "
        ENDIF
    NEXT i
    what = what + "?"
    PRINT GameWrap$(what, 70)
    CALL GameUpdateStatus
    c = GameGetCharacter$("gis", "", 1)
    SELECT CASE c
    CASE "g"
        god.answered = god.answered + 1
        CALL GodGrantBoon
        CALL PlayerResetPrayerTimeout
    CASE "i"
        god.ignored = god.ignored + 1
        PRINT USING "Makes sense; & should have to do better!"; pcLowerHe
    CASE "s"
        god.punished = god.punished + 1
        CALL GodPunish
    END SELECT
    CALL GameMore(0)
END SUB

SUB GodHandlePrayerHelp(troubleLevel AS INTEGER)
    DIM a AS INTEGER
    DIM c AS STRING
    DIM mood AS INTEGER
    DIM options(3) AS STRING
    DIM order(3) AS INTEGER
    DIM what AS STRING

    options(1) = "[h]elp"
    options(2) = "[i]gnore"
    options(3) = "[s]mite"
    order(1) = 1
    order(2) = 2
    order(3) = 3
    mood = GodGetMood%(troubleLevel)
    IF mood > 0 THEN
        PRINT "Oh no! Your chosen one is praying for help!"
    ELSEIF mood = 0 THEN
        PRINT USING "Sounds like & needs some help."; pcLowerHe
        order(1) = 2
        order(2) = 1
        order(3) = 3
    ELSE
        PRINT USING "That & is praying for help!"; PlayerGetEpithet$
        order(1) = 3
        order(2) = 2
        order(3) = 1
    END IF 
    what = "Do you want to "
    a = 0
    FOR i = 1 TO 3
        what = what + options(order(i))
        a = a + 1
        IF a = 2 THEN
            what = what + ", or "
        ELSEIF a < 3 THEN
            what = what + ", "
        ENDIF
    NEXT i
    what = what + " " + pcLowerHim + "?"
    PRINT GameWrap$(what, 70)
    CALL GameUpdateStatus
    c = GameGetCharacter$("his", "", 1)
    SELECT CASE c
    CASE "h"
        god.answered = god.answered + 1
        PRINT USING "Okay, you send a generic healing blessing & way."; pcLowerHis
        pc.hp = pc.maxHp
        CALL PlayerResetPrayerTimeout
        IF RandomRandint%(0, 30) = 0 THEN
            PRINT USING "Hm, & died anyway; I guess the healing wasn't what & needed."; pcLowerHe; pcLowerHe
            pc.hp = 0
        END IF
    CASE "i"
        god.ignored = god.ignored + 1
        PRINT "Yeah, let 'em deal with it."
        pc.hp = pc.maxHp / 2
    CASE "s"
        god.punished = god.punished + 1
        CALL GodPunish
    END SELECT
    CALL GameUpdateStatus
    CALL GameMore(0)
END SUB

SUB GodHandlePrayerSacrifice(sacValue AS INTEGER)
    DIM multiplier AS SINGLE
    DIM val1 AS INTEGER
    DIM value AS INTEGER

    god.sacrifices = god.sacrifices + sacValue
    value = -1
    IF sacValue >= pc.maxHp * .40 THEN
        value = 1
        PRINT " (Wow, what a great sacrifice! The other gods will be jealous!)"
    ELSEIF sacValue >= pc.maxHp * .20 THEN
        value = 0
        PRINT " (A pretty decent sacrifice.)"
    ELSE
        PRINT " (Not that great a sacrifice.)"
        IF pc.alignment = CHAOTIC THEN
            multiplier = 500.0
        ELSE
            multiplier = 300.0
        ENDIF
        multiplier = multiplier / 24
        pc.prayerTimeout = INT(MAXSINGLE!(0.0, pc.prayerTimeout - (sacValue * multiplier)))
        IF pc.prayerTimeout = 0 AND (value = 1 OR (value = 0 AND RandomRandint%(0, 10) = 0)) THEN
            val1 = GameGetYesNo%("Show some sign of favor?", 0)
            PRINT ""
            IF val1 = 1 THEN
                CALL GodGrantBoon
                CALL GameUpdateStatus
                CALL GameMore(0)
            END IF
        END IF
    END IF
END SUB

SUB GodInit(role AS INTEGER, alignment AS INTEGER)
    DIM index AS INTEGER
    index = GodsRoleMap(ASC(roleData(role).key1))
    god.answered = 0
    god.ignored = 0
    god.index = index
    god.minions = 0
    god.punished = 0
    god.role = role
    god.sacrifices = 0
    god.alignment = alignment
    godAlignmentName = alignmentNames(alignment)
    godName = godNames(god.index, alignment)
END SUB

SUB GodPunish
    DIM punishment AS STRING
    DIM punishments(5) AS STRING
    DIM p AS INTEGER
    DIM result AS INTEGER

    punishments(1) = "zap"
    punishments(2) = "drain"
    punishments(3) = "ball"
    punishments(4) = "curse"
    punishments(5) = "minion"

    p = RandomRandint%(1, 5)
    punishment = punishments(p)

    SELECT CASE punishment
    CASE "zap"
        PRINT "Hells yeah! Make with the lightning!"
        PRINT "*CRAK*"
        result = PlayerCostItemPoints%(RandomExpovariate%(50))
        result = PlayerCostHitPoints(RandomExpovariate%(100))
        IF pc.itemPoints > 0 AND PlayerIsAlive% = 1 THEN
            PRINT USING "Damn! & didn't even feel it!"; pcLowerHe
            PRINT "Musta had one of those godproof silver dragon scale mails!"
            PRINT "Perhaps summoning some minions will do the trick..."
            PRINT "*SHAZAM*"
            pc.stackedMonsters = 5
        END IF
    case "drain"
        PRINT "All right! Time for some level drain action!"
        PRINT "*WOMP*"
        pc.maxHp = pc.maxHp * .9
        IF pc.hp > pc.maxHp THEN
            pc.hp = pc.maxHp
        END IF
    CASE "ball"
        PRINT USING "This iron ball and chain should teach & a lesson!"; pcLowerHim
        PRINT "*THRUD*"
        result = PlayerCostItemPoints%(RandomRandint%(10, 15))
    CASE "curse"
        PRINT USING "Let & equipment be blackened with a foul curse!"; pcLowerHis
        PRINT "*SHUM*"
        result = PlayerCostItemPoints%(RandomRandint%(20, 50))
    CASE "minion"
        PRINT USING "Your minions will make short work of &!"; pcLowerHim
        PRINT "*SHAZAM*"
        pc.stackedMonsters = 5            
        god.minions = god.minions + 5
    END SELECT
END SUB

FUNCTION PlayerAscendLevel%
    IF pc.dungeonLevel = 1 OR pc.dungeonLevel >= MAXDUNGEONLEVEL - 1 THEN
        PlayerAscendLevel% = 0
    ELSE
        PlayerSetLevel(pc.dungeonLevel - 1)
        PlayerAscendLevel% = 1
    END IF
END FUNCTION

FUNCTION PlayerAscendLevelChance%
    PlayerAscendLevelChance% = 100
END FUNCTION

FUNCTION PlayerCostHitPoints%(cost AS INTEGER)
    IF pc.hp > 0 THEN
        pc.hp = MAXINTEGER%(0, pc.hp - cost)
        PlayerCostHitPoints% = 1
    ELSE
        pc.hp = 0
        PlayerCostHitPoints% = 0
    END IF
END FUNCTION

FUNCTION PlayerCostItemPoints%(cost AS INTEGER)
    IF pc.itemPoints > 0 THEN
        pc.itemPoints = MAXINTEGER%(0, pc.itemPoints - cost)
        PlayerCostItemPoints% = 1
    ELSE
        pc.itemPoints = 0
        PlayerCostItemPoints% = 0
    END IF
END FUNCTION

FUNCTION PlayerDescendLevel%
    PlayerSetLevel(pc.dungeonLevel + 1)
    IF RandomRandint%(1, 4) = 1 THEN
        pc.nearAltar = 0
    END IF
    IF pc.dungeonLevel = 50 THEN
        CALL PlayerGetAmulet
    END IF
    IF pc.dungeonLevel = MAXDUNGEONLEVEL - 1 THEN
        PRINT "You sense your chosen one's presence on the Astral Plane..."
        CALL GameMore(0)
    END IF
    IF pc.dungeonLevel = MAXDUNGEONLEVEL AND pc.amulet = 1 THEN
        CALL PlayerEndGame
    END IF
    PlayerDescendLevel% = 1
END FUNCTION

FUNCTION PlayerDescendLevelChance%
    PlayerDescendLevelChance% = MAXINTEGER%(5, 100 - pc.turnsOnLevel)
END FUNCTION

SUB PlayerEndGame
    pc.won = 1
    PRINT GameWrap$(CHR$(34) + "Oh " + godName + ", your humble servant offers to your glory the object of this sacred quest..." + CHR$(34), 70)
    GodEndGame("")
END SUB

SUB PlayerFightMonster
    DIM cutoff AS INTEGER
    DIM damage AS INTEGER
    DIM done AS INTEGER
    DIM maxMonsterHp AS INTEGER
    DIM monsterHp AS INTEGER
    DIM multiplier AS INTEGER
    DIM quitChance AS INTEGER
    DIM result AS INTEGER
    DIM toughness AS INTEGER
    DIM value AS INTEGER

    toughness = (RandomRandint%(0, 6) - 3) + pc.dungeonLevel / 2
    IF toughness < 0 THEN
        toughness = 1
    END IF
    monsterHp = RandomRandint%(toughness, toughness * MONSTERTOUGHNESSCONSTANT)
    maxMonsterHp = monsterHp
    value = monsterHp
    IF monsterHp < 1 THEN
        monsterHp = 1
    END IF
    DO WHILE monsterHp > 0 AND PlayerIsAlive%
        ' You attack
        done = 0
        cutoff = MAXINTEGER%(5, INT(pc.maxHp * .10))
        IF pc.hp < cutoff THEN
            IF pc.discovery = 1 THEN
                quitChance = 20
            ELSE
                quitChance = 4
            END IF
            IF pc.hp >= 5 THEN
                IF RandomRandint%(0, quitChance) > 0 THEN
                    CALL PlayerPray(INTERCESSORYPRAYER, RandomRandint%(1, 3))
                    done = 1
                ENDIF
            ELSE
                IF RandomRandint%(0, quitChance) > 0 THEN
                    CALL PlayerPray(INTERCESSORYPRAYER, RandomRandint%(1, 3))
                    done = 1
                ELSE
                    pc.quit = 1
                    done = 1
                    EXIT DO
                END IF
            END IF
        END IF
        IF done = 0 THEN
            multiplier = 1
            IF RandomRandint%(0, 3) = 0 THEN
                ' Miss
                multiplier = 0
            ELSEIF pc.itemPoints > 0 AND RandomRandint%(0, 3) > 0 THEN
                ' More damage, but also some loss of item points
                multiplier = RandomRandint%(0, 10)
            ELSE
                multiplier = 1
            END IF
            IF multiplier > 1 THEN
                IF PlayerCostItemPoints%(multiplier * RandomRandint%(1, 4)) = 0 THEN
                    multiplier = 1
                END IF
            END IF
            damage = RandomRandint%(3, pc.dungeonLevel + 3) * multiplier
            monsterHp = monsterHp - damage
        END IF

        ' Monster attacks
        IF monsterHp > 0 THEN
            damage = 0
            IF RandomRandint%(0, 3) = 0 THEN
                ' Miss
            ELSE
                damage = RandomRandint%(0, toughness)
            END IF
            ' Chance of you giving up item points to absorb damage.
            IF damage > 0 AND RandomRandint%(0, 2) = 0 THEN
                multiplier = RandomRandint%(2, 10)
                ' a = pc.itemPoints
                IF PlayerCostItemPoints%(multiplier / RandomRandint%(1, 4)) = 0 THEN
                    ' PRINT a; " -> "; pc.itemPoints
                    damage = INT(damage * (multiplier / multiplier + 1))
                    pc.hp = pc.hp - damage
                END IF
            END IF
            IF pc.discovery = 1 AND pc.hp <= 0 THEN
                pc.hp = pc.maxHp
            END IF
        END IF

        IF PlayerIsAlive% = 1 THEN
            ' Pet logic, bleah
            pc.score = pc.score + INT(value * (pc.dungeonLevel * (pc.dungeonLevel * .04) * SCOREMULTIPLIER))
            pc.hp = pc.hp + 1
            IF RandomRandint(0, 50) = 0 THEN
                pc.maxHp = pc.maxHp + 1
            END IF
            IF pc.nearAltar AND RandomRandint%(0, 3) = 0 THEN
                CALL PlayerPray(SACRIFICIALPRAYER, maxMonsterHp)
            END IF
            IF RandomRandint%(0, 4) = 0 THEN
                ' Woohoo            
                result = PlayerGetGoodie%
            END IF
        END IF
    LOOP
END SUB

FUNCTION PlayerFindAltar%
    pc.nearAltar = 1
    IF RandomRandint%(0, 3) = 0 THEN
        CALL PlayerPray(BLESSINGPRAYER, 0)
    END IF
    PlayerFindAltar% = 1
END FUNCTION

FUNCTION PlayerFindAltarChance%
    PlayerFindAltarChance% = MAXINTEGER%(300, 150 + pc.turnsOnLevel)
END FUNCTION

SUB PlayerGetAmulet
    IF pc.amulet = 0 THEN
        pc.amulet = 1
        PRINT USING "& got the Amulet! Awesome!"; pcHe
        CALL GameMore(0)
    END IF
END SUB

FUNCTION PlayerGetEpithet$
    DIM choice AS INTEGER
    DIM choices(4) AS STRING
    DIM choicemax AS INTEGER
    choices(1) = "so-and-so"
    choices(2) = "pathetic mortal"
    choices(3) = "weakling"
    choicemax = 3
    IF pc.gender = MALE THEN
        choicemax = choicemax + 1
        choices(choicemax) = "S.O.B"
    END IF
    choice = RandomRandint%(1, choicemax)
    PlayerGetEpithet$ = choices(choice)
END FUNCTION

FUNCTION PlayerGetGoodie%
    DIM value AS INTEGER
    value = RandomRandint%(0, MAXINTEGER%(pc.dungeonLevel, INT(1.5 * pc.dungeonLevel) - pc.turnsOnLevel))
    IF RandomRandint%(0, 3) = 0 THEN
        ' Gold; includes amortized value of gold from items sold at shops
        pc.score = pc.score + value * GOLDCONSTANT
    ELSEIF RandomRandint%(0, 5) = 0 THEN
        ' Something useful
        pc.itemPoints = pc.itemPoints + INT(value * ITEMCONSTANT)
        IF pc.nearAltar = 1 AND RandomRandint%(0, 20) = 0 THEN
            CALL PlayerPray(BLESSINGPRAYER, 0)
        END IF
    ELSE
        ' Otherwise, it's useless junk
    END IF
    PlayerGetGoodie% = 1
END FUNCTION

FUNCTION PlayerGetGoodieChance%
    PlayerGetGoodieChance% = 20 + (pc.turnsOnLevel / 5)
END FUNCTION

FUNCTION PlayerGetPrayerDescription$(type1 AS STRING)
    DIM a AS STRING
    DIM i AS INTEGER
    DIM p AS INTEGER

    SELECT CASE type1
    CASE INTERCESSORYPRAYER
        i = RandomRandint%(1, GENERICHELPPRAYERSMAX)
        a = GENERICHELPPRAYERS(i)
    CASE SACRIFICIALPRAYER
        i = RandomRandint%(1, GENERICSACRIFICEPRAYERSMAX)
        a = GENERICSACRIFICEPRAYERS(i)
    CASE BLESSINGPRAYER
        i = RandomRandint%(1, GENERICBLESSINGPRAYERSMAX)
        a = GENERICBLESSINGPRAYERS(i)
    END SELECT
    p = INSTR(a, "&")
    IF p > 0 THEN
        PlayerGetPrayerDescription$ = MID$(a, 1, p - 1) + godName + MID$(a, p + 1)
    ELSE
        PlayerGetPrayerDescription$ = a
    END IF
END FUNCTION

SUB PlayerHandleEvent
    DIM chance AS INTEGER
    DIM happened AS INTEGER
    DIM i AS INTEGER

    happened = 0
    IF pc.stackedMonsters > 0 THEN
        pc.stackedMonsters = pc.stackedMonsters - 1
    ELSE
        IF happened = 0 THEN
            chance = PlayerGetGoodieChance%
            IF chance > 0 AND RandomRandint%(0, chance) = 0 THEN
                happened = PlayerGetGoodie%
            END IF
        END IF
        IF happened = 0 THEN
            chance = PlayerDescendLevelChance%
            IF chance > 0 AND RandomRandint%(0, chance) = 0 THEN
                happened = PlayerDescendLevel%
            END IF
        END IF
        IF happened = 0 THEN
            chance = PlayerFindAltarChance%
            IF chance > 0 AND RandomRandint%(0, chance) = 0 THEN
                happened = PlayerFindAltar%
            END IF
        END IF
        IF happened = 0 THEN
            chance = PlayerAscendLevelChance%
            IF chance > 0 AND RandomRandint%(0, chance) = 0 THEN
                happened = PlayerAscendLevel%
            END IF
        END IF
        IF happened = 0 THEN
            chance = PlayerLoseAltarChance%
            IF chance > 0 AND RandomRandint%(0, chance) = 0 THEN
                happened = PlayerLoseAltar%
            END IF
        END IF
        IF happened = 0 THEN
            CALL PlayerFightMonster
        END IF
    END IF
END SUB

SUB PlayerInit(role AS INTEGER, alignment AS INTEGER, discovery AS INTEGER)
    DIM a AS STRING
    DIM aRestrict AS STRING
    DIM classOkay AS INTEGER
    DIM i AS INTEGER
    DIM isException AS INTEGER
    DIM possibleRaces AS STRING
    DIM possibleRacesModuloClass AS STRING
    DIM r AS STRING
    DIM rRestrict AS STRING
    DIM validAlignments AS STRING

    pc.discovery = discovery
    pc.amulet = 0
    pc.won = 0
    pc.quit = 0
    ' Monsters sent as part of a punishment.
    pc.stackedMonsters = 0
    pc.hp = 15
    pc.maxHp = 15
    pc.itemPoints = 50
    pc.score = 0
    FOR i = 1 TO MAXDUNGEONLEVEL
        pcTurnsOnLevels(i) = 0
    NEXT i
    pc.dungeonLevel = 1
    pc.turnsOnLevel = 0
    pc.turns = 0
    ' PlayerSetLevel(1) would be a NOP here
    pc.experienceLevel = 1
    pc.nearAltar = 0
    pc.prayerTimeout = 300
    ' This might change later; they might be a priest.
    pc.role = role
    pc.alignment = alignment
    IF roleData(role).key1 = "v" THEN
        pc.gender = FEMALE
    ELSE
        pc.gender = RandomRandint%(FEMALE, MALE)
    END IF
    pcLowerHe = genderData(pc.gender, GENDERHE)
    pcLowerHim = genderData(pc.gender, GENDERHIM)
    pcLowerHis = genderData(pc.gender, GENDERHIS)
    pcHe = UCASE$(MID$(pcLowerHe, 1, 1)) + MID$(pcLowerHe, 2)
    pcHim = UCASE$(MID$(pcLowerHim, 1, 1)) + MID$(pcLowerHim, 2)
    pcHis = UCASE$(MID$(pcLowerHis, 1, 1)) + MID$(pcLowerHis, 2)
    possibleRaces = ""
    aRestrict = RTRIM$(roleData(role).alignmentRestrictions)
    rRestrict = RTRIM$(roleData(role).raceRestrictions)
    a = alignmentData(pc.alignment).key1
    FOR i = 1 TO RACEMAX
         r = raceData(i).key1
         validAlignments = RTRIM$(raceData(i).alignmentRestrictions)
         IF INSTR(validAlignments, a) > 0 THEN
             classOkay = 1
             IF LEN(aRestrict) > 0 AND INSTR(aRestrict, a) = 0 THEN
                 isException = 1
             ELSEIF LEN(rRestrict) > 0 AND INSTR(rRestrict, r) = 0 THEN
                 isException = 1
             ELSE
                 isException = 0
             END IF
         ELSE
             classOkay = 0
             isException = 1
         END IF
         IF classOkay = 1 THEN
             possibleRacesModuloClass = possibleRacesModuloClass + r
         END IF
         IF isException = 0 THEN
             possibleRaces = possibleRaces + r
         ELSE
             ' exclude race from possibleRaces
         END IF
    NEXT i
    ' If there's only one possible alignment and the player isn't
    ' of this alignment, they've got to be a priest.
    IF LEN(possibleRaces) > 0 AND RandomRandint%(1, ROLEMAX) <> PRIEST THEN
        r = MID$(possibleRaces, RandomRandint%(1, LEN(possibleRaces)), 1)
        pc.race = raceMap(ASC(r))
    ELSE
        pc.role = PRIEST
        r = MID$(possibleRacesModuloClass, RandomRandint%(1, LEN(possibleRacesModuloClass)), 1)
        pc.race = raceMap(ASC(r))
    END IF
    pcRaceName = raceNames(pc.race)
    pcRoleName = ""
    pcTitle = ""
    IF pc.gender = MALE THEN
        pcRoleName = roleNameMale(pc.role)
        pcTitle = roleTitleMale(pc.role)
    END IF
    IF LEN(pcRoleName) = 0 THEN
        pcRoleName = roleNameFemale(pc.role)
    END IF
    IF LEN(pcTitle) = 0 THEN
        pcTitle = roleTitleFemale(pc.role)
    END IF
END SUB

FUNCTION PlayerIsAlive%
    IF pc.hp > 0 AND pc.quit = 0 AND pc.won = 0 THEN
        PlayerIsAlive% = 1
    ELSE
        PlayerIsAlive% = 0
    END IF
END FUNCTION

FUNCTION PlayerLoseAltar%
    IF pc.nearAltar = 1 THEN
        pc.nearAltar = 0
        PlayerLoseAltar% = 1
    ELSE
        PlayerLoseAltar% = 0
    END IF
END FUNCTION

FUNCTION PlayerLoseAltarChance%
    PlayerLoseAltarChance% = 100
END FUNCTION

SUB PlayerPray(type1 AS STRING, arg AS INTEGER)
    PRINT GameWrap$(PlayerGetPrayerDescription$(type1), 70)
    CALL GodHandlePrayer(type1, arg)
END SUB

SUB PlayerResetPrayerTimeout
    DIM reset1 AS INTEGER

    reset1 = 350
    ' TODO: crowning
    IF pc.amulet = 1 THEN
        reset1 = reset1 + 100
    END IF
    pc.prayerTimeout = RandomExpovariate%(reset1)
END SUB

SUB PlayerSetLevel(level AS INTEGER)
    IF level <> pc.dungeonLevel THEN
        PcTurnsOnLevels(pc.dungeonLevel) = pc.turnsOnLevel
        pc.dungeonLevel = level
        pc.turnsOnLevel = PcTurnsOnLevels(level)
    END IF
END SUB

SUB PlayerTurn
    pc.turns = pc.turns + 1
    pc.turnsOnLevel = pc.turnsOnLevel + 1
    IF pc.prayerTimeout > 0 THEN
        pc.prayerTimeout = MAXINTEGER%(0, pc.prayerTimeout - 1)
    END IF
    pc.hp = pc.hp + INT(HEALINGPERTURN)
    IF pc.hp > pc.maxHp THEN
        pc.hp = pc.maxHp
    END IF
    CALL PlayerHandleEvent
    CALL GameUpdateStatus
END SUB

GameRun
SYSTEM
