#include <stddef.h>

int system_dos(int *blk, char *argv0) {
#asm
    mov bx, sp
    push bp
    push bx
    push cx
    push dx
    push si
    push es

#if __FIRST_ARG_IN_AX__
#error First arg is in a register, system.c does not yet support this
#endif
    mov dx, [bx+4]    ! argv0
    mov bx, [bx+2]    ! blk
    push ds
    pop es

    mov [bx+4], ds    ! segment for command tail
    mov [bx+8], cs    ! segment for first FCB
    mov [bx+12], cs   ! segment for second FCB

    mov ax, #$4b00    ! exec (DOS2 call)
    int #$21
    jnc systemok

    ! set errno
    call exterror

    ! get true error code into ax
    ! mov ah, #$59
    ! xor bx, bx
    ! int #$21
    
systemok:
    pop es
    pop si
    pop dx
    pop cx
    pop bx
    pop bp
#endasm
}

#define CMDTAIL_LEN 128

int System(char *cmd) {
    int argc = 0,
        len = 0,
        retval = 0,
        exec_param_blk[11];
    char *argv0,
        *argv,
        *shell,
        ctail[CMDTAIL_LEN];

    shell = getenv("COMSPEC");
    if (shell == NULL) {
        shell = "C:\\COMMAND.COM";
    }
    argv0 = shell;

    /* reserve a byte for arguments length */
    ctail[0] = 0;

    /* prepend "/C " to the "command tail" */
    ctail[1] = '/';
    ctail[2] = 'C';
    ctail[3] = ' ';
    argv = &ctail[4];

    /* copy arguments into "command tail" */
    strncpy(argv, cmd, CMDTAIL_LEN - 5);
    ctail[CMDTAIL_LEN - 1] = 0;

    /* copy arguments length into "command tail" */
    argv = &ctail[1];
    len = strlen(argv);
    ctail[0] = (char)len;

    /* set up an exec param block */
    memset(exec_param_blk, 0, sizeof(exec_param_blk));
    exec_param_blk[0] = 0;     /* env for child, use ours */
    exec_param_blk[1] = ctail; /* command tail offset */
    exec_param_blk[2] = 0;     /* command tail segment */
    exec_param_blk[3] = 0x5c;  /* first FCB, use our stdin */
    exec_param_blk[4] = 0;     /* first FCB segment */
    exec_param_blk[5] = 0x6c;  /* second FCB, use our stdout */
    exec_param_blk[6] = 0;     /* second FCB segment */

    retval = system_dos(exec_param_blk, argv0);
    return retval;
}
