/*
extern char ** environ;
This variable is not functional in the dev86 bcc DOS target.
See libc/msdos/msdos.c:229-240
char ** environ = 0;
...

It does grab __envseg from the PSP... tally ho!
*/

extern int __envseg;

/* DOS environment size ranges from 160 to 992 bytes */
#define ENV_SIZE_DOS31 160
#define ENV_SIZE_DOS50 256
#define ENV_SIZE_MAX 992
#define ENV_SIZE 992

int getenv_initialized = 0; /* whether my_environ is initialized */
char my_environ[ENV_SIZE];  /* buffer for copy of DOS environment */

/* getenv_init() - copy DOS environment into my_environ */

int getenv_init()
{
   int es = __get_es();
   int ei;
   char ec;
   __set_es(__envseg);
   for (ei = 0; ei < ENV_SIZE; ei++) {
      ec = __peek_es(ei);
      my_environ[ei] = ec;
   }
   __set_es(es);
   getenv_initialized = 1;
   return;
}

char *
getenv(name)
char * name;
{
   register int l;
   register char * ep;
   int len, offset = 0;

   if (!getenv_initialized) {
      getenv_init();
   }

   ep = &my_environ[offset];
   l = strlen(name);

   if( ep == 0 || l == 0 ) return 0;

   len = strlen(ep);
   while (len > 0 && offset < ENV_SIZE)
   {
      if( *ep == *name && memcmp(name, ep, l) == 0 && (ep)[l] == '=' ) {
         return ep + l + 1;
      }
      offset += len + 1;
      ep = &my_environ[offset];
      len = strlen(ep);
   }
   return 0;
}

