/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <stdlib.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "struct.h"
#include "config.h"

/*
 * Global variables
 */
extern	Widget	dialog;			/* Das Dialogwidget */
extern	Widget	text_1, text_2;		/* Zum Verschieben braucht man 2 Text,
					   sonst nur einen */
#ifdef	HAS_QUOTA
extern	Widget	quota_label;		/* Fuer die Quotas einen Label */
#endif
extern	Pixmap	Icon_Newdir_PM;
extern	Pixmap	icon_pixmap;

extern	Boolean		FILE_CHANGED;
extern	Boolean		DIR_CHANGED;
extern	Folder_Glyph	*folder;
extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Dir_Glyph	*selc_g;

/*
 * Function Prototypes
 */
void	init_newdir (char *file);
void	exec_newdir (void);

extern	Widget		makeDialog     (Dimension text,
					char *label1, char *label2,
					char *text1, char *text2,
					char *title, Boolean cancel, Boolean OVERRIDE);
extern	XtActionProc	refresh_files  (Widget w, XExposeEvent *e,
					String *s, Cardinal *c);
extern	void		hide_dialog    (void);
extern	void		WARNING	       (char *text);
extern	void		setSize	       (void);

#ifdef	HAS_QUOTA
extern	void		showQuota      (Widget w);
#endif



/*********************************************************
 * name:	init_newdir
 * description:	erzeugt ein Fenster mit 1 text zum Erstellen
 *		neuer Directories
 * input:	char *file
 * output:	none
 * date:	10.5.93
 *********************************************************/
void	init_newdir (char *file)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	icon_pixmap = Icon_Newdir_PM;
	but = makeDialog(1,"Name :","",file,NULL,"Creating new Directories",TRUE,FALSE);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) exec_newdir,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);

	/*
	 * Max und Minsize setzen
	 */
	setSize();
}

/*********************************************************
 * name:	exec_newdir
 * description:	neues Directory erzeugen
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
void	exec_newdir (void)
{
	char	*from;
	Arg	args[1];
	char	buf[1024];

	/*
	 * Die Texte der beiden Textfelder holen
	 */
	XtSetArg(args[0],XtNstring,&from);
	XtGetValues(text_1,args,1);

	/*
	 * Ueberpruefen ob in beiden ein Text steht, sonst
	 * Warnung ausgeben
	 */
	if (!strlen(from)) {
		WARNING ("Insuffisant Arguments.\nOperation aborted.");
		return;
	}

	/*
	 * Befehl generieren und ausfuehren
	 */
	sprintf(buf,"mkdir -p %s",from);
	if (SYSTEM(buf)) {
		WARNING("Creating directory faild.");
		return;
	}
	else {
		/*
		 * Dialogfenster loeschen
		 */
		XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig
		 */
#ifdef	HAS_QUOTA
		showQuota(quota_label);
#endif
	}
}

