/****************************************************************************
 * This module is based on Twm, but has been siginificantly modified 
 * by Rob Nation (nation@rocket.sanders.lockheed.com 
 ****************************************************************************/
/*****************************************************************************/
/**       Copyright 1988 by Evans & Sutherland Computer Corporation,        **/
/**                          Salt Lake City, Utah                           **/
/**  Portions Copyright 1989 by the Massachusetts Institute of Technology   **/
/**                        Cambridge, Massachusetts                         **/
/**                                                                         **/
/**                           All Rights Reserved                           **/
/**                                                                         **/
/**    Permission to use, copy, modify, and distribute this software and    **/
/**    its documentation  for  any  purpose  and  without  fee is hereby    **/
/**    granted, provided that the above copyright notice appear  in  all    **/
/**    copies and that both  that  copyright  notice  and  this  permis-    **/
/**    sion  notice appear in supporting  documentation,  and  that  the    **/
/**    names of Evans & Sutherland and M.I.T. not be used in advertising    **/
/**    in publicity pertaining to distribution of the  software  without    **/
/**    specific, written prior permission.                                  **/
/**                                                                         **/
/**    EVANS & SUTHERLAND AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD    **/
/**    TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES  OF  MERCHANT-    **/
/**    ABILITY  AND  FITNESS,  IN  NO  EVENT SHALL EVANS & SUTHERLAND OR    **/
/**    M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL  DAM-    **/
/**    AGES OR  ANY DAMAGES WHATSOEVER  RESULTING FROM LOSS OF USE, DATA    **/
/**    OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER    **/
/**    TORTIOUS ACTION, ARISING OUT OF OR IN  CONNECTION  WITH  THE  USE    **/
/**    OR PERFORMANCE OF THIS SOFTWARE.                                     **/
/*****************************************************************************/


/***********************************************************************
 *
 * fvwm menu code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#include <sys/types.h>
#include <sys/time.h>

#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

int menu_on=0;

MenuRoot *ActiveMenu = NULL;		/* the active menu */
MenuItem *ActiveItem = NULL;		/* the active menu item */

int menuFromFrameOrWindowOrTitlebar = FALSE;

extern char *Action;
extern int Context;
extern FvwmWindow *ButtonWindow, *Tmp_win;
extern XEvent Event;
int Stashed_X, Stashed_Y;

#ifdef __STDC__
void DrawTrianglePattern(Window,GC,GC,GC,int,int,int,int);
void DrawSeparator(Window, GC,GC,int, int,int,int,int);
#else
void DrawTrianglePattern();
void DrawSeparator();
#endif

/****************************************************************************
 *
 * Initiates a menu pop-up
 *
 ***************************************************************************/
#ifdef __STDC__
int do_menu (MenuRoot *menu)
#else
int do_menu (menu)
MenuRoot *menu;
#endif
{
  int prevStashedX,prevStashedY;
  MenuRoot *PrevActiveMenu;
  MenuItem *PrevActiveItem;
  int retval=MENU_NOP;
  int x = Event.xbutton.x_root;
  int y = Event.xbutton.y_root;

  /* this condition could get ugly */
  if(menu->in_use)
    return MENU_ERROR;

  if(menu_on)
    {
      prevStashedX = Stashed_X;
      prevStashedY = Stashed_Y;

      PrevActiveMenu = ActiveMenu;
      PrevActiveItem = ActiveItem;
    }
  else
    {
      if(!GrabEm(MENU))
	{
	  XBell(dpy,0);
	  return MENU_DONE;
	}
    }

  if (PopUpMenu (menu, x, y))
    retval = UpdateMenu();
  else
    XBell (dpy, 0);

  ActiveMenu = PrevActiveMenu;
  ActiveItem = PrevActiveItem;
  if((ActiveItem)&&(menu_on))
    ActiveItem->state = 1;
  Stashed_X = prevStashedX;
  Stashed_Y = prevStashedY;

  if(!menu_on)
    {
      UngrabEm();
      WaitForButtonsUp();
    }
  return retval;
}

/***********************************************************************
 *
 *  Procedure:
 *	RelieveRectangle - add relief lines to a rectangular window
 *
 ***********************************************************************/
#ifdef __STDC__
void RelieveRectangle(Window win,int x,int y,int w, int h,GC Hilite,GC Shadow)
#else
void RelieveRectangle(win, x, y, w, h, Hilite, Shadow)
Window win;
int x, y, w, h;
GC Hilite, Shadow;
#endif
{
  XDrawLine(dpy, win, Hilite, x, y, w+x-1, y);
  XDrawLine(dpy, win, Hilite, x, y, x, h+y-1);

  XDrawLine(dpy, win, Shadow, x, h+y-1, w+x-1, h+y-1);
  XDrawLine(dpy, win, Shadow, w+x-1, y, w+x-1, h+y-1);
}

/***********************************************************************
 *
 *  Procedure:
 *	RelieveHalfRectangle - add relief lines to the sides only of a
 *      rectangular window
 *
 ***********************************************************************/
#ifdef __STDC__
void RelieveHalfRectangle(Window win,int x,int y,int w,int h,
			  GC Hilite,GC Shadow)
#else
void RelieveHalfRectangle(win, x, y, w, h, Hilite,Shadow)
Window win;
int x, y, w, h;
GC Hilite, Shadow;
#endif 
{
  XDrawLine(dpy, win, Hilite, x, y, x, h+y-1);
  XDrawLine(dpy, win, Hilite, x+1, y, x+1, h+y-1);

  XDrawLine(dpy, win, Shadow, w+x-1, y, w+x-1, h+y-1);
  XDrawLine(dpy, win, Shadow, w+x-2, y, w+x-2, h+y-1);
}


/***********************************************************************
 *
 *  Procedure:
 *	PaintEntry - draws a single entry in a poped up menu
 *
 ***********************************************************************/
#ifdef __STDC__
void PaintEntry(MenuRoot *mr, MenuItem *mi)
#else
void PaintEntry(mr, mi)
MenuRoot *mr;
MenuItem *mi;
#endif
{
  int y_offset,text_y,y,d, y_height;
  GC ShadowGC, ReliefGC;

  y_offset = mi->y_offset;
  y_height = mi->y_height;
  text_y = y_offset + Scr.StdFont.y;

  ShadowGC = Scr.StdShadowGC;
  if(Scr.d_depth<2)
    ReliefGC = Scr.StdShadowGC;
  else
    ReliefGC = Scr.StdReliefGC;

  XClearArea(dpy, mr->w, 0,y_offset,mr->width,y_height,0);
  if ((mi->state)&&(mi->func != F_TITLE)&&(mi->func != F_NOP)&&*mi->item)
    RelieveRectangle(mr->w, 2, y_offset, mr->width-4, mi->y_height,
                     ReliefGC,ShadowGC);
  RelieveHalfRectangle(mr->w, 0, y_offset, mr->width,
		       y_height, ReliefGC, ShadowGC);

  if(mi->func == F_TITLE)
    {
      if(mi->next != NULL)
	{
	  DrawSeparator(mr->w,ShadowGC,ReliefGC,5, y_offset+y_height-3,
			mr->width-6, y_offset+y_height-3,1);
	}
      if(mi != mr->first)
	{
	  text_y += HEIGHT_EXTRA_TITLE>>1;
	  DrawSeparator(mr->w,ShadowGC,ReliefGC,5, y_offset+1,
			mr->width-6, y_offset+1,1);
	}
    }
  else
    text_y += HEIGHT_EXTRA>>1;
  if(mi->func == F_NOP && *mi->item==0) 
    DrawSeparator(mr->w,ShadowGC,ReliefGC,5,y_offset-1+HEIGHT_SEPARATOR/2,
		  mr->width-6,y_offset-1+HEIGHT_SEPARATOR/2,1);
  if(mi->next == NULL) 
    DrawSeparator(mr->w,ShadowGC,ShadowGC,1,mr->height-2,
		  mr->width-2, mr->height-2,1);
  if(mi == mr->first) 
    DrawSeparator(mr->w,ReliefGC,ReliefGC,0,0, mr->width-1,0,-1);

  if(*mi->item)
    XDrawString(dpy, mr->w, Scr.NormalGC,mi->x,text_y, mi->item, mi->strlen);
  if(mi->strlen2>0)
    XDrawString(dpy, mr->w, Scr.NormalGC,mi->x2,text_y, mi->item2,mi->strlen2);

  d=(Scr.EntryHeight-7)/2;
  if(mi->func == F_POPUP)
    DrawTrianglePattern(mr->w, ShadowGC, ReliefGC, ShadowGC,
		  mr->width-d-8, y_offset+d-1, mr->width-d-1, y_offset+d+7);
  if((mi->item_num  == 0)&&(menu_on>1))
    DrawTrianglePattern(mr->w, ShadowGC, ShadowGC, ReliefGC,
			d+8, y_offset+d-1, d+1, y_offset+d+7);

  return;
}

/****************************************************************************
 *
 *  Draws two horizontal lines to form a separator
 *
 ****************************************************************************/
#ifdef __STDC__
void DrawSeparator(Window w, GC TopGC, GC BottomGC,int x1,int y1,int x2,int y2,
		   int extra_off)
#else
void DrawSeparator(w, TopGC, BottomGC, x1, y1, x2, y2, extra_off)
Window w;
GC TopGC, BottomGC;
int x1, y1, x2, y2, extra_off;
#endif
{
  XDrawLine(dpy, w, TopGC   , x1,           y1,  x2,          y2);
  XDrawLine(dpy, w, BottomGC, x1-extra_off, y1+1,x2+extra_off,y2+1);
}
    
/****************************************************************************
 *
 *  Draws a little Triangle pattern within a window
 *
 ****************************************************************************/
#ifdef __STDC__
void DrawTrianglePattern(Window w,GC GC1,GC GC2,GC GC3,int l,int u,int r,int b)
#else
void DrawTrianglePattern(w, GC1, GC2, GC3, l, u, r, b)
Window w;
GC GC1, GC2, GC3;
int l, u, r, b;
#endif
{
  int m;

  m = (u + b)/2;

  XDrawLine(dpy,w,GC1,l,u,l,b);

  XDrawLine(dpy,w,GC2,l,b,r,m);
  XDrawLine(dpy,w,GC3,r,m,l,u);
}

/***********************************************************************
 *
 *  Procedure:
 *	PaintMenu - draws the entire menu
 *
 ***********************************************************************/
#ifdef __STDC__
void PaintMenu(MenuRoot *mr, XEvent *e)
#else
void PaintMenu(mr, e)
MenuRoot *mr; 
XEvent *e;
#endif
{
  MenuItem *mi;
  
  for (mi = mr->first; mi != NULL; mi = mi->next)
    {
      /* be smart about handling the expose, redraw only the entries
       * that we need to
       */
      if (e->xexpose.y < (mi->y_offset + mi->y_height) &&
	  (e->xexpose.y + e->xexpose.height) > mi->y_offset)
	{
	  PaintEntry(mr, mi);
	}
    }
  XSync(dpy, 0);
  return;
}

/***********************************************************************
 *
 *  Procedure:
 *	Updates menu display to reflect the highlighted item
 *
 ***********************************************************************/
#ifdef __STDC__
int FindEntry(int x, int y)
#else
int FindEntry(x, y)
int x, y;
#endif
{
  MenuItem *mi;
  int i, entry;
  int retval = MENU_NOP;

  /* look for the entry that the mouse is in */
  for(mi=ActiveMenu->first; mi; mi=mi->next)
    if(y>=mi->y_offset && y<mi->y_offset+mi->y_height)
      break;
  if(x<0 || x>ActiveMenu->width)
    mi = NULL;


  /* if we weren't on the active entry, let's turn the old active one off */
  if ((ActiveItem)&&(mi!=ActiveItem))
    {
      ActiveItem->state = 0;
      PaintEntry(ActiveMenu, ActiveItem);
    }
  /* if we weren't on the active item, change the active item and turn it on */
  if ((mi!=ActiveItem)&&(mi != NULL))
    {
      mi->state = 1;
      PaintEntry(ActiveMenu, mi);
    }
  ActiveItem = mi;
  if(!ActiveItem)
    return retval;
  /* creatpe a new sub-menu */
  if((ActiveItem->func == F_POPUP)&&(x>(3*ActiveMenu->width>>2)))
    retval = do_menu(ActiveItem->menu);
  /* end a sub-menu */ 
  if((menu_on > 1)&&(ActiveItem->item_num == 0)&&(x < (ActiveMenu->width>>2)))
    retval = SUBMENU_DONE;
  return retval;
}

/***********************************************************************
 *
 *  Procedure:
 *	Updates menu display to reflect the highlighted item
 * 
 *  Returns:
 *      0 on error condition
 *      1 on return from submenu to parent menu
 *      2 on button release return
 *
 ***********************************************************************/
int UpdateMenu()
{
  MenuItem *mi;
  int i, x, y, x_root, y_root, entry;
  int done,func;
  int retval;

  XQueryPointer( dpy, ActiveMenu->w, &JunkRoot, &JunkChild,
		&JunkY, &JunkX, &x, &y, &JunkMask);
  FindEntry(x,y);
  while (TRUE)
    {
      /* block until there is an event */
      XMaskEvent(dpy, ButtonPressMask|ButtonReleaseMask|ExposureMask | 
		 KeyPressMask|VisibilityChangeMask|ButtonMotionMask, &Event);
      done = 0;
      if (Event.type == MotionNotify) 
	{
	  /* discard any extra motion events before a release */
	  while((XCheckMaskEvent(dpy,ButtonMotionMask|ButtonReleaseMask,
				 &Event))&&(Event.type != ButtonRelease));
	}
      /* Handle a limited number of key press events to allow mouseless
       * operation */
      if(Event.type == KeyPress)
	Keyboard_shortcuts(&Event,ButtonRelease);
      switch(Event.type)
	{
	case ButtonRelease:
	  PopDownMenu();
	  if(ActiveItem)
	    {
	      func = ActiveItem->func;
	      Action = ActiveItem->action;
	      done = 1;
	      if(ButtonWindow)
		{
		  ExecuteFunction(func, Action,ButtonWindow->lead_w,
				  ButtonWindow, &Event, Context,
				  ActiveItem->val1,ActiveItem->val2,
				  ActiveItem->menu);
		}
	      else
		{
		  ExecuteFunction(func,Action,None,ButtonWindow, &Event, 
				  Context,ActiveItem->val1,ActiveItem->val2,ActiveItem->menu);
		}
	    }
	  ActiveItem = NULL;
	  ActiveMenu = NULL;
	  menuFromFrameOrWindowOrTitlebar = FALSE;
	  return MENU_DONE;

	case KeyPress:
	case VisibilityNotify:
	case ButtonPress:
	  done=1;
	  break;

	case MotionNotify:
	  done = 1;

	  XQueryPointer( dpy, ActiveMenu->w, &JunkRoot, &JunkChild,
			&JunkY, &JunkX, &x, &y, &JunkMask);
	  retval = FindEntry(x,y);
	  if((retval == MENU_DONE)||(retval == SUBMENU_DONE))
	    {
	      PopDownMenu();	      
	      ActiveItem = NULL;
	      ActiveMenu = NULL;
	      menuFromFrameOrWindowOrTitlebar = FALSE;
	    }

	  if(retval == MENU_DONE)
	    return MENU_DONE;
	  else if (retval == SUBMENU_DONE)
	    return MENU_NOP;
	  break;

	case Expose:
	  /* grab our expose events, let the rest go through */
	  if(Event.xany.window == ActiveMenu->w)
	    {
	      PaintMenu(ActiveMenu,&Event);
	      done = 1;
	    }
	  break;

	default:
	  break;
	}
      
      if(!done)DispatchEvent();
      XFlush(dpy);
    }
  return 0;
}


/***********************************************************************
 *
 *  Procedure:
 *	PopUpMenu - pop up a pull down menu
 *
 *  Inputs:
 *	menu	- the root pointer of the menu to pop up
 *	x, y	- location of upper left of menu
 *      center	- whether or not to center horizontally over position
 *
 ***********************************************************************/
#ifdef __STDC__
Bool PopUpMenu (MenuRoot *menu, int x, int y)
#else
Bool PopUpMenu (menu, x, y)
MenuRoot *menu; 
int x, y;
#endif
{

  if ((!menu)||(menu->w == None)||(menu->items == 0)||(menu->in_use))
    return False;

  menu_on++;
  InstallRootColormap();

  /* In case we wind up with a move from a menu which is
   * from a window border, we'll return to here to start
   * the move */
  XQueryPointer( dpy, Scr.Root, &JunkRoot, &JunkChild,
		&x, &y, &JunkX, &JunkY, &JunkMask);    
  Stashed_X = x;
  Stashed_Y = y;
  
  /* pop up the menu */
  ActiveMenu = menu;
  ActiveItem = NULL;
  
  x -= (menu->width >> 1);
  y -= (Scr.EntryHeight >> 1);
  
  /* clip to screen */
  if (x + menu->width > Scr.MyDisplayWidth-2) 
    x = Scr.MyDisplayWidth - menu->width-2;
  if (x < 0) x = 0;

  if (y + menu->height > Scr.MyDisplayHeight-2) 
    y = Scr.MyDisplayHeight - menu->height-2;
  if (y < 0) y = 0;

  XMoveWindow(dpy, menu->w, x, y);
  XMapRaised(dpy, menu->w);
  menu->in_use = True;
  XSync(dpy, 0);
  return True;
}


/***********************************************************************
 *
 *  Procedure:
 *	PopDownMenu - unhighlight the current menu selection and
 *		take down the menus
 *
 ***********************************************************************/
void PopDownMenu()
{
  if (ActiveMenu == NULL)
    return;
  
  menu_on--;
  if (ActiveItem)
    ActiveItem->state = 0;
  
  XUnmapWindow(dpy, ActiveMenu->w);
  UngrabEm();
  UninstallRootColormap();
  XFlush(dpy);
  if (Context & (C_WINDOW | C_FRAME | C_TITLE | C_SIDEBAR))
    menuFromFrameOrWindowOrTitlebar = TRUE;
  else
    menuFromFrameOrWindowOrTitlebar = FALSE;
  ActiveMenu->in_use = FALSE;

}

/***************************************************************************
 * 
 * Wait for all mouse buttons to be released 
 * This can ease some confusion on the part of the user sometimes 
 * 
 * Discard superflous button events during this wait period.
 *
 ***************************************************************************/
void WaitForButtonsUp()
{
  Bool AllUp = False;
  unsigned int mask;
  XEvent JunkEvent;
  FvwmWindow *t;
#ifndef COHERENT
  struct itimerval value;
#endif

  while(!AllUp)
    {
      while(XCheckMaskEvent(dpy,
			    ButtonPressMask|ButtonReleaseMask|ButtonMotionMask,
			    &JunkEvent));

      /* Better check our window focus too */
      XQueryPointer( dpy, Scr.Root, &JunkRoot, &JunkChild,
		    &JunkX, &JunkY, &JunkX, &JunkY, &mask);    

      if((mask&
	  (Button1Mask|Button2Mask|Button3Mask|Button4Mask|Button5Mask))==0)
	AllUp = True;
    }
  if(!Scr.ClickToFocus)
    {
      if (XFindContext(dpy, JunkChild, FvwmContext, (caddr_t *) &t) == XCNOENT)
	SetBorder(Scr.Focus,False,False,True);
      else
	{
#ifndef COHERENT
	  if(Scr.Focus != t)
	    {
	      value.it_value.tv_usec = 1000*(Scr.AutoRaiseDelay%1000);
	      value.it_value.tv_sec = Scr.AutoRaiseDelay/1000;
	      value.it_interval.tv_usec = 0;
	      value.it_interval.tv_sec = 0;
	      setitimer(ITIMER_REAL,&value,NULL);
	    }
#endif
	  SetBorder(t,True,False,True);
	}
      while(XCheckMaskEvent(dpy,EnterWindowMask|LeaveWindowMask, &JunkEvent));
    }
}  

