#ident "@(#)usleep.c	1.1 91/02/28 XGRASP"
/*-
 * usleep.c - OS dependant implementation of usleep().
 *
 * Copyright (c) 1991 by Patrick J. Naughton
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Comments and additions should be sent to the author:
 *
 * Patrick J. Naughton
 * Sun Microsystems
 * 2550 Garcia Ave, MS 10-20
 * Mountain View, CA 94043
 * (415) 336-1080
 *
 */

#include <sys/types.h>
#include <sys/time.h>

int
usleep(usec)
    unsigned long usec;
{
#ifdef SYSV
    poll((struct poll *) 0, (size_t) 0, usec / 1000);	/* ms resolution */
#else
    struct timeval timeout;
    timeout.tv_usec = usec % (unsigned long) 1000000;
    timeout.tv_sec = usec / (unsigned long) 1000000;
    select(0, (void *) 0, (void *) 0, (void *) 0, &timeout);
#endif
    return 0;
}
