#!/home/garfield/bin/X386/epwish -f
# Program: xfhelp
# Tcl version: 6.6 (Tcl/Tk/XF)
# Tk version: 3.1
# XF version: $__lastrelease$
#


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . ""
  wm sizefrom . ""
  wm geometry . 507x458
  wm maxsize . 1024 1024
  wm minsize . 0 0
  wm title . {xfhelp}


  # build widget .frame0
  frame .frame0 \
    -borderwidth {2}\
    -relief {raised}

  # build widget .frame0.menubutton3
  menubutton .frame0.menubutton3 \
    -menu {.frame0.menubutton3.m}\
    -text {File}\
    -underline {0}

  # build widget .frame0.menubutton3.m
  menu .frame0.menubutton3.m 
  .frame0.menubutton3.m add command\
    -command {QuitProgram}\
    -label {Quit}

  # build widget .frame0.menubutton5
  menubutton .frame0.menubutton5 \
    -menu {.frame0.menubutton5.m}\
    -text {Groups}\
    -underline {0}

  # build widget .frame0.menubutton5.m
  menu .frame0.menubutton5.m 
  .frame0.menubutton5.m add command\
    -command {
      global currentHelpPath
      set currentHelpPath /
      ReadTopics}\
    -label {/}
  .frame0.menubutton5.m add command\
    -command {
      global currentHelpPath
      set currentHelpPath /Tk
      ReadTopics}\
    -label {/Tk}
  .frame0.menubutton5.m add command\
    -command {
      global currentHelpPath
      set currentHelpPath /XF
      ReadTopics}\
    -label {/XF}

  # pack widget .frame0
  pack append .frame0 \
    .frame0.menubutton3 {left frame center} \
    .frame0.menubutton5 {left frame center} 

  # build widget .frame1
  frame .frame1 \
    -relief {raised}

  # build widget .frame1.label4
  label .frame1.label4 \
    -relief {raised}\
    -text {Topic:}

  # build widget .frame1.label5
  label .frame1.label5 \
    -anchor {w}\
    -relief {raised}\
    -text {General}

  # pack widget .frame1
  pack append .frame1 \
    .frame1.label4 {left frame center} \
    .frame1.label5 {left frame center expand fillx} 

  # build widget .frame2
  frame .frame2 \
    -relief {raised}

  # build widget .frame2.scrollbar1
  scrollbar .frame2.scrollbar1 \
    -command {.frame2.text2 yview}\
    -relief {raised}

  # build widget .frame2.text2
  text .frame2.text2 \
    -borderwidth {2}\
    -exportselection {0}\
    -height {17}\
    -relief {raised}\
    -state {disabled}\
    -wrap {none}\
    -yscrollcommand {.frame2.scrollbar1 set}

  # pack widget .frame2
  pack append .frame2 \
    .frame2.scrollbar1 {left frame center filly} \
    .frame2.text2 {top frame center expand fill} 

  # build widget .frame3
  frame .frame3 \
    -relief {raised}

  # build widget .frame3.label6
  label .frame3.label6 \
    -anchor {w}\
    -relief {raised}\
    -text {General information on the help system}

  # build widget .frame3.label7
  label .frame3.label7 \
    -relief {raised}\
    -text {Title:}

  # pack widget .frame3
  pack append .frame3 \
    .frame3.label7 {left frame center fillx} \
    .frame3.label6 {left frame center expand fillx} 

  # build widget .frame7
  frame .frame7 \
    -geometry {12x139}\
    -relief {raised}

  # build widget .frame7.frame
  frame .frame7.frame 

  # build widget .frame7.frame.scrollbar2
  scrollbar .frame7.frame.scrollbar2 \
    -command {.frame7.frame.listbox1 yview}\
    -relief {raised}

  # build widget .frame7.frame.scrollbar3
  scrollbar .frame7.frame.scrollbar3 \
    -command {.frame7.frame.listbox1 xview}\
    -orient {horizontal}\
    -relief {raised}

  # build widget .frame7.frame.frame2
  frame .frame7.frame.frame2 \
    -relief {raised}

  # build widget .frame7.frame.frame2.button8
  button .frame7.frame.frame2.button8 \
    -command {ShowSpecial}\
    -text {Special}

  # build widget .frame7.frame.frame2.radiobutton3
  radiobutton .frame7.frame.frame2.radiobutton3 \
    -command {ShowHelp}\
    -text {Help}\
    -value {Help pages}\
    -variable {currentMode}

  # build widget .frame7.frame.frame2.radiobutton4
  radiobutton .frame7.frame.frame2.radiobutton4 \
    -command {ShowHint}\
    -text {Hint}\
    -value {Hint pages}\
    -variable {currentMode}

  # build widget .frame7.frame.frame2.radiobutton5
  radiobutton .frame7.frame.frame2.radiobutton5 \
    -command {ShowNote}\
    -text {Note}\
    -value {Note pages}\
    -variable {currentMode}

  # build widget .frame7.frame.frame2.radiobutton6
  radiobutton .frame7.frame.frame2.radiobutton6 \
    -command {ShowMan}\
    -text {Man}\
    -value {Manual pages}\
    -variable {currentMode}

  # pack widget .frame7.frame.frame2
  pack append .frame7.frame.frame2 \
    .frame7.frame.frame2.radiobutton3 {left frame center expand fillx} \
    .frame7.frame.frame2.radiobutton4 {left frame center expand fillx} \
    .frame7.frame.frame2.radiobutton5 {left frame center expand fillx} \
    .frame7.frame.frame2.radiobutton6 {left frame center expand fillx} \
    .frame7.frame.frame2.button8 {left frame center fillx} 

  # build widget .frame7.frame.label16
  label .frame7.frame.label16 \
    -relief {raised}\
    -text {Topics in:/}

  # build widget .frame7.frame.listbox1
  listbox .frame7.frame.listbox1 \
    -exportselection {0}\
    -geometry {10x10}\
    -relief {raised}\
    -xscrollcommand {.frame7.frame.scrollbar3 set}\
    -yscrollcommand {.frame7.frame.scrollbar2 set}
  # bindings
  bind .frame7.frame.listbox1 <B1-Motion> {NoFunction}
  bind .frame7.frame.listbox1 <Button-1> {SelectTopic %W %y}
  bind .frame7.frame.listbox1 <Shift-B1-Motion> {NoFunction}
  bind .frame7.frame.listbox1 <Shift-Button-1> {SelectTopic %W %y}

  # pack widget .frame7.frame
  pack append .frame7.frame \
    .frame7.frame.label16 {top frame center fillx} \
    .frame7.frame.frame2 {bottom frame center fillx} \
    .frame7.frame.scrollbar2 {left frame center filly} \
    .frame7.frame.listbox1 {top frame center expand fill} \
    .frame7.frame.scrollbar3 {bottom frame center fillx} 

  # build widget .frame7.frame15
  frame .frame7.frame15 

  # build widget .frame7.frame15.scrollbar2
  scrollbar .frame7.frame15.scrollbar2 \
    -command {.frame7.frame15.listbox1 yview}\
    -relief {raised}

  # build widget .frame7.frame15.scrollbar3
  scrollbar .frame7.frame15.scrollbar3 \
    -command {.frame7.frame15.listbox1 xview}\
    -orient {horizontal}\
    -relief {raised}

  # build widget .frame7.frame15.frame0
  frame .frame7.frame15.frame0 \
    -relief {raised}

  # build widget .frame7.frame15.frame0.button0
  button .frame7.frame15.frame0.button0 \
    -command {GotoBookMark}\
    -text {Goto mark}

  # build widget .frame7.frame15.frame0.button5
  button .frame7.frame15.frame0.button5 \
    -command {MarkInsert}\
    -text {Insert mark}

  # build widget .frame7.frame15.frame0.button6
  button .frame7.frame15.frame0.button6 \
    -command {MarkDelete}\
    -text {Delete mark}

  # pack widget .frame7.frame15.frame0
  pack append .frame7.frame15.frame0 \
    .frame7.frame15.frame0.button5 {left frame center expand fillx} \
    .frame7.frame15.frame0.button0 {left frame center expand fillx} \
    .frame7.frame15.frame0.button6 {left frame center expand fillx} 

  # build widget .frame7.frame15.label17
  label .frame7.frame15.label17 \
    -relief {raised}\
    -text {Book marks:}

  # build widget .frame7.frame15.listbox1
  listbox .frame7.frame15.listbox1 \
    -exportselection {0}\
    -geometry {10x10}\
    -relief {raised}\
    -xscrollcommand {.frame7.frame15.scrollbar3 set}\
    -yscrollcommand {.frame7.frame15.scrollbar2 set}
  # bindings
  bind .frame7.frame15.listbox1 <B1-Motion> {SelectBookMark %W %y}
  bind .frame7.frame15.listbox1 <Button-1> {SelectBookMark %W %y}
  bind .frame7.frame15.listbox1 <Double-Button-1> {GotoBookMark}
  bind .frame7.frame15.listbox1 <Shift-B1-Motion> {SelectBookMark %W %y}
  bind .frame7.frame15.listbox1 <Shift-Button-1> {SelectBookMark %W %y}

  # pack widget .frame7.frame15
  pack append .frame7.frame15 \
    .frame7.frame15.label17 {top frame center fillx} \
    .frame7.frame15.frame0 {bottom frame center fillx} \
    .frame7.frame15.scrollbar2 {left frame center filly} \
    .frame7.frame15.listbox1 {top frame center expand fill} \
    .frame7.frame15.scrollbar3 {bottom frame center fillx} 

  # place
  place .frame7.frame15 -relx 0.5 -y 0 -relwidth 0.5 -relheight 1 -anchor nw

  # place
  place .frame7.frame -relx 0 -rely 0 -relwidth 0.5 -relheight 1 -anchor nw


  # build widget .frame8
  frame .frame8 \
    -relief {raised}

  # build widget .frame8.frame10
  label .frame8.frame10 \
    -anchor {w}\
    -relief {raised}\
    -text {Help Tk Tcl XF}

  # build widget .frame8.label9
  label .frame8.label9 \
    -relief {raised}\
    -text {Keywords:}

  # pack widget .frame8
  pack append .frame8 \
    .frame8.label9 {left frame center fill} \
    .frame8.frame10 {top frame center expand fill} 

  # pack widget .
  pack append . \
    .frame0 {top frame center fillx} \
    .frame7 {top frame center expand fill} \
    .frame1 {top frame center fillx} \
    .frame3 {top frame center fillx} \
    .frame8 {top frame center fillx} \
    .frame2 {top frame center expand fill} 

  if {"[info procs XFEdit]" != ""} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .xfFSBox
  }

  global tkVersion
  if {$tkVersion >= 3.0} {
    tk_menuBar .frame0 .frame0.menubutton3 .frame0.menubutton5
  } {
    tk_menus . .frame0.menubutton3 .frame0.menubutton5
  }

  .frame2.text2 insert end {If you have problems, please use the help system. Beside the
help page and the manual pages, this help system contains a
list of hints for the current topic, and a note sheet, where
you can write your own notes for the topic (if you have
notes, that seem to be very important and that I have
forgotten, send them to me, so I can include them into help
system (or in other words: please world write my help system
:-)).

Have fun...}
  .frame7.frame.listbox1 insert end {General}
  .frame7.frame.listbox1 insert end {Tk}
  .frame7.frame.listbox1 insert end {XF}


}


# Procedure: AlertBox
proc AlertBox { {alertBoxMessage "Alert message"} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBox
# Description: show alert box
# Arguments: {alertBoxMessage} - the text to display
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBoxFile - to open and read a file automatically
#          AlertBoxFd - to read from an already opened filedescriptor
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
  }
}


# Procedure: AlertBoxInternal
proc AlertBoxInternal { alertBoxMessage alertBoxCommand alertBoxGeometry alertBoxTitle args} {
# xf ignore me 6
  global alertBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$alertBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$alertBox(activeBackground)\" "
  }
  if {"$alertBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$alertBox(activeForeground)\" "
  }
  if {"$alertBox(background)" != ""} {
    append tmpButtonOpt "-background \"$alertBox(background)\" "
    append tmpFrameOpt "-background \"$alertBox(background)\" "
    append tmpMessageOpt "-background \"$alertBox(background)\" "
  }
  if {"$alertBox(font)" != ""} {
    append tmpButtonOpt "-font \"$alertBox(font)\" "
    append tmpMessageOpt "-font \"$alertBox(font)\" "
  }
  if {"$alertBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$alertBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$alertBox(foreground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $alertBox(toplevelName)}
  } {
    catch {destroy $alertBox(toplevelName)}
  }
  toplevel $alertBox(toplevelName)     -borderwidth 0
  catch "$alertBox(toplevelName) config $tmpFrameOpt"
  if {[catch "wm geometry $alertBox(toplevelName) $alertBoxGeometry"]} {
    wm geometry $alertBox(toplevelName) 350x150
  }
  wm title $alertBox(toplevelName) $alertBoxTitle
  wm maxsize $alertBox(toplevelName) 1000 1000
  wm minsize $alertBox(toplevelName) 100 100
  # end build of toplevel

  message $alertBox(toplevelName).message1     -anchor "$alertBox(anchor)"     -justify "$alertBox(justify)"     -relief raised     -text "$alertBoxMessage"
  catch "$alertBox(toplevelName).message1 config $tmpMessageOpt"

  set xfTmpWidth     [string range $alertBoxGeometry 0 [expr [string first x $alertBoxGeometry]-1]]
  if {"$xfTmpWidth" != ""} {
    # set message size
    catch "$alertBox(toplevelName).message1 configure       -width [expr $xfTmpWidth-10]"
  } {
    $alertBox(toplevelName).message1 configure       -aspect 1500
  }

  frame $alertBox(toplevelName).frame1     -borderwidth 0     -relief raised
  catch "$alertBox(toplevelName).frame1 config $tmpFrameOpt"

  set alertBoxCounter 0
  set buttonNum [llength $args]
  if {$buttonNum > 0} {
    while {$alertBoxCounter < $buttonNum} {
      button $alertBox(toplevelName).frame1.button$alertBoxCounter         -text "[lindex $args $alertBoxCounter]"         -command "
          global alertBox
          set alertBox(button) $alertBoxCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy $alertBox(toplevelName)}
          } {
            catch {destroy $alertBox(toplevelName)}
          }"
      catch "$alertBox(toplevelName).frame1.button$alertBoxCounter config $tmpButtonOpt"

      pack append $alertBox(toplevelName).frame1                   $alertBox(toplevelName).frame1.button$alertBoxCounter {left fillx expand}

      incr alertBoxCounter
    }
  } {
    button $alertBox(toplevelName).frame1.button0       -text "OK"       -command "
        global alertBox
        set alertBox(button) 0
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy $alertBox(toplevelName)}
        } {
          catch {destroy $alertBox(toplevelName)}
        }
        $alertBoxCommand"
    catch "$alertBox(toplevelName).frame1.button0 config $tmpButtonOpt"

    pack append $alertBox(toplevelName).frame1                 $alertBox(toplevelName).frame1.button0 {left fillx expand}
  }

  # packing
  pack append $alertBox(toplevelName)               $alertBox(toplevelName).frame1 {bottom fill}               $alertBox(toplevelName).message1 {top fill expand}

  if {$alertBox(after) != 0} {
    after [expr $alertBox(after)*1000]       "catch \"$alertBox(toplevelName).frame1.button0 invoke\""
  }
}


# Procedure: Alias
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}


# Procedure: ClearList
proc ClearList { listWidget} {
# xf ignore me 5
##########
# Procedure: ClearList
# Description: clear listbox widget
# Arguments: listWidget - the widget to clear
# Returns: none
# Sideeffects: the list widget is cleared
##########

  if {[$listWidget size] > 0} {
    $listWidget delete 0 end
  }
}


# Procedure: DisplayHelp
proc DisplayHelp { newHelpPage} {
  global currentHelpPath

  set currentHelpPath [file dirname $newHelpPage]
  if {"$currentHelpPath" == "" || "$currentHelpPath" == "."} {
    set currentHelpPath /
  }
  ReadTopics
  GotoTopic [file tail $newHelpPage]
}


# Procedure: DisplayPostscript
proc DisplayPostscript { fileName} {
  global env

  if {[info exists env(XF_HELP_PS_CMD)]} {
    catch "exec $env(XF_HELP_PS_CMD) $fileName &"
  } {
    catch "exec ghostview $fileName &"
  }
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: GotoBookMark
proc GotoBookMark {} {
  global currentHelpPath

  set curSel [[SymbolicName BookMarks] curselect]
  if {$curSel >= 0} {
    set currentHelpPath [file dirname [[SymbolicName BookMarks] get $curSel]]
    ReadTopics
    GotoTopic [file tail [[SymbolicName BookMarks] get $curSel]]
  }
}


# Procedure: GotoTopic
proc GotoTopic { newTopic} {
  global currentHelpPath
  global globalHelpPath
  global helpPath

  # if it is .. we go up one dir
  if {"$newTopic" == ".."} {
    set currentHelpPath /[string trim [file dirname $currentHelpPath] /]
    ReadTopics
  } {
    if {![info exists globalHelpPath($newTopic)]} {
      return
    }

    # if it is a directory we go into the directory
    if {[IsADir $globalHelpPath($newTopic)/$currentHelpPath/$newTopic]} {
      if {"[string trim $currentHelpPath /]" == ""} {
        set currentHelpPath "/$newTopic"
      } {
        set currentHelpPath "/[string trim $currentHelpPath /]/$newTopic"
      }
      ReadTopics
    }
    # select the correct topic
    set counter 0
    set listLength [[SymbolicName CurrentPages] size]
    if {"$newTopic" != ""} {
      while {$counter < $listLength} {
        if {"$newTopic" == "[[SymbolicName CurrentPages] get $counter]"} {
          ReadHelp [[SymbolicName CurrentPages] get $counter]
          [SymbolicName CurrentPages] select from $counter
          [SymbolicName CurrentPages] select to $counter
          return
        }
        incr counter 1
      }
    }
    # select the first topic
    set counter 0
    set listLength [[SymbolicName CurrentPages] size]
    while {$counter < $listLength} {
      if {"[[SymbolicName CurrentPages] get $counter]" != ".."} {
        ReadHelp [[SymbolicName CurrentPages] get $counter]
        [SymbolicName CurrentPages] select from $counter
        [SymbolicName CurrentPages] select to $counter
        break
      }
      incr counter 1
    }
  }
}


# Procedure: IsADir
proc IsADir { pathName} {
# xf ignore me 5
##########
# Procedure: IsADir
# Description: check if name is a directory (including symbolic links)
# Arguments: pathName - the path to check
# Returns: 1 if its a directory, otherwise 0
# Sideeffects: none
##########

  if {[file isdirectory $pathName]} {
    return 1
  } {
    catch "file type $pathName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $pathName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isdirectory $linkName]
    }
  }
  return 0
}


# Procedure: IsAFile
proc IsAFile { fileName} {
# xf ignore me 5
##########
# Procedure: IsAFile
# Description: check if filename is a file (including symbolic links)
# Arguments: fileName - the filename to check
# Returns: 1 if its a file, otherwise 0
# Sideeffects: none
##########

  if {[file isfile $fileName]} {
    return 1
  } {
    catch "file type $fileName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $fileName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isfile $linkName]
    }
  }
  return 0
}


# Procedure: MarkDelete
proc MarkDelete {} {
  global markList

  set curSel [[SymbolicName BookMarks] curselect]
  if {$curSel >= 0} {
    set tmpMark [[SymbolicName BookMarks] get $curSel]
    [SymbolicName BookMarks] delete $curSel
    set tmpIndex [lsearch $markList $tmpMark]
    if {$tmpIndex != -1} {
      set markList [lreplace $markList $tmpIndex $tmpIndex]
    }
  }
}


# Procedure: MarkInsert
proc MarkInsert {} {
  global currentHelpPath
  global markList

  if {"$currentHelpPath" == "/"} {
    set insertMark /[lindex [[SymbolicName CurrentContentsLabel] configure -text] 4]
  } {
    set insertMark $currentHelpPath/[lindex [[SymbolicName CurrentContentsLabel] configure -text] 4]
  }
  if {[lsearch $markList $insertMark] != -1} {
    return
  }
  lappend markList $insertMark

  if {[catch "open ~/.xfhelpmarks w" outFile]} {
    AlertBox "$outFile"
  } {
    puts $outFile "global markList"
    puts $outFile "set markList {$markList}"
    puts $outFile ""
    close $outFile
  }

  ClearList [SymbolicName BookMarks]
  foreach counter [lsort $markList] {
    [SymbolicName BookMarks] insert end $counter
  }
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########

  if {"$xfModifier" != ""} {
    set xfPressModifier "$xfModifier-"
    set xfMoveModifier "$xfModifier-"
    set xfReleaseModifier "Any-"
  } {
    set xfPressModifier ""
    set xfMoveModifier ""
    set xfReleaseModifier ""
  }

  if {"$xfCanvasTag" == ""} {
    if {[catch "bind $xfW \"<${xfPressModifier}ButtonPress-$xfButton>\"                   \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "bind $xfW \"<${xfMoveModifier}B$xfButton-Motion>\"                   \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "bind $xfW \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"                   \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  } {
    if {[catch "$xfW bind $xfCanvasTag \"<${xfPressModifier}ButtonPress-$xfButton>\"                   \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "$xfW bind $xfCanvasTag \"<${xfMoveModifier}B$xfButton-Motion>\"                   \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "$xfW bind $xfCanvasTag \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"                   \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  }
}
}


# Procedure: MenuPopupHandle
if {"[info procs MenuPopupHandle]" == ""} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupHandle
# Description: handle the popup menus
# Arguments: xfMenu - the menu to attach
#            xfW - the widget
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########

  if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
    set xfPopMinX [winfo rootx $xfMenu]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfMenu]]
    if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
      $xfMenu activate @[expr $xfY-[winfo rooty $xfMenu]]
    } {
      $xfMenu activate none
    }
  }
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: QuitProgram
proc QuitProgram {} {

  destroy .
  exit 0
}


# Procedure: ReadHelp
proc ReadHelp { section {special "0"}} {
  global currentHelpPath
  global currentMode
  global globalHelpPath
  global helpPath

  if {$special} {
    foreach tmpHelpPath [split $helpPath :] {
      if {[file exists $tmpHelpPath/$currentHelpPath/$section.S] &&
          [file readable $tmpHelpPath/$currentHelpPath/$section.S]} {
        set runPath $tmpHelpPath/$currentHelpPath
        set runSection $section
        source $tmpHelpPath/$currentHelpPath/$section.S
      }
    }
    return
  }
  # reset values
  set fileName ""
  [SymbolicName CurrentContentsLabel] configure -text "$section"
  [SymbolicName CurrentPagesLabel] configure -text "Topics in:$currentHelpPath"
  [SymbolicName CurrentContents] config -state normal
  [SymbolicName CurrentContents] delete 1.0 end
  [SymbolicName Title] config -text {}
  [SymbolicName Keywords] config -text {}

  # show notes text window
  case $currentMode {
    {"Help pages"} {
      set fileName $globalHelpPath($section)/$currentHelpPath/$section.H
    }
    {"Hint pages"} {
      foreach tmpHelpPath [split $helpPath :] {
        if {[file exists $tmpHelpPath/$currentHelpPath/$section.I] &&
            [file readable $tmpHelpPath/$currentHelpPath/$section.I]} {
          set fileName $tmpHelpPath/$currentHelpPath/$section.I
        }
      }
    }
    {"Note pages"} {
      foreach tmpHelpPath [split $helpPath :] {
        if {[file exists $tmpHelpPath/$currentHelpPath/$section.N] &&
            [file readable $tmpHelpPath/$currentHelpPath/$section.N]} {
          set fileName $tmpHelpPath/$currentHelpPath/$section.N
        }
      }
    }
    {"Manual pages"} {
      set fileName ""
    }
  }

  if {"$currentMode" != "Manual pages"} {
    # read text
    if {"$fileName" != "" &&
        [file exists $fileName] && [file readable $fileName]} {
      if {[catch "open $fileName r" inFile]} {
        AlertBox "$inFile"
      } {
        set readText [read $inFile]
        close $inFile
        set insertText ""
        foreach line [split $readText \n] {
          if {[string match "###Title *" $line]} {
            [SymbolicName Title] config -text [string range $line 9 [string length $line]]
          } {
            if {[string match "###Keywords *" $line]} {
              [SymbolicName Keywords] config -text [string range $line 12 [string length $line]]
            } {
              append insertText "$line\n"
            }
          }
        }
        [SymbolicName CurrentContents] insert 1.0 [string trim $insertText]
        if {"$currentMode" != "Note pages"} {
          [SymbolicName CurrentContents] config -state disabled
        }
      }
    }
  } {
    if {"[string trim [string range $currentHelpPath 0 3] /]" == "Tcl"} {
      if {[catch "man n $section | col -b" readText] == 0} {  
        [SymbolicName CurrentContents] insert 1.0 $readText
      } {
        if {[catch "man 3 $section | col -b" readText] == 0} {  
          [SymbolicName CurrentContents] insert 1.0 $readText
        }
      }
    } {
      if {"[string trim [string range $currentHelpPath 0 2] /]" == "Tk"} {
        if {[catch "man n $section | col -b" readText] == 0} {  
          [SymbolicName CurrentContents] insert 1.0 $readText
        } {
          if {[catch "man 3 $section | col -b" readText] == 0} {  
            [SymbolicName CurrentContents] insert 1.0 $readText
          }
        }
      } {
        if {[catch "man $section | col -b" readText] == 0} {  
          [SymbolicName CurrentContents] insert 1.0 $readText
        }
      }
    }
  }
}


# Procedure: ReadTopics
proc ReadTopics {} {
  global currentHelpPath
  global globalHelpPath
  global helpPath

  # reset values
  [SymbolicName CurrentContentsLabel] configure -text "none"
  [SymbolicName CurrentPagesLabel] configure -text "Topics in:$currentHelpPath"
  [SymbolicName CurrentContents] config -state normal
  [SymbolicName CurrentContents] delete 1.0 end
  [SymbolicName CurrentContents] config -state disabled

  catch "unset globalHelpPath"
  ClearList [SymbolicName CurrentPages]
  foreach tmpHelpPath [split $helpPath :] {
    if {[IsADir $tmpHelpPath/$currentHelpPath]} {
      # insert a ..
      if {"[string trimright $currentHelpPath /]" != "" &&
          "[string trimright $currentHelpPath /]" != "."} {
        [SymbolicName CurrentPages] insert end ..
      }
      # read directory
      foreach counter [exec ls $tmpHelpPath/$currentHelpPath] {
        if {[IsAFile $tmpHelpPath/$currentHelpPath/$counter] &&
            "[file extension $counter]" == ".H"} {
          set globalHelpPath([file rootname $counter]) $tmpHelpPath
        }
        if {[IsADir $tmpHelpPath/$currentHelpPath/$counter] &&
            "$counter" != "AtFS" &&
            "$counter" != "RCS"} {
          set globalHelpPath($counter) $tmpHelpPath
        }
      }
      if {[info exists globalHelpPath]} {
        foreach counter [lsort [array names globalHelpPath]] {
          [SymbolicName CurrentPages] insert end $counter
        }
      }
    }
  }

  # select the first topic
  set counter 0
  set listLength [[SymbolicName CurrentPages] size]
  while {$counter < $listLength} {
    if {"[[SymbolicName CurrentPages] get $counter]" != ".."} {
      ReadHelp [[SymbolicName CurrentPages] get $counter]
      [SymbolicName CurrentPages] select from $counter
      [SymbolicName CurrentPages] select to $counter
      break
    }
    incr counter 1
  }
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SaveNote
proc SaveNote {} {
  global currentHelpPath
  global currentNote
  global helpPath

  set notSaved 1
  # is there a current note ?
  if {"$currentNote" != ""} {
    foreach tmpHelpPath [split $helpPath :] {
      set fileName $tmpHelpPath/$currentHelpPath/$currentNote.N
      if {[catch "open $fileName w" outFile] == 0} {
        set notSaved 0
        puts $outFile [[SymbolicName CurrentContents] get 1.0 end]
        close $outFile
      }
    }
    if {$notSaved} {
      AlertBox "Could not save note!"
    }
    set currentNote ""
  }
}


# Procedure: SelectBookMark
proc SelectBookMark { w y} {

  set nearest [$w nearest $y]
  $w select from $nearest
  $w select to $nearest
}


# Procedure: SelectTopic
proc SelectTopic { w y} {
  global currentMode
  global currentNote

  set nearest [$w nearest $y]
  $w select from $nearest
  $w select to $nearest
  SaveNote
  if {"$currentMode" == "Note pages"} {
    set currentNote [$w get $nearest]
  }
  GotoTopic [$w get $nearest]
}


# Procedure: ShowHelp
proc ShowHelp {} {

  set curSel [[SymbolicName CurrentPages] curselect]
  if {$curSel >= 0} {
    SaveNote
    ReadHelp [[SymbolicName CurrentPages] get $curSel]
  }
}


# Procedure: ShowHint
proc ShowHint {} {

  set curSel [[SymbolicName CurrentPages] curselect]
  if {$curSel >= 0} {
    SaveNote
    ReadHelp [[SymbolicName CurrentPages] get $curSel]
  }
}


# Procedure: ShowMan
proc ShowMan {} {

  set curSel [[SymbolicName CurrentPages] curselect]
  if {$curSel >= 0} {
    SaveNote
    ReadHelp [[SymbolicName CurrentPages] get $curSel]
  }
}


# Procedure: ShowNote
proc ShowNote {} {
  global currentNote

  set curSel [[SymbolicName CurrentPages] curselect]
  if {$curSel >= 0} {
    SaveNote
    set currentNote [[SymbolicName CurrentPages] get $curSel]
    ReadHelp [[SymbolicName CurrentPages] get $curSel]
  }
}


# Procedure: ShowSpecial
proc ShowSpecial {} {
  global currentNote

  set curSel [[SymbolicName CurrentPages] curselect]
  if {$curSel >= 0} {
    ReadHelp [[SymbolicName CurrentPages] get $curSel] 1
  }
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}



# module load procedure
proc XFLocalIncludeModule {{moduleName ""}} {
  global env
  global xfLoadInfo
  global xfLoadPath
  global xfStatus

  foreach p [split $xfLoadPath :] {
    if {[file exists "$p/$moduleName"]} {
      if {![file readable "$p/$moduleName"]} {
        puts stderr "Cannot read $p/$moduleName (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName..."
      }
      source "$p/$moduleName"
      return 1
    }
    # first see if we have a load command
    if {[info exists env(XF_VERSION_SHOW)]} {
      set xfCommand $env(XF_VERSION_SHOW)
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "$xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    }
    # are we able to load versions from wish ?
    if {[catch "afbind $p/$moduleName" aso]} {
      # try to use xf version load command
      global xfVersion
      if {[info exists xfVersion(showDefault)]} {
        set xfCommand $xfVersion(showDefault)
      } {
	# our last hope
        set xfCommand "vcat -q $p/$moduleName"
      }
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "$xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    } {
      # yes we can load versions directly
      if {[catch "$aso open r" inFile]} {
        puts stderr "Cannot open $p/[$aso attr af_bound] (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/[$aso attr af_bound]..."
      }
      if {[catch "read \{$inFile\}" contents]} {
        puts stderr "Cannot read $p/[$aso attr af_bound] (permission denied)"
        close $inFile
        continue
      }
      close $inFile
      eval $contents
      return 1
    }
  }
  puts stderr "Cannot load module $moduleName -- check your xf load path"
  destroy .
  exit
}

# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        set xfAppDefaults($widname:[string tolower $name]) $value
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {xfClasses {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter [array names xfAppDefaults] {
    if {[string match "${xfWidgetPath}*" $xfCounter]} {
      set widname [string range $xfCounter 0 [expr [string first : $xfCounter]-1]]
      set name [string range $xfCounter [expr [string first : $xfCounter]+1] end]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"]} {
            catch "$widget configure -[string tolower $name] $xfAppDefaults($xfCounter)" 
          }
        }
      }
    }
  }
}



# startup source
proc StartupSrc {args} {
  wm withdraw .
}


# end source
proc EndSrc {} {
  global argc
  global argv
  global env
  global currentHelpPath
  global currentMode
  global currentNote
  global globalHelpPath
  global helpPath
  global markList

  set currentHelpPath "/"
  set currentMode "Help pages"
  set currentNote ""
  set currentPage ""
  set markList ""
  set topicName ""

  if {[info exists env(XF_HELP_DIR)]} {
    set helpPath $env(XF_HELP_DIR)
  } {
    set helpPath "./pages:/usr/local/lib/xfhelp"
  }
  for {set counter 0} {$counter < $argc} {incr counter 1} {
    case [string tolower [lindex $argv $counter]] in {
      {-helppath} {
        incr counter 1
        set helpPath [lindex $argv $counter]
      }
      {default} {
        if {"[string index [lindex $argv $counter] 0]" == "*" ||
            "[string index [lindex $argv $counter] 1]" == "*"} {
          set topicName [string trimleft [lindex $argv $counter] {/*}]
        } {
          if {"[string index [lindex $argv $counter] 0]" != "/"} {
            set currentPage /[lindex $argv $counter]
          } {
            set currentPage [lindex $argv $counter]
          }
        }
      }
    }
  }

  if {"[info commands XFShowHelp]" == ""} {
    foreach counter [winfo interps] {
      if {[string match "xfhelp*" $counter] &&
          "[winfo name .]" != "$counter"} {
        if {![catch "send \{$counter\} \{\}"]} {
          if {![catch "send \{$counter\} DisplayHelp $currentPage"]} {
            destroy .
            exit
          }
        }
      }
    }
  }

  ClearList [SymbolicName CurrentPages]
  ClearList [SymbolicName BookMarks]
  set menuLast [.frame0.menubutton5.m index last]
  if {"$menuLast" == "none"} {
    set menuLast -1
  }
  for {set xfCounter1 0} {$xfCounter1 <= $menuLast} {incr xfCounter1 1} {
    .frame0.menubutton5.m delete 0
  }

  # build toplevel buttons
  catch "unset globalHelpPath"
  set globalHelpPath() {}
  foreach tmpHelpPath [split $helpPath :] {
    if {[IsADir $tmpHelpPath]} {
      foreach counter [lsort [exec ls $tmpHelpPath]] {
        # make a button for each dir in helpPath
        if {[IsADir $tmpHelpPath/$counter] &&
            "$counter" != "AtFS" && "$counter" != "RCS"} {
          set globalHelpPath($counter) $tmpHelpPath
        }
      }
    }
    if {"$topicName" != ""} {
      if {[file exists $tmpHelpPath/Tcl/$topicName.H]} {
        set currentPage /Tcl/$topicName
      } {
        if {[file exists $tmpHelpPath/Tk/$topicName.H]} {
          set currentPage /Tk/$topicName
        } {
          if {[file exists $tmpHelpPath/Tk/widgets/$topicName.H]} {
            set currentPage /Tk/widgets/$topicName
          } {
            if {[file exists $tmpHelpPath/XF/Tmplt-Combined/$topicName.H]} {
              set currentPage /XF/Tmplt-Combined/$topicName
            } {
              if {[file exists $tmpHelpPath/XF/Tmplt-Procedures/$topicName.H]} {
                set currentPage /XF/Tmplt-Procedures/$topicName
              } {
                if {[file exists $tmpHelpPath/XF/Tmplt-Widgets/$topicName.H]} {
                  set currentPage /XF/Tmplt-Widgets/$topicName
                }
              }
            }
          }
        }
      }
    }
  }
  foreach counter [lsort [array names globalHelpPath]] {
    .frame0.menubutton5.m add command           -label "/$counter"           -command "
      global currentHelpPath
      set currentHelpPath /$counter
      ReadTopics"
  }

  # read marks
  catch "source ~/.xfhelpmarks"
  foreach counter [lsort $markList] {
    [SymbolicName BookMarks] insert end $counter
  }

  wm deiconify .
  if {"$currentPage" == ""} {
    ReadTopics
  } {
    DisplayHelp $currentPage
  }
}

# startup source
StartupSrc

# initialize global variables
global {alertBox}
set {alertBox(activeBackground)} {}
set {alertBox(activeForeground)} {}
set {alertBox(after)} {0}
set {alertBox(anchor)} {nw}
set {alertBox(background)} {}
set {alertBox(button)} {0}
set {alertBox(font)} {}
set {alertBox(foreground)} {}
set {alertBox(justify)} {center}
set {alertBox(toplevelName)} {.alertBox}
global {checkbutton7}
set {checkbutton7} {0}
global {currentHelpPath}
set {currentHelpPath} {/}
global {currentMode}
set {currentMode} {Help pages}
global {currentNote}
set {currentNote} {}
global {globalHelpPath}
set {globalHelpPath(General)} {/home/garfield/tmp/xf2.2/xfhelp/pages}
set {globalHelpPath(Tk)} {/home/garfield/tmp/xf2.2/xfhelp/pages}
set {globalHelpPath(XF)} {/home/garfield/tmp/xf2.2/xfhelp/pages}
global {helpPath}
set {helpPath} {/home/garfield/tmp/xf2.2/xfhelp/pages}
global {markList}
set {markList} {}
global {showSpecial}
set {showSpecial} {0}

# please don't modify the following
# variables. They are needed by xf.
global {autoLoadList}
set {autoLoadList(main.tcl)} {0}
global {internalAliasList}
set {internalAliasList} {}
global {moduleList}
set {moduleList(alertBox.tcl)} { AlertBox AlertBoxInternal}
set {moduleList(extrnl.tcl)} { Alias GetSelection IsADir IsAFile MenuPopupAdd MenuPopupHandle NoFunction SN SymbolicName Unalias}
set {moduleList(fnctns.tcl)} { ClearList DisplayHelp DisplayPostscript GotoBookMark GotoTopic MarkDelete MarkInsert QuitProgram ReadHelp ReadTopics SaveNote SelectBookMark SelectTopic ShowHelp ShowHint ShowMan ShowNote ShowSpecial UpdateIndex UpdateSubdirIndex}
set {moduleList(interface.tcl)} { .}
set {moduleList(main.tcl)} {}
global {preloadList}
set {preloadList(xfInternal)} {}
global {symbolicName}
set {symbolicName(BookMarks)} {.frame7.frame15.listbox1}
set {symbolicName(CurrentContents)} {.frame2.text2}
set {symbolicName(CurrentContentsLabel)} {.frame1.label5}
set {symbolicName(CurrentPages)} {.frame7.frame.listbox1}
set {symbolicName(CurrentPagesLabel)} {.frame7.frame.label16}
set {symbolicName(Keywords)} {.frame8.frame10}
set {symbolicName(Title)} {.frame3.label6}
set {symbolicName(root)} {.}
global {xfWmSetPosition}
set {xfWmSetPosition} {}
global {xfWmSetSize}
set {xfWmSetSize} {.}
global {xfAppDefToplevels}
set {xfAppDefToplevels} {}

# display/remove toplevel windows.
ShowWindow.

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Main
XFLocalSetAppDefs

# end source
EndSrc

# eof
#

