.TH xearth 1 "23 July 1993" "MIT LCS"
.\" RCS $Id: xearth.man,v 1.2 1993/07/23 20:58:21 tuna Exp $

.SH NAME
xearth \- displays a shaded image of the Earth in the root window

.SH SYNOPSIS
.B xearth
.RB [ \-pos 
.I lat lon
]
.RB [ \-noshade ]
.RB [ \-sunpos 
.I lat lon
]
.RB [ \-size 
.I w h
]
.RB [ \-label ]
.RB [ \-wait 
.I secs
]
.RB [ \-day 
.I pct
]
.RB [ \-night
.I pct
]
.RB [ \-nofork ]
.RB [ \-version ]
.RB [ \-ppm ]
.RB [ \-gif ]
.RB [ \-display 
.I dpyname
]

.SH DESCRIPTION
.I Xearth
sets the X root window an image of the Earth, as seen from your
favorite vantage point in space, correctly shaded for the current
position of the Sun. By default,
.I xearth
forks a child process that runs in the background, updating the
displayed image every five minutes to reflect changes in the Sun's
position. This behavior can be changed with the \fB\-wait\fP and
\fB\-nofork\fP options (see below).
.I Xearth
can also render directly into PPM and GIF files instead of drawing in
the root window; see the \fB\-ppm\fP and \fB\-gif\fP options below.

.SH OPTIONS
.LP
.TP
.B \-pos \fIlat lon\fP
Specify the point on the Earth's surface (latitude and longitude,
specified in decimal degrees) around which the displayed image should
be centered. If not specified, this position defaults to 0 degrees
latitude, 0 degrees longitude.
.TP
.B \-noshade
Disable shading, use flat colors to render land and water.
.TP
.B \-sunpos \fIlat lon\fP
Specify the point on the Earth's surface (latitude and longitude,
specified in decimal degrees) where the Sun is directly overhead. By
default,
.I xearth
calculates and updates this position according to the current time.
.TP
.B \-size \fIw h\fP
Specify an image \fIw\fP pixels wide and \fIh\fP pixels high. When
rendering into the X root window, these values default to the
dimensions of the root window. When producing a PPM or GIF file
instead of drawing in the X root window (see the \fB\-ppm\fP and
\fB\-gif\fP options, below), both values default to 512.
.TP
.B \-label
If rendering into the X root window, also provide a label in the lower
right-hand corner that indicates the viewing position and current
position of the sun.
.TP
.B \-wait \fIsecs\fP
Wait \fIsecs\fP seconds between updates of the root window. This value
defaults to 300 seconds (five minutes).
.TP
.B \-day \fIpct\fP
Specify the brightness that should be used to shade the day side of
the Earth. \fIPct\fP should be an integer between 0 and 100,
inclusive, where 0 indicates total darkness and 100 indicates total
illumination. This value defaults to 100.
.TP
.B \-night \fIpct\fP
Specify the brightness that should be used to shade the night side of
the Earth (see description of \fIpct\fP immediately above). This value
defaults to 25.
.TP
.B \-nofork
If rendering into the X root window, don't "auto-background" by
forking off a child process.
.TP
.B \-version
Print what version of
.I xearth
this is.
.TP
.B \-ppm
Instead of drawing in the X root window, write a PPM file (24-bit
color) to standard out.
.TP
.B \-gif
Instead of drawing in the X root window, write a GIF file (8-bit
color) to standard out.

.SH NOTES
This man page documents 
.I xearth
version 0.5. There are a number of very useful improvements that I'd
like to make (such as support for other than eight-bit pseudocolor
visuals, better error recovery, getting options via X resources,
etc.), but I really should be working on my thesis instead of hacking
on this.

The map information used in
.I xearth
was derived from the "CIA World Data Bank II map database," as taken
from some "cbd" files that were apparently originally generated by
Brian Reid at DECWRL.

The Graphics Interchange Format(c) is the Copyright property of
CompuServe Incorporated. GIF(sm) is a Service Mark property of
CompuServe Incorporated.

Kudos to Jef Poskanzer for his excellent PBMPLUS toolkit. 

.SH AUTHOR
Copyright (C) 1989, 1990, 1993 by Kirk Lauritz Johnson.
.\" Permission to use, copy, modify, distribute, and sell this
.\" software and its documentation for any purpose is hereby granted
.\" without fee, provided that the above copyright notice appear in
.\" all copies and that both that copyright notice and this permission
.\" notice appear in supporting documentation. The author makes no
.\" representations about the suitability of this software for any
.\" purpose. It is provided "as is" without express or implied
.\" warranty.
