/*
 * xearth.h
 * kirk johnson
 * july 1993
 *
 * RCS $Id: xearth.h,v 1.5 1993/07/23 05:25:02 tuna Exp $
 *
 * Copyright 1993 by Kirk Lauritz Johnson (see the included file
 * "kljcpyrt.h" for complete copyright information)
 */

#ifndef _XEARTH_H_
#define _XEARTH_H_

#include <stdio.h>
#ifndef COHERENT
#include <stdlib.h>
#endif
#include <math.h>
#include <assert.h>
#include <time.h>
#include "extarr.h"
#include "kljcpyrt.h"

#define VersionString "0.5"

typedef unsigned char uchar;

/* dither.c */
extern int    dither_ncolors;
extern uchar *dither_colormap;
extern void   dither_setup();
extern void   dither_row();
extern void   dither_cleanup();

/* gif.c */
extern void gif_setup();
extern void gif_row();
extern void gif_cleanup();

/* mapdata.c */
extern short map_data[];

/* ppm.c */
extern void ppm_setup();
extern void ppm_row();

/* sunpos.c */
extern void sun_position();

/* x11.c */
extern void x11_resources();
extern void x11_setup();
extern void x11_row();
extern void x11_cleanup();

/* xearth.c */
extern void   fatal();
extern int    wdth;
extern int    hght;
extern char  *dpyname;
extern double view_lon;
extern double view_lat;
extern double sun_lon;
extern double sun_lat;
extern int    label;

/*
 * brute force approximation for sqrt() over [0,1]
 *  - two quadratic regions
 *  - returns zero for args less than zero
 */
#define SQRT(x)                                             \
  (((x) > 0.13)                                             \
   ? ((((-0.3751672414*(x))+1.153263483)*(x))+0.2219037586) \
   : (((x) > 0.0)                                           \
      ? ((((-9.637346154*(x))+3.56143)*(x))+0.065372935)    \
      : (0.0)))

#endif

#ifdef COHERENT
#define M_PI            3.14159265358979323846
#endif
