#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef NEEDPROTOTYPES
int strcasecmp(char *s1, char *s2)
#else
int strcasecmp(s1,s2)
char *s1, *s2;
#endif
{
	int counter, retval;
	char *s1t, *s2t;

	if (strlen(s1)>0)
	{
		s1t=malloc(strlen(s1)+1);

		if (s1t==NULL)
		{
			fputs("Malloc error in strcasecmp - exiting.\n",stderr);

			exit(4);
		}

		strcpy(s1t,s1);
	}
	else
		s1t=NULL;

	if (strlen(s2)>0)
	{
		s2t=malloc(strlen(s2)+1);

		if (s2t==NULL)
		{
			fputs("Malloc error in strcasecmp - exiting.\n",stderr);

			exit(4);
		}

		strcpy(s2t,s2);
	}
	else
		s2t=NULL;

	if (s1t!=NULL)
		for(counter=0;s1t[counter];counter++)
		{
			if (isupper(s1t[counter]))
				s1t[counter]=tolower(s1[counter]);
		}

	if (s2t!=NULL)
		for(counter=0;s2t[counter];counter++)
		{
			if (isupper(s2t[counter]))
				s2t[counter]=tolower(s2[counter]);
		}

	retval=strcmp(s1t,s2t);

	if (s1t!=NULL)
		free(s1t);

	if (s2t!=NULL)
		free(s2t);

	return retval;
}

#ifdef NEED_PROTOTYPES
int strncasecmp(char *s1, char *s2, int len)
#else
int strncasecmp(s1,s2,len)
char *s1, *s2;
int len;
#endif
{
	int counter, retval;
	char *s1t, *s2t;

	if (strlen(s1)>0)
	{
		s1t=malloc(strlen(s1)+1);

		if (s1t==NULL)
		{
			fputs("Malloc error in strcasecmp - exiting.\n",stderr);

			exit(4);
		}

		strcpy(s1t,s1);
	}
	else
		s1t=NULL;

	if (strlen(s2)>0)
	{
		s2t=malloc(strlen(s2)+1);

		if (s2t==NULL)
		{
			fputs("Malloc error in strcasecmp - exiting.\n",stderr);

			exit(4);
		}

		strcpy(s2t,s2);
	}
	else
		s2t=NULL;

	if (s1t!=NULL)
		for(counter=0;s1t[counter];counter++)
		{
			if (isupper(s1t[counter]))
				s1t[counter]=tolower(s1[counter]);
		}

	if (s2t!=NULL)
		for(counter=0;s2t[counter];counter++)
		{
			if (isupper(s2t[counter]))
				s2t[counter]=tolower(s2[counter]);
		}

	retval=strncmp(s1t,s2t,len);

	if (s1t!=NULL)
		free(s1t);

	if (s2t!=NULL)
		free(s2t);

	return retval;
}
