/* This program is Copyright (c) 1991 David Allen.  It may be freely
   distributed as long as you leave my name and copyright notice on it.
   I'd really like your comments and feedback; send e-mail to
   allen@viewlogic.com, or send us-mail to David Allen, 10 O'Moore Ave,
   Maynard, MA 01754.

   Based on code written by by George Ferguson (ferguson@cs.rochester.edu),
   28 Apr 1990.  That code was intended for an X version of "tec", never
   released. */

#include <math.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/keysym.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Shell.h>
#include "const.h"
#include "clim.h"

#ifdef COHERENT
typedef unsigned short ushort;
#define seed48 srand48
#endif

#define SIZE 6
#define WINDOW_HEIGHT   (SIZE*MAXX)
#define WINDOW_WIDTH    (SIZE*MAXY)

extern int MAXSTEP, XSIZE, YSIZE, step;
int picktype = M_HEAT;

static XtAppContext appc;
static Display *Dis;
static Window Win;
static Pixmap Pix;
static Pixmap Pixsave;
static GC gc_def;
static GC Gc[32];


static Arg simple_args[] = {
   {XtNfromVert, (XtArgVal) NULL},
   {XtNheight, (XtArgVal) WINDOW_HEIGHT},
   {XtNwidth, (XtArgVal) WINDOW_WIDTH} };


unsigned char landcols [] = { 11, 28, 3 }, greycols[256], tecols[256];
unsigned char climcols [] = { 9, 20, 18, 2, 3, 18, 22, 26, 14, 17, 12 };
static char *color_names[] = {
   "black","white","grey75", "grey50",
   "MediumPurple1","purple4","purple3","purple2","purple1",
   "blue4","blue3","blue2","blue1",
   "DarkGreen","green4","green3","green2","green1",
   "DarkGoldenrod4","yellow4","yellow3","yellow2","yellow1",
   "orange4","orange3","orange2","orange1",
   "brown4","red4","red3","red2","red1" };


main (argc,argv) int argc; char **argv; {
   Widget toplevel, top_form, surface;
   XWindowAttributes wattr; ushort seed16v[3];

   XtToolkitInitialize ();
   appc = XtCreateApplicationContext ();

   Dis = XtOpenDisplay (appc, NULL, NULL, "Demo", NULL, 0, &argc, argv);
   toplevel = XtAppCreateShell (NULL, NULL, applicationShellWidgetClass,
      Dis, NULL, 0);
   top_form = XtCreateManagedWidget ("top form", formWidgetClass,
      toplevel, NULL, 0);
   surface = XtCreateManagedWidget ("drawing surface", simpleWidgetClass,
      top_form, simple_args, XtNumber(simple_args));
   XtRealizeWidget (toplevel);

   Win = XtWindow (surface);
   XGetWindowAttributes (Dis, Win, &wattr);
   Pix = XCreatePixmap (Dis, Win, WINDOW_WIDTH, WINDOW_HEIGHT, wattr.depth);
   Pixsave = XCreatePixmap (Dis, Win, WINDOW_WIDTH, WINDOW_HEIGHT, wattr.depth);
   XSelectInput (Dis, Win,
      ExposureMask | ButtonPressMask | ButtonReleaseMask |
      KeyPressMask | StructureNotifyMask );

   gc_def = DefaultGC (Dis, DefaultScreen (Dis));
   assign_colors ();
   XFlush (Dis);

   /* Initialize random number generator */
   srand (time ((long *) 0));	/* initialize rand() */
   seed16v[0] = rand(); seed16v[1] = rand(); seed16v[2] = rand();
   seed48 (seed16v);	/* initialize lrand48() */

   XFillRectangle (Dis, Pix, Gc[0], 0, 0, MAXX*SIZE, MAXY*SIZE); redraw ();
   init (*++argv);
   for (step=0; step<MAXSTEP; step++) {
      onestep();
      redraw();
      checkmouse (); }
   XtDestroyApplicationContext (appc);
   return (0); }


assign_colors () {
   Colormap colormap; XColor screen_in_out,exact; int i;

   for (i=0; i<256; i++) greycols[i] = 4.0 + (double) i * 27.0 / 254.0;
   for (i=0; i<16; i++)  tecols[i] = 0;
   for (; i<80; i++)     tecols[i] = 4.0 + (double) (i-16) * 27.0 / 62.0;
   for (; i<256; i++)    tecols[i] = 1;

   colormap = DefaultColormap (Dis, DefaultScreen(Dis));
   for (i=0; i < 32; i++) {
      XAllocNamedColor (Dis, colormap, color_names[i], &screen_in_out, &exact);
      Gc[i] = XCreateGC (Dis, Win, 0, (XGCValues *) NULL);
      XSetForeground (Dis, Gc[i], screen_in_out.pixel);
      if (i == 0) XSetForeground (Dis, gc_def, screen_in_out.pixel); } }


/* Each call to this routine dispatches any pending events.  We are only
   interested in expose events which require a redraw, and the letter 'q'
   being pressed to quit.  */
checkmouse () { XEvent e; char c; KeySym sym; XComposeStatus status;
 
   while (XtAppPending (appc)) { /* while there are events */
      XtAppNextEvent (appc, &e);    /* get one */
      switch (e.type) {             /* and process it */
         case Expose:
            if (e.xexpose.window != Win) XtDispatchEvent(&e);
            else if (e.xexpose.count == 0) redraw ();
            break;
         case KeyPress:
            XLookupString(&e,&c,1,&sym,&status);
            switch (sym) {
               case XK_q: step     = MAXSTEP; break;
               case XK_h: picktype = M_HEAT;  break;
               case XK_p: picktype = M_PRESS; break;
               case XK_w: picktype = M_WIND;  break;
               case XK_r: picktype = M_RAIN;  break;
               case XK_c: picktype = M_CLIM;  break; }
            break;
         default: XtDispatchEvent(&e); } } }


redraw () {
   XCopyArea (Dis, Pix, Win, Gc[0], 0, 0, WINDOW_WIDTH, WINDOW_HEIGHT, 0, 0);
   XFlush (Dis); }


rnd (top) short top; { return (lrand48 () % top); }


panic (s) char *s; { printf ("PANIC: %s\n", s); exit (1); }


draw (ctype, ltype, cra, lra)
   int ctype, ltype;
   unsigned char cra[MAXX][MAXY], lra[MAXX][MAXY]; {
   register short i, j, k, x; unsigned char *lut;

   switch (ctype) {
      case DRAW_GREY: lut = greycols; break;
      case DRAW_LAND: lut = landcols; break;
      case DRAW_CLIM: lut = climcols; break;
      case DRAW_TEC:  lut = tecols;   break; }
   for (j=0; j < YSIZE; j++) for (i=0; i < XSIZE-1; i++) {
      x = lut[cra[i][j]]; k = i+1;
      while ((lut[cra[k][j]] == x) && (k < XSIZE-1)) k++;
      XFillRectangle (Dis, Pix, Gc[x], i*SIZE, j*SIZE, (k-i)*SIZE, SIZE);
      i = k-1; }
   switch (ltype) {
      case LINE_DIAG: diagonal (lra); break;
      case LINE_CORN: corner   (lra); break;
      case LINE_NONE: break; } }


#define LEFT(i,j,x) \
   XDrawLine (Dis, Pix, Gc[x], i*SIZE, j*SIZE, i*SIZE, (j+1)*SIZE)
#define ABOVE(i,j,x) \
   XDrawLine (Dis, Pix, Gc[x], i*SIZE, j*SIZE, (i+1)*SIZE, j*SIZE)
#define UPLEFT(i,j,x) \
   XDrawLine (Dis, Pix, Gc[x], i*SIZE, j*SIZE, (i+1)*SIZE, (j+1)*SIZE)
#define UPRIGHT(i,j,x) \
   XDrawLine (Dis, Pix, Gc[x], (i+1)*SIZE, j*SIZE, i*SIZE, (j+1)*SIZE)


diagonal (ra) unsigned char ra[MAXX][MAXY]; { register short i, j;
   for (j=0; j<YSIZE; j++) for (i=0; i<XSIZE; i++)
      switch (ra[i][j]) {
         case 0:   break;
         case N:   LEFT    (i, j, 0); break;
         case S:   LEFT    (i, j, 1); break;
         case E:   ABOVE   (i, j, 1); break;
         case W:   ABOVE   (i, j, 0); break;
         case N|E: UPRIGHT (i, j, 0); break;
         case N|W: UPLEFT  (i, j, 0); break;
         case S|E: UPLEFT  (i, j, 1); break;
         case S|W: UPRIGHT (i, j, 1); break; } }


corner (ra) unsigned char ra[MAXX][MAXY]; { register short i, j, x;
   for (j=0; j<YSIZE; j++) for (i=0; i<XSIZE; i++) {
      x = ra[i][j];
      if      (x & LINE_0V) LEFT  (i, j, 0);
      else if (x & LINE_1V) LEFT  (i, j, 1);
      if      (x & LINE_0H) ABOVE (i, j, 0);
      else if (x & LINE_1H) ABOVE (i, j, 1); } }
