int get_directory_entries()
{
	DIR *current_dir;

	struct dirent *current_dir_entry;

	int num;

	/* free old space, if used */

	if (num_files_in_dir>0)
	{
		for (num=0;num<num_files_in_dir;num++)
		{
			free(file_list[num]);
		}

		free(file_list);

		num_files_in_dir=0;
	}

	/* open current working directory */

	current_dir=opendir(".");

	/* if we can't read the current working directory then return 0 as the
	   number in directory */

	if (current_dir==NULL)
		return 0;

	/* read first entry in directory to prepare for first pass in directory
	   so we know how many entries to malloc */

	current_dir_entry=readdir(current_dir);

	/* count the number of directory entries */

	for (num_files_in_dir=0;current_dir_entry!=NULL;num_files_in_dir++)
	{
		current_dir_entry=readdir(current_dir);
	}

	/* rewind the directory for the second pass where we will copy the file
	   names */

	rewinddir(current_dir);

	/* allocate space for the file list - note that this is just a list of 
	   pointers - we must still allocate space for each name */

	file_list=(char **)malloc(num_files_in_dir*sizeof(char *));

	/* check for malloc error */

	if (file_list==NULL)
	{
		my_exit(10,"Malloc error on file list\n");
	}

	/* copy each directory entry into space malloced for it */

	for (num=0;num<num_files_in_dir;num++)
	{
		/* read next directory entry */

		current_dir_entry=readdir(current_dir);

		/* skip over current working directory and parent directory 
		   entries */

		if (!strcmp(".",current_dir_entry->d_name)||
			!strcmp(current_dir_entry->d_name,".."))
		{
			num--;
			num_files_in_dir--;

			continue;
		}

		/* allocate space for name */

		file_list[num]=(char *)malloc(strlen(current_dir_entry->d_name)+1);

		/* check for malloc error */

		if (file_list[num]==NULL)
		{
			my_exit(11,"Malloc error on file name\n");
		}

		/* copy the name */

		strcpy(file_list[num],current_dir_entry->d_name);
	}

	max_pages=(num_files_in_dir/(LINES-fkeys+1))+1;

	my_sort(file_list,num_files_in_dir);
}

