/* RWDOCS */
/* filename	: necmd.c
 * purpose	: user level access to link level statistics
 *                for ne ethernet support modules
 * Author	: Randy Wright
 * Copyright	((C)) 1994 Randy Wright
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "nedl.h"

extern int printf();

int
doetherstat()
{

/* RWDOCE */
	register struct ne *nep;
	char buf[20];
	int i, gethwstats(), pether();

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	for(nep = ne, i = 0;nep < &ne[nec]; nep++, i++) {
		gethwstats(nep->iface);
		pether(buf,nep->iface->hwaddr);
		printf("Controller %u, Ethernet address %s\n",i ,buf);

		printf("recv      bad       overf     drop      nomem     intrpt\n");
		printf("%-10lu%-10lu%-10lu%-10lu%-10lu%-10lu\n",
		 nep->estats.recv,nep->estats.bad,nep->estats.over,
		 nep->estats.drop,nep->estats.nomem,nep->estats.intrpt);

		printf("xmit      timeout   jam       jam16\n");
		printf("%-10lu%-10lu%-10lu%-10lu\n",
		 nep->estats.xmit,nep->estats.timeout,nep->estats.jam,
		 nep->estats.jam16);
	}
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return 0;
}

/* end necmd.c */
