/* filename	: inst.c
 * purpose	: installer for cohulip startup.net file
 * author	: Randy Wright
 * Copyright ((C)) 1994 Randy Wright
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#include <stdio.h>

main()
{
FILE *skel, *out;
char inbuf[80], keybuf[80];
int haveslip, havene;
haveslip = havene = 0;

if( (skel = fopen( "/etc/domain", "r" )) == NULL )
	{
	printf( "can't open startup.skel\n" );
	exit(1);
	}
if( (fgets( inbuf, 80, skel )) == NULL )
	{
	printf( "can't read /etc/domain\n" );
	sprintf( inbuf, "unknown" );
	}
fclose( skel );

if( (out = fopen( "/usr/net/startup.new", "w" )) == NULL )
	{
	printf( "can't open /usr/net/startup.new\n" );
	exit(1);
	}
printf( "This program create the file /usr/net/startup.new.\n\n" );
printf( "Net uses a startup file to set up various parameters\n" );
printf( "when you use the network.\n\n" );
printf( "I will ask you for the bits of information that go into\n" );
printf( "creating a starter file. You can edit the file with any text editor\n" );
printf( "to modify, add or delete commands. The file is just a series\n" );
printf( "of net commands\n\n" );

	/* do the hostname */
printf( "Is your internet name\n\t%s\n", inbuf );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] != 'y' )
	{
	while( 1 )
		{
		printf( "please enter the correct internet name\n" );
		fgets( inbuf, 80 , stdin );
		printf( "\nyou entered %s\tis this correct? y/n \n", inbuf );
		fgets( keybuf, 80 , stdin );
		if( keybuf[0] == 'y' ) break;
		}
	}
fprintf( out, "hostname %s",  inbuf );

while( 1 )
	{
	printf( "If you do not know your internet address, enter a hash mark \(#\)\n" );
	printf( "the dotted decimal addresses you give should be enclosed\n" );
	printf( "brackets like this [192.197.249.158]\n\n" );
	printf( "please enter your correct internet dotted decimal address\n" );
	fgets( inbuf, 80 , stdin );
	printf( "\nyou entered %s\tis this correct? y/n \n", inbuf );
	fgets( keybuf, 80 , stdin );
	if( keybuf[0] == 'y' ) break;
	}

if( inbuf[0] != '#' )
fprintf( out, "ip address %s",  inbuf );

	/* do the slip attach if desired */
printf( "do you wish to use a serial port or modem for SLIP\n" );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] == 'y' )
	{
	char pname[80], pspeed[80];
		/* port name */
	while( 1 )
		{
		printf( "please enter the correct serial port name\n" );
		printf( "example:\t \"/dev/com2fl\"\n" );
		fgets( pname, 80 , stdin );
		printf( "\nyou entered %s\tis this correct? y/n \n", pname );
		fgets( keybuf, 80 , stdin );
		if( keybuf[0] == 'y' ) break;
		}
		pname[ (strlen(pname) - 1) ] = '\0';

		/* port speed */
	while( 1 )
		{
		printf( "please enter the correct serial port speed\n" );
		printf( "example:\t19200\n" );
		fgets( pspeed, 80 , stdin );
		printf( "\nyou entered %s\tis this correct? y/n \n", pspeed );
		fgets( keybuf, 80 , stdin );
		if( keybuf[0] == 'y' ) break;
		}
	fprintf( out, "attach asy 0 %s slip sl0 0 1500 %s\n", pname, pspeed );
	printf( "Your slip interface is called sl0\n" );
	haveslip = 1;
	}

	/* do the ethernet attach if desired */
printf( "do you wish to use an NE1000 or NE2000 ethernet card\n" );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] == 'y' )
	{
	char nename[80];
		/* port name */
	while( 1 )
		{
		printf( "please enter the correct ethenet card name, don't include\n" );
		printf( "/dev/ on the begining\n" );
		printf( "example:\t \"ne0\"\n" );
		fgets( nename, 80 , stdin );
		printf( "\nyou entered %s\tis this correct? y/n \n", nename );
		fgets( keybuf, 80 , stdin );
		if( keybuf[0] == 'y' ) break;
		}
		nename[ (strlen(nename) - 1) ] = '\0';

	fprintf( out, "attach nx 0 0 arpa %s 5 1500\n", nename );
	printf( "Your ethernet interface is called ne0\n" );
	havene = 1;
	}


if( haveslip && havene )
	{
	char choice[80];
	printf( "\nPlease select a default route. This will be\n" );
	printf( "the interface over which packets will be sent\n" );
	printf( "when a route cannot be located locally.\n\n" );
	printf( "This is normally the interface that connects\n" );
	printf( "to the nearest gateway or router\n\n" );
	printf( "select either\n\t1. sl0\n\t\tor\n\t2. ne0\n" );
	printf(	"please enter your choice by number\n" );
	while(1)
		{	
		fgets( choice, 80 , stdin );
		printf( "\nyou entered %s\tis this correct? y/n \n", choice );
		fgets( keybuf, 80 , stdin );
		if( keybuf[0] == 'y' ) break;
		}
	if( choice[0] == '1' )
		{
		fprintf( out, "route add default sl0\n" );
		printf( "Your default route is sl0\n\n" );
		}
	if( choice[0] == '2' )
		{
		fprintf( out, "route add default ne0\n" );
		printf( "Your default route is ne0\n\n" );	
		}

	}
else
	{
	if( haveslip )
		{
		fprintf( out, "route add default sl0\n" );
		printf( "Your default route is sl0\n\n" );	
		}
	if( havene )
		{
		fprintf( out, "route add default ne0\n" );
		printf( "Your default route is ne0\n\n" );	
		}
	}

	/* do dns desired */
printf( "do you wish to use a domain name server\n" );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] == 'y' )
	{
	char dname[80];
		/* port name */
	while( 1 )
		{
		printf( "please enter the correct name or dotted decimal\n" );
		printf( "address for the name server you wish to use.\n\n" );
		printf( "example:\t [192.48.234.1]\n" );
		printf( "example:\t myserver.com\n" );
		fgets( dname, 80 , stdin );
		printf( "\nyou entered %s\tis this correct? y/n \n", dname );
		fgets( keybuf, 80 , stdin );
		if( keybuf[0] == 'y' ) break;
		}
		dname[ (strlen(dname) - 1) ] = '\0';

	fprintf( out, "domain addserver %s\n", dname );
	printf( "domain server %s has been added to startup.new.\n\n",dname );
	havene = 1;
	}
fprintf( out, "ip ttl 32\n" );
fprintf( out, "tcp mss 1500\n" );
fprintf( out, "tcp window 1500\n" );
fprintf( out, "tcp irtt 2000\n" );
fprintf( out, "eol unix\n" );

	/* do the ethernet attach if desired */
printf( "do you wish to provide a telnet server to network with this machine?\n" );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] == 'y' )
	{
	fprintf( out, "start telnet\n" );
	printf( "you will be able to receive incoming telnet connections.\n\n" );
	}

	/* do the ethernet attach if desired */
printf( "do you wish to provide a ping response to network with this machine?\n" );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] == 'y' )
	{
	fprintf( out, "start echo\n" );
	printf( "your machine will respond to incoming ping requests.\n\n" );
	}

	/* do the ethernet attach if desired */
printf( "do you wish to provide a finger server to network with this machine?\n" );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] == 'y' )
	{
	fprintf( out, "start finger\n" );
	printf( "\n\t****NOTICE***\nThis machine will respond to incoming finger requests.\n" );
	printf( "It is necsary to put a text file in directory /usr/net/finger for\n" );
	printf( "each user or service that you wish to announce by finger.\n\n" );
	printf( "These files will need to be named <user>.txt where\n" );
	printf( "<user> is the name that can be finger'ed.\n\n" );
	}

	/* do the ethernet attach if desired */
printf( "do you wish to provide an ftp server to network with this machine?\n" );
printf( "[y/n] :" ); fflush( stdout );
fgets( keybuf, 80 , stdin );
if( keybuf[0] == 'y' )
	{
	fprintf( out, "start ftp\n" );
	printf( "\n\t****NOTICE****\nit will be necesary to edit the file /usr/net/ftpusers\n" );
	printf( "in order to give permissions for ftp.\n\n" );
	}
fclose( out );

printf( "\nI have created a file called /usr/net/startup.new based\n" );
printf( "the information you have just supplied for me. In order for\n" );
printf( "net to use this information, you will need to invoke net with\n" );
printf( "the following syntax:\n" );
printf( "\tnet startup.new\n\n" );

printf( "Press <enter> to continue : " ); fflush( stdout );
fgets( keybuf, 80, stdin );

if( (out = fopen( "/etc/profile", "a" )) == NULL )
	{
	printf( "can't open /etc/profile\n" );
printf( "Because I don't seem to have permissions to open /etc/profile\n" );
	printf( "you will need to manually add the evironmental variables:\n" );
	printf( "export NETHOME=\"/usr/net\"\n\tand\n" );
	printf( "export NETSPOOL=\"/usr/spool/uucppublic\"\n" );
	}
else
	{
	fprintf(out, "export NETHOME=\"/usr/net\"\n" );
	fprintf(out, "export NETSPOOL=\"/usr/spool/uucppublic\"\n" );
printf( "I have set the environmental variables NETHOME and NETSPOOL\n" );
printf( "in the system wide profile file called /etc/profile.\n" );
printf( "However, this will not take effect until your next login.\n" );
printf( "The network software need to be able to see these in order to\n" );
printf( "locate its files.\n" );
	fclose( out );
	}

printf( "\nThe file /etc/hosts.net allows you assign aliases to IP addresses.\n" );
printf( "Some examples are included in /usr/net/hosts.net already.\n\n" );
printf( "The file /usr/net/domain.txt is maintained by the domain name\n" );
printf( "client application if you have specified a name server.\n\n" );
printf( "The file ftpusers controls access to ftp services. There are\n" );
printf( "examples in /usr/net/ftpusers\n\n" );
printf( "If you find that startup.new is suitable for your system as I\n" );
printf( "have created it, you can change its name to startup.net and it\n" );
printf( "be automatically executed each time you start net.\n" );
exit(0);
}
