#!/bin/sh

###
# hai154x/src/mkdev_hai.sh
#
# A mkdev script for the hai154x module. This enables and allows tuning of
# the hai154x driver for scsi devices under Mark Williams Coherent. 
###

DEVDIR=/dev

. /usr/lib/shell_lib.sh
COMMAND_NAME=$0
source_path $0 "HOME_DIR="
parent_of $HOME_DIR "CONF_DIR="

. $CONF_DIR/bin/conf_lib.sh

echo "
The adaptec AHA-154x host adapters use a base I/O port, an
interrupt vector, and a DMA channel. The driver module must be
configured to use the values selected on the card. This script will
allow you to tune the driver for your card. If you are not sure how to
set any of the following parameters, just hit <Enter> to keep the
current setting.

"

while : ; do
	read_input "Change AHA-154x I/O port address" ans "n" require_yes_or_no
	is_yes $ans || break

	get_tunable HAI154X_BASE base
	echo "
The Adaptec can use I/O port: 0x130, 0x134, 0x230, 0x234, 0x330, 0x334. The
default as shipped from Adaptec is 0x330.
"
	read_input "AHA-154x I/O port address" tune $base ""
	case $tune in
	0x[123]3[04])	
		base=$tune
		$CONF_DIR/bin/idtune -f HAI154X_BASE $base
		;;
	*)	
		echo [$tune] is an invalid value, please try again.
		;;
	esac
done

while : ; do
	read_input "Change AHA-154x interrupt channel" ans "n" require_yes_or_no
	is_yes $ans || break

	echo "
The Adaptec can use Interrupt Channel: 9, 10, 11, 12, 14, 15. 
The default interrupt channel as shipped 11.
"
	get_tunable HAI154X_INTR intr
	read_input "AHA-154x interrupt channel" tune $intr ""
	case $tune in
	9|10|11|12|14|15)
		intr=$tune
		$CONF_DIR/bin/idtune -f HAI154X_INTR $intr
		;;
	*)	
		echo [$tune] is an invalid value, please try again.
		;;
	esac
done

while : ; do
	read_input "Change AHA-154x DMA channel" ans "n" require_yes_or_no
	is_yes $ans || break

	echo "
The AHA-154x can use DMA channel: 0, 5, 6, 7. When shipped from adaptec it
defaults to DMA channel 5.
"
	get_tunable HAI154X_DMA dma
	read_input "AHA-154x DMA channel" tune $dma ""
	case $tune in
	0 | 5 | 6 | 7)	
		dma=$tune
		$CONF_DIR/bin/idtune -f HAI154X_DMA $dma
		;;
	*)	
		echo [$tune] is an invalid value, please try again.
		;;
	esac
done

exit 0