/* (-lgl
 *	Coherent 386 release 4.2
 *	Copyright (c) 1982, 1994 by Mark Williams Company.
 *	All rights reserved. May not be copied without permission.
 *	For copying permission and licensing info, write licensing@mwc.com
 -lgl) */
/*
 * Configurable information for "hai154x" Host adapters.
 */

#define __KERNEL__	 1

#include <sys/haiscsi.h>
#include "conf.h"

/*
 * Adaptec 154x configuration (factory defaults shown).
 *
 * HAI_AHABASE = 0x330		Port Base.
 * HAI_AHAINTR = 11		Host Adapter Interrupt vector.
 * HAI_AHADMA  = 5		DMA Channel.
 */

unsigned short	hai154x_base = HAI154X_BASE;
unsigned short	hai154x_intr = HAI154X_INTR;
unsigned short	hai154x_dma  = HAI154X_DMA;

/*
 * hai_xfer_speed = hai_xfer_5_0;  MB/second AT bus transfer speed.
 * hai_bus_off_time = 4 [2..15]; Microseconds of bus off time per transfer.
 * hai_bus_on_time = 11 [1..64]; Microseconds of bus on time per transfer.
 */



/*
 * AT Bus transfer speed defines for the adaptec. Set with hai154x_xfer_speed
 *
 *	Setting:	Speed
 *	--------	---------
 *	0		 5.0 Mb/s
 *	1		 6.7 Mb/s
 *	2		 8.0 Mb/s
 *	3		10.0 Mb/s
 *	4		 5.7 Mb/s
 */

unsigned char	hai154x_xferspeed =	HAI154X_XFERSPEED;
unsigned char	hai154x_busofftime =	HAI154X_BUSOFFTIME;
unsigned char	hai154x_busontime =	HAI154X_BUSONTIME;

/* End of file */