/*
 * Z80SIM  -  a	Z80-CPU	simulator
 *
 * Copyright (C) 1987-92 by Udo Munk
 *
 * This module of the Z80-CPU simulator must not be modified by a user,
 * see license agreement!
 *
 * History:
 * 28-SEP-87 Development on TARGON/35 with AT&T Unix System V.3
 * 11-JAN-89 Release 1.1
 * 08-FEB-89 Release 1.2
 * 13-MAR-89 Release 1.3
 * 09-FEB-90 Release 1.4 Ported to TARGON/31 M10/30
 * 20-DEC-90 Release 1.5 Ported to COHERENT 3.0
 * 10-JUN-92 Release 1.6 long casting problem solved with COHERENT 3.2
 *			 and some optimization
 */

/*
 *	Dieses Modul enthaelt einige allgemeine	Funktionen
 */

#include <ctype.h>
#ifdef COHERENT
#include <sgtty.h>
#else
#include <termio.h>
#endif
#include "sim.h"

/*
 *	atoi Funktion fuer Hexadezimal
 */
exatoi(str)
register char *str;
{
	register int num = 0;

	while (isxdigit(*str)) {
		num *= 16;
		if (*str <= '9')
			num += *str - '0';
		else
			num += toupper(*str) - '7';
		str++;
	}
	return(num);
}

/*
 *	Auf einzelnes Eingabezeichen (ohne Echo) warten
 */
getkey()
{
	register int c;
#ifdef COHERENT
	struct sgttyb old_term,	new_term;
#else
	struct termio old_term, new_term;
#endif

#ifdef COHERENT
	gtty(0, &old_term);
	new_term = old_term;
	new_term.sg_flags |= CBREAK;
	new_term.sg_flags &= ~ECHO;
	stty(0, &new_term);
#else
	ioctl(0, TCGETA, &old_term);
	new_term = old_term;
	new_term.c_lflag &= ~(ICANON | ECHO);
	new_term.c_cc[4] = 1;
#endif
	c = getchar();
#ifdef COHERENT
	stty(0, &old_term);
#else
	ioctl(0, TCSETAW, &old_term);
#endif
	return(c);
}
