/*
 * Z80SIM  -  a	Z80-CPU	simulator
 *
 * Copyright (C) 1987-92 by Udo Munk
 *
 * This modul of the simulator contains a simple terminal I/O
 * simulation as an example. It is released to the public domain
 * and may be modified by user.
 *
 * History:
 * 28-SEP-87 Development on TARGON/35 with AT&T Unix System V.3
 * 11-JAN-89 Release 1.1
 * 08-FEB-89 Release 1.2
 * 13-MAR-89 Release 1.3
 * 09-FEB-90 Release 1.4 Ported to TARGON/31 M10/30
 * 20-DEC-90 Release 1.5 Ported to COHERENT 3.0
 * 10-JUN-92 Release 1.6 long casting problem solved with COHERENT 3.2
 *			 and some optimization
 */

/*
 *	DEMO I/O-Handler
 *
 *	Port 0 Eingabe:	ein Zeichen wird vom Terminal gelesen
 *	Port 0 Ausgabe:	das Byte wird aufs Terminal ausgegeben
 *
 *	Alle anderen Ports sind	mit einem I/O-Trap-Handler belegt
 */

#include <stdio.h>
#include "sim.h"
#include "simglb.h"

/*
 *	Vorwaerts-Deklaration der I/O-Unterprogramme
 *	fuer alle Portadressen
 */
BYTE io_trap();
BYTE p000_in(),	p000_out();

/*
 *	Das folgende Array enthaelt fuer jede Port-Adresse
 *	jeweils	eine Adresse fuer eine Funktion, die den
 *	Input und den Output durchfuehrt.
 */
static BYTE (*port[256][2]) () = {
	{ p000_in, p000_out }		/* port	0 */
};

/*
 *	Diese Funktion initialisiert die I/O-Handler:
 *	1. alle	nicht verwendeten Port-Adressen	mit dem
 *	   I/O-Trap-Handler belegen
 */
void init_io()
{
	register int i;

	for (i = 1; i <= 255; i++)
		port[i][0] = port[i][1]	= io_trap;
}

/*
 *	Diese Funktion beendet die I/O-Handler:
 */
void exit_io()
{
}

/*
 *	Dieser I/O-Handler wird	durch die CPU-Befehle IN
 *	aufgerufen, und	ruft seinerseits den Input-Handler
 *	fuer die entsprechende Port-Adresse auf
 */
BYTE io_in(adr)
BYTE adr;
{
	return((*port[adr][0]) ());
}

/*
 *	Dieser I/O-Handler wird	durch die CPU-Befehle OUT
 *	aufgerufen, und	ruft seinerseits den Output-Handler
 *	fuer die entsprechende Port-Adresse auf
 */
BYTE io_out(adr, data)
BYTE adr, data;
{
	(*port[adr][1])	(data);
}

/*
 *	I/O-Trap-Handler
 */
static BYTE io_trap()
{
	cpu_error = IOTRAP;
	cpu_state = STOPPED;
	return((BYTE) 0);
}

/*
 *	I/O-Handler fuer Port 0	lesen:
 *	ein Zeichen vom	Terminal lesen
 */
static BYTE p000_in()
{
	fflush(stdout);
	return((BYTE) getchar());
}

/*
 *	I/O-Handler fuer Port 0	schreiben:
 *	das Datenbyte wird aufs	Terminal ausgegeben
 */
static BYTE p000_out(data)
register BYTE data;
{
	putchar((int) data);
}
