/*
 * Z80SIM  -  a Z80-CPU simulator
 *
 * Copyright (C) 1987-92 by Udo Munk
 *
 * History:
 * 28-SEP-87 Develoment on TARGON/35 with AT&T Unix System V.3
 * 11-JAN-89 Release 1.1
 * 08-FEB-89 Release 1.2
 * 13-MAR-89 Release 1.3
 * 09-FEB-90 Release 1.4 Ported to TARGON/31 M10/30
 * 23-DEC-90 Release 1.5 Ported to COHERENT 3.0
 * 10-JUN-92 Release 1.6 long casting problem solved with COHERENT 3.2
 *			 and some optimization
 */

/*
 *	The following defines may be activated, commented or modified
 *	by user for her/his own purpose.
 */
/*#define WANT_INT*/	/* no interrupts */
/*#define WANT_SPC*/	/* CP/M doesn't work with SP over-/underrun */
/*#define WANT_PCC*/	/* CP/M doesn't work with PC overrun */
/*#define CNTL_C*/	/* don't abort simulation with cntl-c */
#define CNTL_BS		/* emergency exit with cntl-\ :-) */
/*#define WANT_TIM*/	/* no run length measurement */
/*#define HISIZE  1000*//* no history */
/*#define SBSIZE  10*/	/* no breakpoints */

/*
 *	The following lines of this file must not be modified by user,
 *	see license agreemant!
 */
#define COPYR   "Copyright (C) 1987-92 by Udo Munk"
#define RELEASE "1.6"

#define LENCMD          80              /* Laenge von Befehspuffern etc */

#define S_FLAG          128             /* Bit-Definitionen der CPU-Flags */
#define Z_FLAG          64
#define N2_FLAG         32
#define H_FLAG          16
#define N1_FLAG         8
#define P_FLAG          4
#define N_FLAG          2
#define C_FLAG          1

					/* Betriebsart der simulierten CPU */
#define SINGLE_STEP     0               /* single step */
#define CONTIN_RUN      1               /* continuierlicher Lauf */
#define STOPPED         0               /* CPU soll anhalten, weil Fehler */

					/* Fehlergruende */
#define NONE            0               /* kein Fehler */
#define OPHALT          1               /* HALT Op-Code Trap */
#define IOTRAP          2               /* IN/OUT Trap */
#define OPTRAP1         3               /* 1 Byte Op-Code Trap */
#define OPTRAP2         4               /* 2 Byte Op-Code Trap */
#define OPTRAP4         5               /* 4 Byte Op-Code Trap */
#define USERINT         6               /* User interrupt */

					/* Interrupt Typen */
#define INT_NMI         1               /* nicht maskierbarer Interrupt */
#define INT_INT         2               /* maskierbarer Interrupt */

typedef unsigned short WORD;            /* 16 Bit unsigned */
typedef unsigned char  BYTE;            /* 8 Bit unsigned */

#ifdef HISIZE
struct history {                        /* Struktur eines History Eintrages */
	WORD    h_adr;                  /* Adresse */
	WORD    h_af;                   /* Register AF */
	WORD    h_bc;                   /* Register BC */
	WORD    h_de;                   /* Register DE */
	WORD    h_hl;                   /* Register HL */
	WORD    h_ix;                   /* Register IX */
	WORD    h_iy;                   /* Register IY */
	WORD    h_sp;                   /* Register SP */
};
#endif

#ifdef SBSIZE
struct softbreak {                      /* Struktur eines Software Breakpoints */
	WORD    sb_adr;                 /* Breakpoint Adresse */
	BYTE    sb_oldopc;              /* Breakpoint Opcode */
	int     sb_passcount;           /* Breakpoint Passcounter */
	int     sb_pass;                /* Break by Pass */
};
#endif

#ifndef isxdigit
#define	isxdigit(c) ((c<='f'&&c>='a')||(c<='F'&&c>='A')||(c<='9'&&c>='0'))
#endif
