/*
 * CP/M 2.2 writes the CP/M systemfiles to system tracks of drive A
 *
 * Copyright (C) 1988 by Udo Munk
 *
 * History:
 * 29-APR-88 Development on TARGON/35 with AT&T Unix System V.3
 */

#include <stdio.h>
#ifdef COHERENT
#include <sys/fcntl.h>
#else
#include <memory.h>
#include <fcntl.h>
#endif

/*
 *      Das Programm legt folgende Teile des CP/M 2.2 Betriebssystems
 *      auf dem Diskdrive A (Datei drivea.cpm) ab:
 *
 *      Boot-Loader             boot.bin   (Mostek-Format)
 *      CCP                     cpm.bin    (Mostek-Format)
 *      BDOS                    cpm.bin    (Mostek-Format)
 *      BIOS                    bios.bin   (Mostek-Format)
 */
main()
{
	unsigned char header[3];
	unsigned char sector[128];
	register int i;
	int fd, drivea, readed;
	void exit(), perror();
	long lseek();

	/* Drive A zum Schreiben oeffnen */
	if ((drivea = open("../disks/drivea.cpm", O_WRONLY)) == -1) {
		perror("file ../disks/drivea.cpm");
		exit(1);
	}
	/* Boot-Loader (boot.bin) oeffnen */
	if ((fd = open("boot.bin", O_RDONLY)) == -1) {
		perror("file boot.bin");
		exit(1);
	}
	/* 3-Byte Header des Mostek-Formats lesen und pruefen */
	if ((readed = read(fd, (char *) header, 3)) != 3) {
		perror("file boot.bin");
		exit(1);
	}
	if (header[0] != 0xff || header[1] != 0 || header[2] != 0) {
		puts("start adress of boot.bin <> 0");
		exit(0);
	}
	/* Boot-Loader lesen */
	memset((char *) sector, 0, 128);
	read(fd, (char *) sector, 128);
	close(fd);
	/* und auf Drive A schreiben */
	write(drivea, (char *) sector, 128);
	/* CP/M-System (cpm.bin) oeffnen */
	if ((fd = open("cpm.bin", O_RDONLY)) == -1) {
		perror("file cpm.bin");
		exit(1);
	}
	/* 3-Byte Header des Mostek-Formats lesen und pruefen */
	if ((readed = read(fd, (char *) header, 3)) != 3) {
		perror("file cpm.bin");
		exit(1);
	}
	if (header[0] != 0xff) {
		puts("unknown format of cpm.bin");
		exit(0);
	}
	/* auf den CCP in cpm.bin positionieren */
	lseek(fd, (long) 19 * 128 + 3, 0);
	/* CCP und BDOS aus cpm.bin lesen und auf Drive A schreiben */
	for (i = 0; i < 44; i++) {
		if ((readed = read(fd, (char *) sector, 128)) != 128) {
			perror("file cpm.bin");
			exit(1);
		}
		write(drivea, (char *) sector, 128);
	}
	close(fd);
	/* BIOS (bios.bin) oeffnen */
	if ((fd = open("bios.bin", O_RDONLY)) == -1) {
		perror("file bios.bin");
		exit(1);
	}
	/* 3-Byte Header des Mostek-Formats lesen und pruefen */
	if ((readed = read(fd, (char *) header, 3)) != 3) {
		perror("file bios.bin");
		exit(1);
	}
	if (header[0] != 0xff) {
		puts("unknown format of bios.bin");
		exit(0);
	}
	/* BIOS aus bios.bin lesen und auf Drive A schreiben */
	while ((readed = read(fd, (char *) sector, 128)) == 128)
		write(drivea, (char *) sector, 128);
	if (readed > 0)
		write(drivea, (char *) sector, 128);
	close(fd);
	close(drivea);
}
