/*
 * CP/M 2.2 Converts an CP/M kernel to Mostek binary format
 *
 * Copyright (C) 1990 by Udo Munk
 *
 * History:
 * 23-DEZ-90 Development with Coherent 3.0
 */

#include <stdio.h>
#ifdef COHERENT
#include <sys/fcntl.h>
#else
#include <fcntl.h>
#endif

/*
 *	Dieses Programm macht aus einem CPMxx.COM, das durch
 *	MOVCPM gebildet wurde, eine Mostek-Datei, die mittels
 *	putsys auf die Systemspuren der Boot-Diskette geschrieben
 *	werden kann.
 */


char buf[128];

main(argc, argv)
int argc;
char *argv[];
{
	int in, out;

	if (argc != 2) {
		puts("usage: cpmbin infile");
		exit(1);
	}

	if ((in = open(argv[1], O_RDONLY)) == -1) {
		perror(argv[1]);
		exit(2);
	}

	if (creat("cpm.bin", 0644) == -1) {
		perror("cpm.bin");
		exit(3);
	}

	if ((out = open("cpm.bin", O_WRONLY)) == -1) {
		perror("cpm.bin");
		exit(4);
	}

	memset(buf, 0, 128);
	buf[0] = 0xff;
	write(out, buf, 3);
	buf[0] = 0x00;
	write(out, buf, 128);
	write(out, buf, 128);
	while (read(in, buf, 128) != 0)
		write(out, buf, 128);

	close(out);
	close(in);
	exit(0);
}
