/*
 * W-NEWS       A simple NEWS processing package.
 *
 *              N e w s   P a c k a g e   D e f i n i t i o n s
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

#ifndef MINIX
#   include <stdio.h>
#endif
#include <sys/types.h>
#include <ctype.h>
#include <dirent.h>
#ifdef COHERENT
#   ifndef _I386
#	include <sys/fcntl.h>
#   else
#	include <fcntl.h>
#   endif
#else
#   include <fcntl.h>
#endif
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#ifndef COH3
#   include <stdlib.h>
#endif
#include <string.h>
#include <sys/stat.h>
#ifndef COHERENT
#   include <sys/wait.h>
#endif
#include <time.h>
#include <unistd.h>
#ifdef MINIX
#   include <stdio.h>
#endif


#ifdef MINIX
#   define VERSION	"W-NEWS 4.02/MINIX (02/23/93)"
#   define HAVE_WALT	1		/* are we standalone W-NEWS?	*/
#   define HAVE_STDIO	0		/* do we have a full stdio(3)	*/
#   define HAVE_HIST	1		/* do we want the hist stuff?	*/
#   define HAVE_ACCT	1		/* do we want the accounting?	*/
#   define HAVE_AUTO	1		/* automatic control messages?	*/
#   define HAVE_HOST	0		/* any gethostname(2) ??	*/
#   define HAVE_UUHOST	"/etc/uucpname"		/* file with UUCP name	*/
#   define SPOOLDIR	"/usr/spool/news"	/* where articles are	*/
#   define BATCHDIR	"/usr/spool/batch"	/* where batches are	*/
#   define CONFDIR	"/usr/lib/news"		/* the system directory	*/
#   define LIBDIR	"/usr/lib/news"		/* the system directory	*/
#   define MAIL		"/usr/bin/mail"     /* the local mailer		*/
#   define COMPRESS	"/usr/bin/compress" /* compress(1) program	*/
#   define UUX		"/usr/bin/uux -r -gd -"     /* UUX command line	*/
#   define SHELL	"/bin/sh"	/* the shell program		*/
#   define SYSCAT	"/bin/cat"	/* the cat(1) program		*/
#   define SYSRM        "/bin/rm"	/* the rm(1) program		*/
#   define SYSMKDIR	"/bin/mkdir"	/* the mkdir(1) program		*/
#   define SYSCHMOD	"/bin/chmod"	/* the chmod(1) program		*/
#   define E_EDIT       "/bin/ed"	/* line editor			*/
#   define V_EDIT       "/usr/bin/vi"	/* screen editor		*/
#   define SIGNATURE    ".signature"	/* user signature file          */
#   define DEADART      "dead.article"	/* user zombie article          */
#   define NEWSRC       ".newsrc"	/* news agenda                  */
#   define ACCTFILE     "news.adm"	/* NEWS "resource accouting"    */
#   define ACTIVE       "active"	/* NEWS "active" file           */
#   define BATLOCK      ".batlock"	/* sendbatch is running         */
#   define DISTRIBS     "distributions"	/* possible distributions       */
#   define ERRLOG       "errlog"	/* NEWS "error log" file        */
#   define HISTFILE     "history"	/* NEWS "history" file          */
#   define LOGFILE      "log"		/* NEWS "system log" file       */
#   define NWGROUPS     "newsgroups"	/* existing newsgroups          */
#   define ORGANIZAT    "organization"	/* my organization name         */
#   define SYSFILE      "sys"		/* NEWS "sys" file              */
#   define UNBLOCK      ".unblock"	/* unbatch is running           */
#   define CONTROL      "control"	/* control messages             */
#   define INCOMING     ".rnews"	/* incoming news batches        */
#   define JUNK         "junk"		/* disaster newsgroup           */
#   define COMPLVL	"13"		/* use 13-bit compress(1)	*/
#endif

#ifdef LINUX
#   define VERSION	"W-NEWS 4.02/LINUX (02/23/93)"
#   define HAVE_WALT	1		/* are we standalone W-NEWS?	*/
#   define HAVE_STDIO	1		/* do we have a full stdio(3)	*/
#   define HAVE_HIST	1		/* do we want the hist stuff?	*/
#   define HAVE_ACCT	1		/* do we want the accounting?	*/
#   define HAVE_AUTO	1		/* automatic control messages?	*/
#   define HAVE_HOST	1		/* any gethostname(2) ??	*/
#   ifdef LINUXPRO
#	define SPOOLDIR	"/var/spool/news"	/* where articles are	*/
#	define BATCHDIR	"/var/spool/batch"	/* where batches are	*/
#	define CONFDIR	"/conf/news"		/* the NEWS CONFIG dir	*/
#	define LIBDIR	"/usr/lib/news"		/* the system directory	*/
#	define MAIL	"/usr/bin/Mail"		/* the local mailer	*/
#	define COMPRESS	"/usr/bin/compress"	/* compress(1) program	*/
#	define UUX	"/usr/bin/uux -r -gd -"	/* UUX command line	*/
#	define SHELL	"/bin/sh"		/* the shell program	*/
#	define SYSCAT	"/bin/cat"		/* the cat(1) program	*/
#	define SYSRM	"/bin/rm"		/* the rm(1) program	*/
#	define SYSMKDIR	"/bin/mkdir"		/* the mkdir(1) program	*/
#	define SYSCHMOD	"/bin/chmod"		/* the chmod(1) program	*/
#	define E_EDIT	"/bin/ed"		/* line editor		*/
#	define V_EDIT	"/usr/bin/vi"		/* screen editor	*/
#   else
#	define SPOOLDIR	"/usr/spool/news"	/* where articles are	*/
#	define BATCHDIR	"/usr/spool/batch"	/* where batches are	*/
#	define CONFDIR	"/usr/lib/news"		/* the NEWS CONFIG dir	*/
#	define LIBDIR	"/usr/lib/news"		/* the system directory	*/
#	define MAIL	"/usr/bin/mail"		/* the local mailer	*/
#	define COMPRESS	"/bin/compress"		/* compress(1) program	*/
#	define UUX	"/usr/bin/uux -r -gd -"	/* UUX command line	*/
#	define SHELL	"/bin/sh"		/* the shell program	*/
#	define SYSCAT	"/bin/cat"		/* the cat(1) program	*/
#	define SYSRM	"/bin/rm"		/* the rm(1) program	*/
#	define SYSMKDIR	"/bin/mkdir"		/* the mkdir(1) program	*/
#	define SYSCHMOD	"/bin/chmod"		/* the chmod(1) program	*/
#	define E_EDIT	"/bin/ed"		/* line editor		*/
#	define V_EDIT	"/usr/bin/vi"		/* screen editor	*/
#   endif
#   define SIGNATURE    ".signature"	/* user signature file          */
#   define DEADART      "dead.article"	/* user zombie article          */
#   define NEWSRC       ".newsrc"	/* news agenda                  */
#   define ACCTFILE     "news.adm"	/* NEWS "resource accouting"    */
#   define ACTIVE       "active"	/* NEWS "active" file           */
#   define BATLOCK      ".batlock"	/* sendbatch is running         */
#   define DISTRIBS     "distributions"	/* possible distributions       */
#   define ERRLOG       "errlog"	/* NEWS "error log" file        */
#   define HISTFILE     "history"	/* NEWS "history" file          */
#   define LOGFILE      "log"		/* NEWS "system log" file       */
#   define NWGROUPS     "newsgroups"	/* existing newsgroups          */
#   define ORGANIZAT    "organization"	/* my organization name         */
#   define SYSFILE      "sys"		/* NEWS "sys" file              */
#   define UNBLOCK      ".unblock"	/* unbatch is running           */
#   define CONTROL      "control"	/* control messages             */
#   define INCOMING     ".rnews"	/* incoming news batches        */
#   define JUNK         "junk"		/* disaster newsgroup           */
#   define COMPLVL	"16"		/* use 16-bit compress(1)	*/
#endif

#ifdef COH3
#   define VERSION	"W-NEWS 4.02/Coherent 286 (02/23/93)"
#   define WEXITSTATUS(n) (((n) & 0xffff) >> 8)
#   define HAVE_WALT	1		/* are we standalone W-NEWS?	*/
#   define HAVE_STDIO	1		/* do we have a full stdio(3)	*/
#   define HAVE_HIST	1		/* do we want the hist stuff?	*/
#   define HAVE_ACCT	1		/* do we want the accounting?	*/
#   define HAVE_AUTO	1		/* automatic control messages?	*/
#   define HAVE_HOST	0		/* any gethostname(2) ??	*/
#   define HAVE_UUHOST  "/etc/uucpname"		/* file with UUCP name	*/
#   define HAVE_UUDOM   "/etc/domain"		/* file with domainname	*/
#   define SPOOLDIR     "/usr/spool/news"	/* where articles are	*/
#   define BATCHDIR     "/usr/spool/batch"	/* where batches are	*/
#   define CONFDIR	"/usr/lib/news"		/* the system directory	*/
#   define LIBDIR       "/usr/lib/news"		/* the system directory	*/
#   define MAIL         "/bin/mail"	/* the local mailer		*/
#   define COMPRESS     "/bin/compress"	/* compress(1) program		*/
#   define UUX          "/usr/bin/uux -r -gd -"     /* UUX command line	*/
#   define SHELL        "/bin/sh"	/* the shell program		*/
#   define SYSCAT	"/bin/cat"	/* the cat(1) program		*/
#   define SYSRM        "/bin/rm"	/* the rm(1) program		*/
#   define SYSMKDIR	"/bin/mkdir"	/* the mkdir(1) program		*/
#   define SYSCHMOD	"/bin/chmod"	/* the chmod(1) program		*/
#   define E_EDIT       "/usr/bin/ed"	/* line editor			*/
#   define V_EDIT       "/usr/bin/vi"	/* screen editor		*/
#   define SIGNATURE    ".signature"	/* user signature file          */
#   define DEADART      "dead.article"	/* user zombie article          */
#   define NEWSRC       ".newsrc"	/* news agenda                  */
#   define ACCTFILE     "news.adm"	/* NEWS "resource accouting"    */
#   define ACTIVE       "active"	/* NEWS "active" file           */
#   define BATLOCK      ".batlock"	/* sendbatch is running         */
#   define DISTRIBS     "distributions"	/* possible distributions       */
#   define ERRLOG       "errlog"	/* NEWS "error log" file        */
#   define HISTFILE     "history"	/* NEWS "history" file          */
#   define LOGFILE      "log"		/* NEWS "system log" file       */
#   define NWGROUPS     "newsgroups"	/* existing newsgroups          */
#   define ORGANIZAT    "organization"	/* my organization name         */
#   define SYSFILE      "sys"		/* NEWS "sys" file              */
#   define UNBLOCK      ".unblock"	/* unbatch is running           */
#   define CONTROL      "control"	/* control messages             */
#   define INCOMING     "in.coming"	/* incoming news batches        */
#   define JUNK         "junk"		/* disaster newsgroup           */
#   define COMPLVL	"12"		/* use 12-bit compress(1)	*/
#endif

#ifdef COH4
#   define VERSION	"W-NEWS 4.02/Coherent 386 (02/23/93)"
#   define WEXITSTATUS(n) (((n) & 0xffff) >> 8)
#   define HAVE_WALT	1		/* are we standalone W-NEWS?	*/
#   define HAVE_STDIO	1		/* do we have a full stdio(3)	*/
#   define HAVE_HIST	1		/* do we want the hist stuff?	*/
#   define HAVE_ACCT	1		/* do we want the accounting?	*/
#   define HAVE_AUTO	1		/* automatic control messages?	*/
#   define HAVE_HOST	0		/* any gethostname(2) ??	*/
#   define HAVE_UUHOST  "/etc/uucpname"		/* file with UUCP name	*/
#   define HAVE_UUDOM   "/etc/domain"		/* file with domainname	*/
#   define BATCHDIR     "/usr/spool/batch"	/* where batches are	*/
#   define CONFDIR	"/usr/lib/news"		/* the system directory	*/
#   define LIBDIR       "/usr/lib/news"		/* the system directory	*/
#   define SPOOLDIR     "/usr/spool/news"	/* where articles are	*/
#   define MAIL         "/bin/mail"	/* the local mailer		*/
#   define COMPRESS     "/bin/compress"	/* compress(1) program		*/
#   define UUX          "/usr/bin/uux -r -gd -"     /* UUX command line	*/
#   define SHELL        "/bin/sh"	/* the shell program		*/
#   define SYSCAT	"/bin/cat"	/* the cat(1) program		*/
#   define SYSRM        "/bin/rm"	/* the rm(1) program		*/
#   define SYSMKDIR	"/bin/mkdir"	/* the mkdir(1) program		*/
#   define SYSCHMOD	"/bin/chmod"	/* the chmod(1) program		*/
#   define E_EDIT       "/usr/bin/ed"	/* line editor			*/
#   define V_EDIT       "/usr/bin/vi"	/* screen editor		*/
#   define SIGNATURE    ".signature"	/* user signature file          */
#   define DEADART      "dead.article"	/* user zombie article          */
#   define NEWSRC       ".newsrc"	/* news agenda                  */
#   define ACCTFILE     "news.adm"	/* NEWS "resource accouting"    */
#   define ACTIVE       "active"	/* NEWS "active" file           */
#   define BATLOCK      ".batlock"	/* sendbatch is running         */
#   define DISTRIBS     "distributions"	/* possible distributions       */
#   define ERRLOG       "errlog"	/* NEWS "error log" file        */
#   define HISTFILE     "history"	/* NEWS "history" file          */
#   define LOGFILE      "log"		/* NEWS "system log" file       */
#   define NWGROUPS     "newsgroups"	/* existing newsgroups          */
#   define ORGANIZAT    "organization"	/* my organization name         */
#   define SYSFILE      "sys"		/* NEWS "sys" file              */
#   define UNBLOCK      ".unblock"	/* unbatch is running           */
#   define CONTROL      "control"	/* control messages             */
#   define INCOMING     "in.coming"	/* incoming news batches        */
#   define JUNK         "junk"		/* disaster newsgroup           */
#   define COMPLVL	"16"		/* use 16-bit compress(1)	*/
#endif

#ifdef MSDOS
#   define VERSION	"W-NEWS 4.02/MS-DOS (02/23/93)"
#   define HAVE_WALT	1		/* are we standalone W-NEWS?	*/
#   define HAVE_STDIO	1		/* do we have a full stdio(3)	*/
#   define HAVE_HIST	1		/* do we want the hist stuff?	*/
#   define HAVE_ACCT	1		/* do we want the accounting?	*/
#   define HAVE_AUTO	1		/* automatic control messages?	*/
#   define HAVE_HOST	0		/* any gethostname(2) ??	*/
#   define HAVE_HOSTENV	"HOSTNAME"	/* env. variable name		*/
#   define BATCHDIR     "BATDIR"
#   define SPOOLDIR     "SPLDIR"
#   define CONFDIR	"LIBDIR"
#   define LIBDIR       "LIBDIR"
#   define MAIL         "MAIL.EXE"	/* the local mailer		*/
#   define COMPRESS     "COMPRESS.EXE"	/* compress(1) program		*/
#   define UUX          "UUX.EXE -r -gd -"  /* UUX command line		*/
#   define SHELL        "COMMAND.COM"	/* the shell program		*/
#   define SYSCAT	""		/* not used under MS-DOS	*/
#   define SYSRM        ""		/* not used under MS-DOS	*/
#   define SYSMKDIR	""		/* not used under MS-DOS	*/
#   define SYSCHMOD	""		/* not used under MS-DOS	*/
#   define E_EDIT       "EDLIN.EXE"	/* line editor			*/
#   define V_EDIT       "EDIT.EXE"	/* screen editor		*/
#   define SIGNATURE    "SIGNATUR"	/* user signature file          */
#   define DEADART      "DEAD_ART"	/* user zombie article          */
#   define NEWSRC       "_NEWSRC"	/* news agenda                  */
#   define ACCTFILE     "NEWS.ADM"	/* NEWS "resource accouting"    */
#   define ACTIVE       "ACTIVE"	/* NEWS "active" file           */
#   define BATLOCK      "_BATLOCK"	/* sendbatch is running         */
#   define DISTRIBS     "DISTRIBU"	/* possible distributions       */
#   define ERRLOG       "ERRLOG"	/* NEWS "error log" file        */
#   define HISTFILE     "HISTORY"	/* NEWS "history" file          */
#   define LOGFILE      "LOG"		/* NEWS "system log" file       */
#   define NWGROUPS     "NEWSGROU"	/* existing newsgroups          */
#   define ORGANIZAT    "ORGANIZA"	/* my organization name         */
#   define SYSFILE      "SYS"		/* NEWS "sys" file              */
#   define UNBLOCK      "_UNBLOCK"	/* unbatch is running           */
#   define CONTROL      "CONTROL"	/* control messages             */
#   define INCOMING     "_RNEWS"	/* incoming news batches        */
#   define JUNK         "JUNK"		/* disaster newsgroup           */
#   define COMPLVL	"16"		/* use 16-bit compress(1)	*/
#endif

/* These definitions are for the "pnews" program. */
#define DFLT_NEWSG      "mugnet.talk"	/* dflt newsgroup (pnews)	*/
#define DFLT_DIST       "world"		/* dflt distribution (pnews)	*/

/* It should not be necessary to change these. */
#define BATCHLIM        50000		/* maxsize of a batch		*/
#define USENET          "usenet"	/* NEWS administrator		*/

#define COMPRHDR	"#! cunbatch\n"	/* 'compress' indicator         */
#define RNEWSHDR	"#! rnews "	/* article separator header     */


/* Function prototypes. */
#ifdef ANSI
#   define _PRO(func, args)	func args
#else
#   define _PRO(func, args)	func ()
#endif
_PRO( void logmsg, (int err, char *fmt, ...)				);
_PRO( void usage, (void)						);

/* End of WNEWS.H */
