/*
 * W-NEWS       A simple NEWS processing package.
 *              Rnews is used by UUCP to unpack the incoming news batches
 *              and queue them for unbatching by the 'unbatch' program.
 *              Since all this unpacking (decompressing) takes lots of
 *              time, the 'unbatch' program also takes care of the actual
 *              decompressing and unpacking.  This file moves the data file
 *              into a spool directory of the W-NEWS system.
 *
 * Usage:       rnews [-d] [-U] [ < ] input_batch_file
 *
 * Version:     @(#)rnews.c	4.02	02/23/93
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */
#include "wnews.h"


static char *Release = VERSION;
static char *Version = "@(#) rnews 4.02 (02/23/93)";


char *lgmonths[] = {                    /* for debugging purposes       */
  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};
int debug = 0;                          /* debugging flag               */
int unbatch = 0;                        /* call 'unbatch' for the work  */


_PRO( int mk_batch, (FILE *input)					);


/* Write something to the log files. */
#ifdef __STDC__
void logmsg(int err, char *fmt, ...)
#else
void logmsg(err, fmt)
int err;
char *fmt;
#endif
{
  char buff[1024];
  FILE *lfp, *efp;
  char lfn[128], efn[128];
  struct tm *mydate;
  va_list args;
  time_t now;

  sprintf(lfn, "%s/%s", CONFDIR, LOGFILE);
  sprintf(efn, "%s/%s", CONFDIR, ERRLOG);

  if ((efp = fopen(efn, "a")) == (FILE *)NULL) {
	fprintf(stderr, "rnews: cannot append(%s)\n", efn);
	return;
  }

  if ((lfp = fopen(lfn, "a")) == (FILE *)NULL) {
	fprintf(efp, "rnews: cannot append(%s)\n", lfn);
	(void) fclose(efp);
	return;
  }

  (void) time(&now);
  mydate = localtime(&now);
  sprintf(buff, "%s %02d %02d:%02d  ",
	lgmonths[mydate->tm_mon], mydate->tm_mday,
			mydate->tm_hour, mydate->tm_min);
  va_start(args, fmt);
  if (err == 1) {
	fprintf(efp, buff);
	vfprintf(efp, fmt, args);
  } else {
	fprintf(lfp, buff);
	vfprintf(lfp, fmt, args);
  }
  if (debug > 0) {
	fprintf(stderr, buff);
	vfprintf(stderr, fmt, args);
  }
  (void) fclose(lfp);
  (void) fclose(efp);
}


/* Copy the news batch in 'input' to a NEWS spool file. */
int mk_batch(input)
register FILE *input;
{
  char batch[128], buff[1024];
  register FILE *fp;
  struct tm *tm;
  time_t now;
  int st;

  /* Get the current time. */
  (void) time(&now);
  tm = localtime(&now);

  /* Create a batch file name. */
  sprintf(batch, "%s/%s/%2d%02d%02d%02d%02d%04x",
	SPOOLDIR, INCOMING,
	tm->tm_year, tm->tm_mon + 1, tm->tm_mday,
	tm->tm_hour, tm->tm_min, getpid());
  if ((fp = fopen(batch, "wb")) == (FILE *)NULL) {
	logmsg(1, "rnews: cannot create(%s)\n", batch);
	return(-1);
  } else logmsg(0, "rnews: creating batch %s\n", batch);

  /* Copy the incoming batch to the file. */
  do {
	st = fread(buff, sizeof(char), 1024, input);
	fwrite(buff, sizeof(char), st, fp);
  } while (st > 0);
  if (ferror(input) || ferror(fp)) {
	logmsg(1, "rnews: error while copying batch file\n");
	(void) fclose(input);
	(void) fclose(fp);
	return(-1);
  }
  (void) fclose(input);
  (void) fclose(fp);
  return(0);
}


void usage()
{
  fprintf(stderr, "Usage: rnews [-d] [-U] < input_batch_file\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char cmd[128];
  char *args[8];
  char *fname;
  FILE *fp;
  int st;
  extern int getopt(), optind;
#ifndef COHERENT
  extern int opterr;
#endif

#ifndef COHERENT
  opterr = 0;
#endif
  while ((st = getopt(argc, argv, "dU")) != EOF) switch(st) {
	case 'd':
		debug = 1;
		break;
	case 'U':
		unbatch = 1;
		break;
	default:
		usage();
  }

  (void) umask(077);            /* set protection mask to rwx------ */

  if (unbatch == 1) {
	if (argc != optind) usage();
	sprintf(cmd, "%s/unbatch", LIBDIR);

	st = 0;
	args[st++] = cmd;
	if (debug == 1) args[st++] = "-d";
	args[st] = NULL;
	st = execv(cmd, args);
	exit(st);
  } else {
	argc--;
 	fp = stdin;
	if (optind == argc) {
		fname = argv[optind];
		fp = fopen(fname, "rb");
		if (fp == (FILE *)NULL) {
			logmsg(1, "rnews: cannot open %s\n", fname);
			exit(-1);
		}
	} else if (optind <= argc) usage();

	st = mk_batch(fp);
	exit(st);
  }
}
