.\"
.\"
.\"
.\"
.\"
.\"                 W-NEWS NEWS Processing Package
.\"
.\"           Fred N. van Kempen, MicroWalt Corporation
.\"
.\"                  waltje@uWalt.NL.Mugnet.ORG
.\"
.\"                   Version 4.01 - 02/08/93
.\"
.\"
.\"     Format this document with the command "nroff -man name"
.\"
.\" Document-specific macros

.\" Indent a line.
.de IN
.ti +5
.nf
.B "\\$1"
.fi
.br
..

.\" Define a chapter.
.de CD
.bp
.\".sp 7
.nr A +1
.nr B 0 0
.ce
.nf
.B "\\nA.   \\$1"
.fi
.sp 3
..

.\" Define a section.
.de HD
.ne 5
.sp 2
.nr B +1
.nf
.B "\\nA.\\nB  \\$1"
.fi
.sp 1
..

.\" Document global settings
.ll 72
.nr A 0 0
.nr B 0 0

.\" Title page
.ds CF ""
.\".bp
.sp 15
.ce 5
.sp 2
.B "W-NEWS NEWS Processing Package"
.sp 2
.B "Fred N. van Kempen, MicroWalt Corporation"
.sp 1
.B "waltje@uWalt.NL.Mugnet.ORG"
.sp 1
.B "Version 4.01 - 02/08/93"
.sp 2
.B "R E F E R E N C E    M A N U A L"
.sp 2
.sp 10
.B ABSTRACT
.br
W-NEWS is a NEWS processing package which resembles the
.B B-News
package found on many UNIX systems. It was written especially for
use with the MINIX operating system, but it will work on most other
UNIX-like systems as well, since virtually no system-dependent code
is used by the programs. This version has been tested to run on MINIX,
LINUX (versions 0.96c and up), Coherent 3.X and Coherent 4.X.

.TH W-NEWS "1" "02/08/93" "Version 4.01" "MicroWalt W-News"
.CD "I N T R O D U C T I O N"
.B W-NEWS
is a set of programs that can be used to process news articles,
both incoming and outgoing.  This Reference Manual describes its
bugs, shortcomings, workings and history.

.HD "THE OLD DAYS"
I have been running
.B UUCP
on MINIX for some years now, and with success, as is known by
many people. I wrote some application programs such as
.B W-MAIL
and
.B U-MAIL
that let me communicate with the rest of the world in a fairly
convienient manner, and I am very pleased with it all.
.sp 1
However,
.B NEWS
access has always been a bother. My UUCP host did not have a news
feed itself, and I got somewhat tired of dialing in on my former
school to read news there. Finally, my account expired, and I was
left with no news access at all...
.sp 1
Luckily, about half a year ago someone offered to send me articles
from
.B comp.os.minix
by e-mail (note, that I did have a more-or-less reliable mail link),
which I gratefully accepted. It worked fine, but it took me lots of
time to process all incoming articles. Also, a newsreader was not
present...
.sp 1
So, to ease the reading of those articles, I ported the
.B vn
newsreader (posted by Tony Andrews) to MINIX, with only little
effort. This cured only part of the problem, since I still had to
insert the incoming articles into the NEWS spool directory...
.sp 1
About three months later, I got a "normal" UUCP link, and the system
manager of that host offered to send me comp.os.minix as
.B "batches"
of articles. I didn't have a clue as to what those things were, but
I told the guy to send 'em anyway...
.sp 1
While experimenting with the incoming data, I gradually found out
what a news batch was, and how it was constructed. I wrote two
little programs (
.B rnews
and
.B newsrun
) that allowed me to automatically process incoming articles.
.sp 1
The first stripped off this funny-looking
.sp 1
.IN "#! cunbatch"
.sp 1
header, fed the remainder through compress(1) and stored the result
in a spool directory for later processing by
.B newsrun
, which was started daily by cron(1). Newsrun unpacked the decompressed
batches, and stuffed all articles into the
.B /usr/spool/news/comp/os/minix
directory, just like vn wanted it. It also maintained an
.B active
file, because vn wanted it to exist. This worked well enough to keep
me satisfied until I set up the
.B MUGNET
network.

.HD "MUGNET and B NEWS"
A network backbone needs much more robust software than the little
package I wrote, and this I realized very quickly after starting up.
My package could only handle one group (it stored all incoming articles
in one directory!), and posting news was impossible (besides mailing it
to some relay system).
.sp 1
So, since we now had to handle news groups from lots of hosts, plus a
number of MUGNET groups, I had to use a package smarter than my own.
I dislike
.B "C News"
because it depends on shell scripts too much (which is
.B "very slow"
on MINIX !!!). Therefore, I finished the 'cleanup' of the MINIX-port
of the
.B "B News 2.11"
software that Peter Housel sent me, and I started using that on the
MUGNET-Europe backbone.
.sp 1
However, although my machine is large enough to run 'B', many small
MINIX systems around me (in MUGNET) cannot handle such a beast. We
just needed a simple version of the 'B' software which does not try
to do it all, since many of the special features offered by large
packages like 'B' use either special UNIX-ish tricks to get things
working, or they can be lived without (for example, the support for
old-style news articles).

.HD W-NEWS
All of this lead to me starting a major rewrite of my old NEWS package,
under the name of
.B W-NEWS
(what else? :-). Since I like the way 'B' handles things, I decided to
try and give W-NEWS as much of the 'B' look as possible. It now consists
of the following modules:
.sp 1
.IN "rnews     - handle incoming articles and batches"
.IN "unbatch   - process spooled news"
.IN "inews     - the main article relayer"
.IN "control   - implementation of control messages"
.IN "sendbatch - create batches of articles for transport"
.IN "expire    - remote old articles from the system"
.IN "pnews     - post a news article"
.IN "checknews - check if any new articles have arrived"
.IN "wnbill    - create a bill for network users"
.IN "newspace  - show how much space each newsgroup uses"
.sp 1
As can be seen, it is a fairly complete system. Incoming articles or
batches of articles are moved to a NEWS spool directory by the
.B rnews
program for later processing (cron!) by
.B unbatch
(also callable as
.B "rnews -U"
). Unbatch calls
.B inews
for each article to be posted locally. The latter also takes care
of the forwarding (relaying) to other systems connected to the host,
which is required for backbone operation. Inews is also called by the
.B pnews
news posting program (a derivative of the
.B W-MAIL
Message Editor) for the actual posting (both local and remote) of the
article. Posting is achieved by putting a copy (well, actually a link,
since each article is put on disk only once; all other copies in other
news groups are links) in the desired subdirectory of the NEWS spool
space. For any article forwarded to a certain remote host, a line
containing the full pathname of the article is added to a text file in
the
.B /usr/spool/batch
directory. The
.B sendbatch
program (which should be executed at least daily by cron) creates
batches (optionally compressed) from these outgoing articles, ready
for transmission with a network protocol, usually UUCP.
So, the batches end up in the UUCP spool directory for transmission
to the remote system.
.sp 1
This setup allows you to both receive (with
.B vn
) and post (with
.B pnews
) news articles, for multiple news groups the same way 'B' does it.
.sp 1
For a newsreader, I recommend the
.B vn
program, or, if you don't like using full-screen software, the
.B rna
(also called
.B readnews
)
program. These are both available from the NLMUG Archive Service. There
will be a simplified version of the vn program in the W-NEWS package in
the future.
.br
Under COHERENT 3.x the newsreaders
.B vn
and
.B tass
are available.
.B Tass
is a full-screen threaded newsreader, which is very fast, because it
organizes the articles in a database.
.br
Under COHERENT 4.0 there are two additional newsreaders available,
.B tin
and
.B nn
\&.
.B Tin
is made from
.B tass
, but it is more powerfull.
.B Nn
is the most powerfull newsreader available today, but it is not
recommended for beginners, because of difficult administration.
.sp 1

.HD "OUTLINE OF THE REST"
The rest of this document will describe all the modules of the W-NEWS
system, one per section.  Following that, a description of all files
used is presented.

.CD "M O D U L E S"
This chapter describes the inner workings of the various programs
(modules) of the W-NEWS system.  It does not, however, tell you how
to invoke the programs.  See the respective manual pages for that
information.
.HD rnews
Usenet (UUCP protocol) or Internet (TCP/IP protocol).  They come
in as simple datafiles.  When these datafile are ready to be
processed by the NEWS system, the networking software calls the
.B rnews
program to take care of processing the newly received data. In
many case, however, it is at least undesirable to have the system
process the data right away, since this processing may cause the
system to be slowed down quit a bit.  Therefore, this program only
moves the datafiles to a spool directory of the NEWS system.  By
default, this is the
.B /usr/spool/news/in.coming
directory, and the filename of the datafile will be something like
.sp 1
.IN "yymmddhhmmXXXX"
.sp 1
with
.B yy
being the year (minus 1900),
.B mm
the month (01 is January),
.B dd
being the day of the month (1-based), and
.B hh
and
.B mm
being the time in hours and seconds respecively.  The last four
characters of the name are the process ID of the rnews program
in hexadecimal (to make them fit in 14 characters total).
.sp 1
This file will later be processed by the
.B unbatch
program.
.sp 1
After the file has been queued, rnews exits.  See the manual page
for
.B rnews(8)
for more details on how to invoke this program.
.HD unbatch
At regular time intervals, the system should start the
.B unbatch
program, to process the news that came in that day.
.sp 1
The first thing unbatch does is check if there is already a copy of
it running on the system.  This is indicated by the presence of the
lock file called
.B .unblock
in the news LIBDIR (usually
.B /usr/lib/news
).  If it exists, unbatch simply exits.  If the lock file does not
yet exist, unbatch creates it, to indicate that there is now a copy
of unbatch running.
.sp 1
Incoming news can be in either one of three forms:
.sp 1
.IN "1. Regular articles."
.IN "2. Batches of articles."
.IN "3. Compressed batches of articles."
.sp 1
All of these are expected to be in the "incoming" spool directory
of the NEWS system, usually this is the
.B /usr/spool/news/in.coming
directory.  When this program is invoked, it will search the directory
named above for files, which it then processes one at a time.
.sp 1
Each file is first opened.  Then, unbatch will read the first line of
text from the file (up to 128 characters in length) to determine the
type of this file.  The folllowing rules apply:
.sp 1
.B "COMPRESSED BATCHES"
are files with a line of
.sp 1
.IN "#! cunbatch"
.sp 1
as their header.
.sp 1
.B "BATCHES"
are files with the text
.sp 1
.IN "#! rnews NNNNN"
.sp 1
as their header.
.sp 1
.B "ARTICLES"
are all other files.
.sp 1
First of all, unbatch checks if the file is compressed.  If so, it
executes a command line of the form:
.sp 1
.IN "/bin/compress -d"
.sp 1
with the standard input being the current input file, and with the
output being a temporary file in the
.B /tmp
directory.  After successful decompression (indicated by an exit
status of 0), unbatch closes the current file, and opens the newly
created temporary file as the current input file.
.sp 1
At this point, it can either expect to get a batch of concatenated
articles, or a plain, single article.  To see what type of file it
has currently open, it continues the check with comparing the first
9 characters of the line with the text:
.sp 1
.IN "#! rnews "
.sp 1
since this indicates the start of an article in a batch file.
.sp 1
Unbatch now goes into a loop, extracting all articles in the current
open file and posting them by calling the
.B inews
program repeatedly.  It does this by copying each article into a
temporary file, and then issue a command like:
.sp 1
.IN "/usr/lib/news/inews -h"
.sp 1
with standard input being the temporary file containing the article.
The inews program then takes care of the actual posting of the
article.
.sp 1
When a file has been completely processed, it will be removed if no
errors occurred during the unpacking.  Otherwise, it will be moved
to the parent directory, to allow the system administrator to unpack
it manually.
.sp 1
When all files in the directory have been processed in this manner
(relax; this may take some time... :-) the lock file is removed and
unbatch exits.  See the manual pages of
.B unbatch(8)
and
.B rnews(8)
for more details on how to invoke unbatch.
.HD inews
.B Inews
is the heart of the NEWS system.  It receives articles from the
unbatching program for local posting (and possibly forwarding to
other systems), and it receives articles that are generated by
news composing programs like
.B pnews
or news readers like
.B vn
when a followup is created.
.sp 1
When inews is started, it reads the article's header (as far as one
exists) into memory.  The rest of the article is copied into a
temporary file in the
.B /tmp
directory.  Now, inews checks if it has to generate a message header
(which is the case if the article was generated locally), or if it
only has to update the information in the header it just read into
memory (which is the case when unbatch calls inews with an article).
A message header usually has the following fields in it:
.sp 1
.nf
  * Path:
  * From:
  * Sender:
    Reply-To:
    Followup-To:
  * Newsgroups:
    Distribution:
    Control:
  * Subject:
    Keywords:
    Summary:
    References:
  * Message-ID:
    Organization:
    Department:
  * Date:
    Expires:
    Approved:
    Lines:
.fi
.sp 1
All fields marked with an asterisk (*) are mandatory.  The other
fields need not be present, although they frequently are.  Some
fields (From, Sender, Reply-To, Subject, Message-ID, Organization,
Date) have the same meaning as in e-mail message headers.  The rest
are special to the NEWS system.
.sp 1
As soon as inews finishes updating the article header, it creates
a complete article (comprised of the new article header plus the
article body) in a file in the NEWS main spool directory (usually
this is
.B /usr/spool/news
).  Now, a note is written to the NEWS system log file about the
arrival of this article.  If resource accounting has been enabled,
inews will also write a record about the arrival to the NEWS
accounting file, after which the temporary file in /tmp is deleted.
.sp 1
Inews will now check the system's
.B sys
file to see if the local system is interested in this article.  If
it is not, the system will try to put the article in a news group called
.B junk
, which is used to dump all unwanted articles in.  Then, it checks
to see if the directory for this news group exists, since it has to
be put somewhere.  If no directory exists, inews will change the
news group name to
.B junk
again.
.sp 1
If the
.B HISTORY
mechanism was enabled at compile time, inews will now check its
history database to see of this article has already been received
before (which is, in theory, possible if a system has more than one
news feed).  If it already got it before, it will write a message to
this effect in the log file, and stop the delivery. Otherwise, a
record for this article will be added to the history database.
.sp 1
Inews then scans through the system's
.B active
file, to see which sequence number the article will get.  If the
news group cannot be found in this file, inews will try to use
the junk group again, to prevent the article from getting lost.
.sp 1
Inews now locks the active file, and increases the number of the
next available article.  Finally, the article's temporary copy
is linked to a file with a name identical to the ASCII representation
of the sequence number for this article.  So, when using a news
group of
.B comp.os.minix
, we get a total path name of:
.sp 1
.IN "/usr/spool/news/comp/os/minix/NNNNN"
.sp 1
with
.B NNNNN
being the number of the article in that news group.  This naming
scheme allows for up to 65535 articles per news group, without the
physical need for expiration of articles.  Larger NEWS installations
use a 10-digit number instead of the usual 5-digit number.
.sp
This process of linking the temporary copy of the article to files
in the spool directories of the various news groups is repeated for
all news groups in the
.B Newsgroups:
field of the article.  Thus, only one copy of the article is on the
disks; the rest of all occurrences are links to the same article
to save disk space.
.sp 1
.B NOTE:
this requires all directories to be on the same disk!
.sp 1
Finally, inews will check the
.B sys
file to see if it has to send this article to other systems as well
(this is called
.B relaying
of news articles).  If so, it will send the article to the remote system
as described in the
.B FILES
chapter under section
.B sys
, since this can be set on a per-system basis.
.sp 1
Again, a note is written to the system log file telling to which systems
the article has been relayed.  Also, if resource accounting is enabled,
a record is written about the relaying of this article.
.sp 1
Inews now has successfully posted the incoming article to the local
system, and to any systems that were interested in the article.  It
will remove all temporary files, and exit.
.sp 1
For more information on how to invoke the inews program, see the
.B inews(8)
manual page.
.HD control
This program implements the various types of
.B "control messages"
that can be sent out using the NEWS system.  Typically, these
messages are used to add and/or remove news groups, and to
cancel previously sent articles.  Since most of these messages
share a fair amount of code, it was implemented as a single
program with a link for each of the available functions.
.sp 1
A control message is a news article with a special field in the
message header (named
.B Control:
), which can be used to tell other NEWS-running systems to perform
certain management-operations like creating or deleting a newsgroup,
or cancelling a message that was previously sent.
.sp 1
For example, the system administrator of a network may decide to
create a new newsgroup on the network.  He (or she) then posts a
control message, which looks something like:
.sp 1
.nf
 Path: uwalt!mugadm
 From: mugadm@uwalt.nl.mugnet.org (MUGNET Administrator)
 Newsgroups: mugnet.gov
 Distribution: world
 Control: newgroup mugnet.questions
 Subject: newgroup mugnet.questions
 Date: Thu, 28 Feb 91 17:45:00 GMT +0100
 Approved: mugadm@uwalt.nl.mugnet.org (MUGNET Administrator)
 Lines: 1

 This news group is for questions from novice users on MUGNET.
.fi
.sp 1
The meaning of this article is clear.  A new newsgroup is to be
created, named
.B mugnet.questions
, with its description being the first line of the message body.
The message will go to all systems receiving the news group called
.B mugnet.gov
(which is the "official announcements" group on MUGNET, received
by all hosts on it), and the message will have a geographical
distribution of
.B world
(it is possible to only create such a group in a limited distribution,
by specifying the desired distribution).
.sp 1
This message causes the named news group to be created on all systems
receiving the message.  This includes the addition of a line to the
system's
.B active
and
.B newsgroups
files, and the creation of an empty spool directory for the news group.
.sp 1
On receipt of an article with the "Control" field present, inews assumes
that it is a control message.  It then takes the first word of the
field, and uses that as name of a program to run (in our example, it
would try to run the command
.B newgroup
in the system's LIBDIR (
.B /usr/lib/news
) directory).  The program gets the article as its standard input,
since certain control messages use the text in the message body as
well.
.sp 1
The result of the control message will be mailed to the NEWS system
administrator, together with the contents of the message.  Alternatively,
it is possible to mail the entire control message to the administrator
without executing it, if it is not desired that control messages are
executed automatically.  The administrator can then execute message if
he or she desires to.
.sp 1
For more details on how to create and execute control messages, see the
.B control(8)
manual page.
.HD sendbatch
The news batches are generated by scanning the
.B /usr/spool/batch
directory for files that are kept for all systems connected to
this host, one file per host (usually with the same name as the
host). These files contain the names of any articles that need
to be sent to that system. All these articles are then concatenated
together, prefixing them with the
.sp 1
.IN "#! rnews NNNN"
.sp 1
header line. In this header,
.B NNNN
is the number of bytes (characters) in the article. Articles are
added to the current batch as long as they still fit in it (which
can be set either manually at the time of batching or by default
at compile-time). As soon as a batch is complete, it is closed and
sent to the UUCP system, possibly via the
.B compress(1)
program. This compression of the batch is indicated by the extra
.sp 1
.IN "#! cunbatch"
.sp 1
header line.  The batch is sent to the UUCP system by issuing a
command like:
.sp 1
.IN "/usr/bin/uux -r -gd - system_name!rnews < batch_file_name"
.sp 1
which means, that the
.B uxx(1C)
program is run, with the newly generated batch file as its input.
The
.B -r
flag specifies that the job should be queued rather than to call
the system
.B system_name
at once.
.sp 1
After having sent the batch file, a new file is created, and the
process of batching all articles continues.
.sp 1
When no more articles are remaining, the current batch is closed,
and sent to UUCP if it has at least ore article in it, to prevent
UUCP from creating empty jobs. After having sent the last batch file,
it removes the lock file and exits.
.sp 1
See the manual page of the
.B unbatch(8)
program for more details on how to invoke this program.
.HD expire
Systems that receive articles via the NEWS system often find that
this can mean a substantial load on the disks, both in terms of
required space and use.  Especially the amount of disk space
required to store incoming and outgoing articles is something of
a problem to system administrators, since many news packages (
W-NEWS included) have no way of controlling the amount of space
used by the NEWS system.  The software just uses disk space until
the disks are full...
.sp 1
On the other hand, it is a waste of disk space to keep articles
online forever, since most of them will not be of lasting importance.
It is said that most articles have a certain
.B "expiration date"
, much like certain news bulletins.  This means, that articles can
be removed from the system's disks after this date, either to an
archiving subsystem (for later retrieval of the articles) or to
the Great Bit Bucket.
.sp 1
The
.B expire
program is taking care of expiring these old articles from the system
disks.  It has numerous command line options to tell it what to do
with old articles, and it can be told how to determine the age of an
article.
.sp 1
The basic strategy of this program is to simply walk through all news
spool directories, and have a look at the articles in those directories.
For each article, it will determine its age (in days), and it will then
decide if the article should be expired.  If it has to be, it can do
one out of three things:
.sp 1
.IN "1. Remove the article from the system"
.IN "2. Move the article to a different disk"
.IN "3. Archive the article and then remove it"
.sp 1
If the system's NEWS host already archives news articles, it is the
easiest to either remove the article, or to move it into another part
of the system's file system (often in the directory called
.B /usr/spool/oldnews
).
.sp 1
However, it may also be useful to archive the articles in certain
news groups (for example, source postings and such).  Expire can do
this as well, it can be told which archiving program to use in that
case.
.sp 1
After the entire tree of spool directories has been processed, expire
locks the system's
.B active
file and updates it.  This means, that the second set of digits in the
file contain the number of the first article in that news group that
has not yet been expired.  The news readers can use this number to
see which is the first article actually available in the news group.
After the updating is done, the lock is removed and expire exits.
.sp 1
Since expiring articles is a fair load on the system, it is advised
to only expire at times when the system is not doing much other work.
It also prevents the clashing of users ready news while expire is
removing articles from the system.
.sp 1
A note about the removal of an article is written to the NEWS system's
log file, to allow the system administrator to trace the entire life
of an article, from the moment it came in until and including its
expiration.
.sp 1
For more details on how to use this program, see the manual page for
the
.B expire(8)
program.
.HD pnews
Posting news is done by presenting the contents of the news article
as input to the
.B inews
program.  However, it requires a fair deal of knowledge about the
inews program (and of the NEWS system as a whole) to be able to post
news articles this way.  Therefore, any news system usually provides
one or more programs that can generate, read and often reply to news
articles.  These programs usually are (more or less :-) user-friendly,
and the users are often allowed to invoke their favourite text editor
to create the actual article text.
.sp 1
.B Pnews
is such a user-friendly news-creating program.  It uses a message
composing editor similar to the one found in the
.B W-MAIL
mailer program, which, in turn,  is very similar to the UNIX-standard
.B mailx
program.  Thus, users who are at some level familiar with the use
of one of the programs named above will have little difficulty in
posting news articles with this program.
.sp 1
See the manual page for
.B pnews(1)
for more details on how to use this program.
.HD checknews
The
.B NEWS
system maintains a file in which the actual number of articles per
news group are stored: the
.B active
file.  Most news-reading programs also maintain a file called
.B .newsrc
for each user, which holds the numbers of the articles that have been
read by the user, to prevent the user from having to read through ALL
news each time.
.sp 1
This program simply compares the system's active file with  the
contents of the .newsrc file of the calling user.  If it detects that
new articles have arrived since the last time the user's .newsrc file
was modified, it will print a message to this effect.  Alternatively,
it may be told to only say something when there is NO news waiting to
be read.  With use of some command-line arguments, the user can also
select a set of news groups to be checked.
.sp 1
See the manual page of the
.B checknews(1)
program for more details on how to invoke this program.

.HD "/etc/uucpname"
This file (which is actually part of the NLMUG UUCP system) contains
one or two lines of ASCII text.  The first line contains the system's
UUCP name (usually with a maximum of 7 characters).  The second
line, if present, contains the name of the domain in which the
system lives.  If this line is not present, the domain name
defaults to
.B .UUCP
since this is the pseudo-domain name for UUCP systems.
.sp 1
On a typical MINIX system in MUGNET, the file might contain the
following lines:
.sp 1
.IN "uwalt"
.IN "nl.mugnet.org"
.sp 1
which means that the full name of the system is:
.sp 1
.IN "uwalt.nl.mugnet.org"
.sp 1
This file is checked automatically during NEWS installation.
.sp 1
Under the COHERENT operating system /etc/uucpname contains only the
system's UUCP name. The name of the domain is taken from the file /etc/domain.

.CD "N E W S    R E A D E R S"
These programs can be used to read the available news articles, in
either line-mode (like the standard
.B mail
program) or in full-screen mode.
Below you will find excerpts of the manuals supplied with the programs.

.HD "rna"
.B Rna
is a news reader which is a part of the NSWN News system. It is
compatible with the standard version of
.B readnews
as supplied with the
.B "B News"
system.
.sp 1
Author: Michael Rourke, University of N.S.W
.br
.nf
        (decvax!mulga!michaelr:elecvax)
.fi

.HD "vn"
.B Vn
is a news reader which uses the same .newsrc file as readnews(1),
but displays and interacts differently. It is aimed at allowing
you to rapidly scan a large number of newsgroups, looking for
something you want to read. The major premise is that you will be
interested in a small number of articles, but will be interested
in keeping tabs on a large number of newsgroups which may contain
something interesting from time to time. It also has the ability
to unpackage digests.
.sp 1
Author: Bob McQueer.
.sp 1
Significant enhancement / bugfixes / suggestions from:
.sp 1
.in 5
.nf
Lawrie Brown, John G Dobnick, Greg Earle, Rodney Goke,
Andy Marrinson, Jay Maynard, Marius Olafsson, George Pavel,
Dave Tallman, Larry Tepper, Karl Williamson, Mark Wittenberg,
Andrew Worsley and many others.
.fi
.br
.in
.sp 1
Ported to COHERENT 3.x and 4.0 by Udo Munk <udo@umunk.GUN.de>

.HD Tass
.B Tass
is a full screen threaded newsreader:
.sp 1
.nf
    o Organizes articles by threads.  Displays a really nice
      article selection page.
    o Group selection page makes it easy to scan newsgroups,
      subscribe, unsubscribe, reorder your .newsrc
    o If you've ever used Notes, this is the program for you.
.fi
.sp 1
Tass looks a lot like Notes, but has a few improvements:
.sp 1
.nf
    o Visual group selection page, Notes didn't have one.
    o rn style unread article detection as opposed to single
      timeline uses standard /usr/spool/news article layout
.fi
.sp 1
Newsreading style under Tass tends to be different than with rn.
Instead of plowing through each group reading everything unread,
you may find yourself reading fewer articles in more groups.  It's
easier to skip about and only read interesting threads with Tass.
.sp 1
Tass keeps an index file for each group.  The first time you enter
a group, it will be a bit slow creating this file.  After that Tass
will incrementally update the index file and there should be little
delay.
.sp 1
Author: Rich Skrenta <skrenta@blekko.commodore.com>
.sp 1
Ported to MINIX by Wim van Dorst <baron@wiesje.hobby.nl>
.sp 1
Ported to COHERENT 3.1 by Joachim Riedel <joachim@jrix.radig.de>
.br
Ported to COHERENT 3.x and 4.0 by Udo Munk <udo@umunk.GUN.de>

.HD Tin
.B Tin
(release 1.1 PL6) is a full screen threaded newsreader similar to Tass:
.sp 1
.nf
    o Based more on Notes and Tass than rn type newsreaders.
    o Full screen, easy to use with on-line help at all levels.
    o Reads news locally (ie. /usr/spool/news) and/or via NNTP/INN/CD-ROM.
    o Threads on Subject: and/or Archive-name: mail headers.
    o Five different operating levels:
      - Spooldir selection level (CD-ROM only)
      - Group selection level
      - Thread selection level
      - Article selection level
      - Articel viewer
    o Same interface to mail, pipe, print and save articles.
    o Auto unpacking of multi-part shar & uuencoded articles.
    o Auto-selectio
    o Batch mode to mail/save new news when user is on holiday.
    o Reposting of articles from one newsgroup to another.
    o NNTP extensions XUSER & XINDEX to allow central index files.
.fi
.sp 1
Author: Iain Lea <Iain.Lea%anl433.uucp@Germany.EU.net>
.sp 1
Ported to COHERENT by Udo Munk <udo@umunk.GUN.de>

.HD nn
.B Nn
is a menu based (point and shoot) netnews reader with a complete
set of features to satisfy both the expert and the novice user.  Since
its first release in Denmark in 1984 (!), in Europe in 1988, and the
global release in June 1989, it has replaced rn and other well-known
news readers at many sites.
.sp 1
Some of the key features of nn are:
.sp 1
.nf
 o  Menu-based article selection prior to reading the articles
    with the articles sorted according to subject & posting time!

    This significantly reduces the time spent on news reading.
    No keystorkes are wasted on articles you don't want to read, and
    only the articles selected on the menu will be read.

 o  Release 6.4 uses standard .newsrc, and can leave individual
    articles unread!

 o  Digests are automatically split and presented as ordinary articles!
    You can transparently save and respond to individual subarticles.

 o  Full folder support: read, save, and delete individual articles.

 o  Online help and manual.

 o  Built-in unshar and patch functions.

 o  Built-in uudecode function which will automatically unpack,
    concatenate, and decode multi-part postings.

 o  Easy remapping of keys with advanced macro definition features.

 o  Automatic kill & selection of articles based on subject or author.

 o  User specified presentation sequence of news groups based on the
    news group hierarchy.

 o  Whole classes of news groups can easily be unsubscribed
    permanently, e.g. talk.all and all.politics

 o  Related groups can be merged and presented as a single group, e.g.
    comp.emancs and all gnu.emacs groups.

 o  Blindingly fast 'search for subject'.  On my Texas S1500 system,
    nn uses less than 20 seconds to find all articles on a specific
    subject among 64000 articles in all groups!

 o  News collection and presentation is extremely fast, because nn
    uses its own database on top of the standard news system.

 o  In a distributed environment, the database can be shared among all
    hosts on the network.  Only one daemon is needed on the news server
    for all hosts.  This works in a heterogenous environment as well.

 o  NNTP is also supported (using a local database for speed).
.fi
.sp 1
Because of the database, nn starts almost equally fast (in a few
seconds), no matter whether you have 100 or 10000 unread articles!
The database takes up some disk space, but dramatically improves speed
and functionality.  The amount of disk space consumed is approx. 1Mb
per 10000 articles.
.sp 1
Autor: Kim Fabricius Storm <storm@texas.dk>
.sp 1
Ported to COHERENT by Udo Munk <udo@umunk.GUN.de>

.CD "V A R I I"
This chapter contains various bits 'n' pieces of information, which
are usually found in "manpage" style manuals.

.HD AUTHOR
The W-NEWS program has been written by Fred N. van Kempen.  The ports
to the Coherent Operating System (versions 3.X and 4.X) were done by
Udo Munk.  The general outline of the various modules is similar to
the outline found in the
.B "B\ News"
system (version 2.11) for UNIX systems. The
.B "Article Editor"
was derived from the
.B "W-MAIL Message Editor"
from the same author.  The news group pattern matching routines in
the
.B inews
program were taken (without permission) from the
.B "B News 2.11"
software package, which is freely redistributable.  It will be replaced
with another (home-made) routine as soon as possible.

.HD COPYRIGHT
This software is Copyright 1991-1993 by MicroWalt Corporation, and may
be freely redistributed under the GNU Public License, as long as this
notice and the headers in the source files remain unchanged.  This
software may not be used and/or distributed for commercial purposes
without prior written consent from the Author.  See the file named
.B COPYING
for more details.

.HD CHANGES
The Author will release updates to this package on an as-needed basis.
Please send your comments, bug reports (preferrably with their
respective fixes) and additions to the address below.

.HD ADDRESSES
Please direct all questions/suggestions/remarks to this address,
either postal or e-mail:
.sp 1
.nf
.IN "MicroWalt Corporation"
.IN "Attn: W-NEWS Support Desk"
.IN "Hoefbladhof  27"
.IN "2215 DV  VOORHOUT"
.IN "The Netherlands"
.sp 1
.IN "E-mail: desk@uwalt.nl.mugnet.org (Support Desk)"
.sp 1
.fi
Note, that the responding person is not necessarily the Author of
this software package!
.sp 1
.HD "BUGS"
Probably around, though not much. Certain things could be improved, if
only for speed or completeness. Better care should be taken with system
security in the
.B control
program, which is able to remove and create news groups.

.HD "SEE ALSO"
For more information on this topic, you might want to read one or more of
the following papers:
.sp 1
.nf
[1]  "The W-MAIL Reference Manual", Fred N. van Kempen 1990
     Available from NLMUG Archive Service

[2]  "The U-MAIL Reference Manual", Fred N. van Kempen 1990
     Available from NLMUG Archive Service

[3]  "The NLMUG UUCP Reference Manual", Fred N. van Kempen 1990
     Available from NLMUG Archive Service

[4]  "A Dial-Up Network of UNIX Systems", D. A. Nowitz 1974
     Bell Laboratories, Murray Hill, New Jersey 07974
     Also available from NLMUG Archive Service

[5]  "Uucp Implementation Description", D. A. Nowitz 1974
     Bell Laboratories, Murray Hill, New Jersey 07974
     Also available from NLMUG Archive Service

[6]  "B News version 2.11 manuals", Rick Adams et al 1987
     Available from NLMUG Archive Service
.fi
