#! /bin/sh
#
# W-NEWS        A simple NEWS processing package.
#               This is a shell script to ease the installation of the
#               W-NEWS package on your system. See the README file for
#               installation details.
#
# Usage:        Install {progs}
#
# Version:	@(#)Install.sh	4.00	12/25/92
#
# Authors:	Fred N. van Kempen, waltje@uwalt.nl.mugnet.org
#		Udo Munk, udo@umunk.GUN.de
#

# Constants.
UNAME=news
GNAME=news
USENET=usenet
MYUID=30
MYGID=30
HOSTNAME=/etc/uucpname
DOMAINNAME=/etc/domain
LIB=/usr/lib/news
SPL=/usr/spool/news
BAT=/usr/spool/batch

# Might also be /usr/ucb or /usr/bin .
BIN=/bin

# Absolute names are faster!
ECHO=/bin/echo

# Variables.
ans=
progs=
sysname=
domname=
dir=
group=
first=
last=
maypost=

clear;
${ECHO} "This procedure installs the W-NEWS package onto your system."
${ECHO} "It does this by asking you questions, and checking the answers"
${ECHO} "against some files on your system disk."
${ECHO}

# Check procedure arguments.
if [ $# != 0 ]
  then
	progs="checknews control expire inews pnews rnews sendbatch \
	unbatch wnbill newspace"
  else
	progs=
fi

# Check the UUCP system information.
if [ ! -f ${HOSTNAME} ]
  then
	${ECHO} "Please install the UUCP system first!"
	exit 1
fi

sysname=`cat ${HOSTNAME}`
domname=`cat ${DOMAINNAME}`
if [ ${sysname}.${domname} = ${sysname}. ]
  then
	${ECHO} "It seems that your ${HOSTNAME} file is incomplete."
	${ECHO} -n "Please enter your UUCP name \[${sysname}\]: "
	read ans
	if [ -n "${ans}" ]
	then
		sysname="${ans}"
	fi
	${ECHO} -n "Please enter your domain name [UUCP]: "
	read ans
	domname="UUCP"
	if [ -n "${ans}" ]
	then
		domname="${ans}"
	fi

	${ECHO} ${sysname}  > ${HOSTNAME}
	${ECHO} ${domname}  > ${DOMAINNAME}
	${ECHO} "Updated ${HOSTNAME} and ${DOMAINNAME}."
  else
	${ECHO} "Your ${HOSTNAME} and ${DOMAINNAME} files contains the correct information."
fi
${ECHO}
${ECHO} "Your system will be called \"${sysname}.${domname}\" ."
${ECHO}

# Check and update /etc/passwd and /etc/group.
${ECHO} "Checking /etc/passwd and /etc/group..."
if grep -s ${UNAME} /etc/passwd
  then
	${ECHO} "	Your /etc/passwd file is OK."
  else
	${ECHO} -n "Do you want me to update /etc/passwd? y/n "
	read ans
	if [ "${ans}" = "y" ]
	then
		${ECHO} "	Updating /etc/passwd."
		${ECHO} "${UNAME}:No Login:${MYUID}:${MYGID}:News System:${LIB}:" >>/etc/passwd
		${ECHO} "${USENET}::`expr ${MYUID} + 1`:${MYGID}:News Administrator:${LIB}:" >>/etc/passwd
		${ECHO} "Now enter the password for user ${USENET}"
		passwd ${USENET}
	fi
fi
if grep -s ${GNAME} /etc/group
  then
	${ECHO} "	Your /etc/group file is OK."
  else
	${ECHO} -n "Do you want me to update /etc/group? y/n "
	read ans
	if [ "${ans}" = "y" ]
	then
		${ECHO} "	Updating /etc/group."
		${ECHO} "${GNAME}::${MYGID}:${GNAME},${USENET}" >>/etc/group
	fi
fi
${ECHO}

${ECHO} -n "Do you want me to re-create the \"${LIB}\" directory? y/n "
read ans
if [ "${ans}" = "y" ]
  then
	${ECHO} "Creating directory..."
	rm -rf ${LIB}
	mkdir ${LIB}
fi
${ECHO}

${ECHO} -n "Do you want me to re-create all \"news\" files? y/n "
read ans
if [ "${ans}" = "y" ]
  then
	${ECHO} "Clearing directory ${LIB}..."
	rm -f ${LIB}/*
	${ECHO} "Copying files..."
	cp sys active newsgroups distributions ${LIB}
	newscopy.sh
	touch ${LIB}/errlog ${LIB}/log ${LIB}/history
  else
	${ECHO} "Checking files..."
	for i in sys active newsgroups distributions
	do
		if [ -f ${LIB}/$i ]
		then
			${ECHO} "	${LIB}/$i OK."
		else
			${ECHO} "	Creating default ${LIB}/$i"
			cp $i ${LIB}
		fi
	done
	for i in ${progs}
	do
		${ECHO} "	Copying $i to ${LIB}/$i"
		cp $i ${LIB}
	done
	if [ ! -f ${LIB}/errlog ]
	then
		${ECHO} "	Creating empty ${LIB}/errlog"
		touch ${LIB}/errlog
	fi
	if [ ! -f ${LIB}/log ]
	then
		${ECHO} "	Creating empty ${LIB}/log"
		touch ${LIB}/log
	fi
	if [ ! -f ${LIB}/history ]
	then
		${ECHO} "	Creating empty ${LIB}/history"
		touch ${LIB}/history
	fi
fi
if [ -f ${LIB}/organization ]
  then
	${ECHO} "	Organization name OK."
  else
	${ECHO} "	Enter organization name. Keep it short!"
	${ECHO} -n "> "
	read ans
	if [ -n "${ans}" ]
	then
		${ECHO} ${ans} > ${LIB}/organization
	else
		cp /dev/null ${LIB}/organization
	fi
fi
${ECHO}

${ECHO} -n "Do you want me to re-create the \"${SPL}\" directory? y/n "
read ans
if [ "${ans}" = "y" ]
  then
	${ECHO} "Creating directories..."
	rm -rf ${SPL}
	rm -rf ${BAT}
	mkdir ${SPL} ${BAT} ${SPL}/control ${SPL}/junk ${SPL}/in.coming
	adddirs.sh
	upddir=yes
  else
	${ECHO} "Checking directories..."
	if [ -d ${SPL}/in.coming ]
	then
		${ECHO} "	${SPL}/in.coming OK."
	else
		${ECHO} "	Creating ${SPL}/in.coming"
		mkdir ${SPL}/in.coming
		chown ${UNAME} ${SPL}/in.coming
		chgrp ${GNAME} ${SPL}/in.coming
		chmod 750 ${SPL}/in.coming
	fi
	if [ -d ${SPL}/junk ]
	then
		${ECHO} "	${SPL}/junk OK."
	else
		${ECHO} "	Creating ${SPL}/junk"
		mkdir ${SPL}/junk
		chown ${UNAME} ${SPL}/junk
		chgrp ${GNAME} ${SPL}/junk
		chmod 755 ${SPL}/junk
	fi
	if [ -d ${BAT} ]
	then
		${ECHO} "	${BAT} OK."
	else
		${ECHO} "	Creating ${BAT}"
		mkdir ${BAT}
		chown ${UNAME} ${BAT}
		chgrp ${GNAME} ${BAT}
		chmod 755 ${BAT}
	fi
	upddir=no
fi
${ECHO}

if [ "${upddir}" = "yes" ]
  then
  	${ECHO} "Setting permissions of spool directorys."
	chown ${UNAME} ${LIB} ${SPL} ${BAT} ${LIB}/*
	find ${SPL} -exec chown ${UNAME} {} \;
	chgrp ${GNAME} ${LIB} ${SPL} ${BAT} ${LIB}/*
	find ${SPL} -exec chgrp ${GNAME} {} \;
	chmod 755 ${LIB} ${SPL} ${SPL}/control ${SPL}/junk
	chmod 750 ${BAT} ${SPL}/in.coming
	
	${ECHO} "Creating a list of spool directories. This may take time!"
	${ECHO} >DIRLIST
	cat ${LIB}/active |
		(while read group last first maypost
		do
			${ECHO} ${group}
		done) | tr . / | (while read dir
			do
				${ECHO} ${SPL}/${dir} >>DIRLIST
			done)

	${ECHO} "Spool directories created. See DIRLIST for the list!"
fi

${ECHO} "Setting up links..."
rm -f ${BIN}/pnews ${BIN}/rnews ${BIN}/checknews \
	${LIB}/checkgroups ${LIB}/newgroup ${LIB}/rmgroup ${LIB}/cancel \
	${LIB}/sendsys ${LIB}/senduuname ${LIB}/version
ln ${LIB}/pnews ${BIN}/pnews
ln ${LIB}/rnews ${BIN}/rnews
ln ${LIB}/checknews ${BIN}/checknews
ln ${LIB}/control ${LIB}/checkgroups
ln ${LIB}/control ${LIB}/newgroup
ln ${LIB}/control ${LIB}/rmgroup
ln ${LIB}/control ${LIB}/cancel
ln ${LIB}/control ${LIB}/sendsys
ln ${LIB}/control ${LIB}/senduuname
ln ${LIB}/control ${LIB}/version
${ECHO}

${ECHO} "Setting up permissions..."
chmod 6550 ${LIB}/unbatch ${LIB}/sendbatch ${LIB}/expire ${LIB}/control \
	${LIB}/wnbill
chmod 6555 ${LIB}/inews ${LIB}/rnews
chmod 511 ${LIB}/pnews ${LIB}/checknews
chmod 750 ${LIB}/newspace
chmod 664 ${LIB}/active ${LIB}/distributions ${LIB}/newsgroups \
	${LIB}/organization ${LIB}/sys

${ECHO}
${ECHO} "Installation done."
${ECHO} "W-NEWS has now been installed on your system !!"

exit 0
