/* emulib.h by Harry Pulley, IV; 10JAN93.  Written for Coherent 4.0 to emulate
   functions, etc. so that it may compile Linux MGR code.

   Updated later for vgalib under 4.0.

   Updated for vgalib under 4.2, 6NOV93.  It may need some mods still for MGR 
   under 4.2.

   Much of this is not really needed.  It is here for MGR, not vgalib.  I have 
   left it in so that the emulib.h file is relatively common to the two 
   programs. */

#ifndef EMULIB
#define EMULIB 1
/* 4.0 only: link <signal.h> to <sys/signal.h> */
/* link <termio.h> <termios.h> */
/* 4.0 only: touch <sys/wait.h> */
/* 4.0 only: touch <sys/file.h> */

#define termios termio

typedef int pid_t;
typedef int gid_t;

#include <sys/param.h>
#include <sys/utsname.h>
#include <path.h>

/* 4.0 may need this: #define _POSIX_SOURCE * not true but... */

#define EWOULDBLOCK EAGAIN

#define _POSIX_PATH_MAX MAXPATH

#define TCSANOW TCSETA
#define TCSETSW TCSETA
#define TCGETS TCGETA
#define TCIOFLUSH TIOCFLUSH
#define TIOCFLUSH ('t'<<8|16)

#define tcgetattr(x,y) ioctl(x,TCGETA,y)
#define tcsetattr(x,y,z) ioctl(x,y,z)

#define random rand
#define srandom srand

#define wait3(x,y,z) wait(x)
#define setreuid(x,y) setuid(x)
#define setregid(x,y) setgid(x)

#define gethostname(x,y) \
{ \
struct utsname sysname; \
uname(&sysname); \
strcpy(x,sysname.sysname); \
}

#define killpg kill

#define vfork fork

#define getdtablesize() NOFILE

/* we need a fchown or */
#define fchown(x,y,z)

/* we need a fchmod or */
#define fchmod(x,y) 

/* we don't have session ids so */
#define setsid()

/* we need a ftruncate or */
#define ftruncate(x,y)

#define poll Poll

#define void char

#define S_ISREG(x) (x&S_IFREG)
#define S_ISDIR(x) (x&S_IFDIR)

#define ioperm(x,y,z) _ioperm(x)

#define mmap(a,b,c,d,e,f) _mmap(a,f,b)

#define inline

#define PAGE_SIZE 4096

typedef char * caddr_t;

#endif
