


        uustat(1C)                                            uustat(1C)


     NAME
          uustat - uucp status inquiry and job control

     SYNOPSIS
          uustat [-q] or [-kjobid [-n]] or [-rjobid [-n]]
          uustat [-a] [-ssystem] [-j] [-uuser]

     DESCRIPTION
          uustat provides the following functions:
               1.     it displays uucp jobs still waiting to be processed
               2.     it allows the owner of any job to kill or rejuvinate it
               3.     it displays the status of each remote system known to 
                      uucp

          DISPLAYING JOBS
          When used to display pending uucp jobs, uustat can display this
          information in the following ways:
               1.   When invoked without any options, uustat displays all
                    jobs created by the user.  This is the same as specifying
                    the -u option.  no sorting of any kind is performed by 
                    uustat but due to the nature of how the jobs are stored, 
                    they will be grouped by system.  However, no indication of 
                    this is given by uustat (one can find the name of the 
                    system by looking at the jobid--it begins with the system 
                    name).
               2.   When used with the -s option, only the given system is 
                    queried, and all pending jobs are displayed, regardless
                    of the owner (i.e. the -s option implies the -a option).
               3.   When the -a option is given, every job is displayed,
                    regardless of the owner and regardless of any other option
                    included (any other option that is valid with the -a 
                    option that is).
               4.   When the -j option is used, whether with the -a, -s,
                    or -u options or alone, a count of the number of jobs
                    displayed is kept and the result is displayed before
                    uustat exits. 
 
                    
          The following is an example of what uustat will display for a
          uucp job:
          
               mwcbbsa0015   07/07-13:17 S mwcbbs romel 397 D.vgera0016
                             07/07-13:17 S mwcbbs romel rmail romel 
               testa0075     07/07-13:31 S test romel 457 /u/romel/uustat/tmp
              
          This example shows that there are two pending jobs, 'mwcbbsa0015' 
          and 'testa0071'.
          
          Job 'mwcbbsa0015' was created on 07/07 at 13:17 by user 'romel'.  
          The job consists of two actions: 1) send the file 'D.vgera0016', 
          whose file size is 397 bytes, to system 'mwcbbs'; and 2) send 
          the uux command 'rmail romel' to system 'mwcbbs'.
 
          Job 'testa0075' was created on 07/07 at 13:31 by user 'romel'.
          The job consists of one action: to send the file 
          '/u/romel/uustat/tmp', which is 457 bytes, to system test.
           
                    
          KILLING OR REJUVINATING JOBS
          When the -k or -r options are used, uustat will kill or rejuvinate
          a uucp job, providing the user is the owner of the job.  uustat
          will also allow root or uucp to kill any job.  In this case, mail
          is sent to the owner informing him/her of the action.
  
          If the -n option is included with the kill or rejuvinate options,
          no output is produced and a status is returned indicating the
          success of the kill or rejuvinate directive.

          In most cases, a uucp job will consist of more than one file.  
          When uustat kills or rejuvinates a job, it searches for all files 
          associated with that job and performs the same action on those
          files as well.


          DISPLAYING QUEUE STATUS
          When used with the -q option, uustat displays the name of each 
          system, the number of jobs waiting, and the date and status 
          of the last uucp operation on that queue.  If any jobs are older 
          than 1 day, the age of the oldest job is displayed in parentheses 
          after the number of outstanding jobs for that queue.
                   

          The following is an example of uustat's queue status output:
           
               smarthost     1C         08/07 13:00:13  ABNORMAL COMPLETION 
               mwcbbs        1C(2)      08/05 16:00:03  ABNORMAL COMPLETION 
               neighbor                 08/05 16:46:21  TALKING
               test          2C         08/05 16:00:03  ABNORMAL COMPLETION 

          The example shows that uucp knows four remote sites: smarthost,
          mwcbbs, neighbor, and test.  smarthost has 1 job pending and the
          last time uucp made a call to it was 08/07 at 13:00:13.  The result
          was an abnormal completion.  mwcbbs also has one job pending, and
          the oldest file is two days old.  The last call was made on 08/05 at 
          16:00:03 resulting in an abnormal completion.  neighbor has no jobs 
          waiting, and uucp is in the middle of a calling it.  The call was 
          made on 08/05 at 16:46:21.
          
                    
     OPTIONS

          -a       List all jobs in queue, regardless of owner.
 
          -j       List the total number of jobs displayed.  The result is 
                   displayed at the end of uustat's output.

          -kjobid  Kill the uucp job whose identification is given by 'jobid'.

          -n       Suppress all standard out output, but not standard error.

          -q       Display the number of jobs queued for each machine, 
                   calculate the age of the oldest file, and show the status
                   of the last uucp transaction.

          -rjobid  Rejuvinate the uucp job whose identification is 'jobid'.

          -ssystem Display all jobs for system 'system'.
           
          -uuser   Display all jobs created by 'user'.  If this option
                   omitted and the -a option is also omitted, uustat displays 
                   only the jobs owned by the user issuing the uustat command.
                   In effect, this amounts to invoking uustat with the
                   -u option and 'user' set to the login name of the user
                   who invoked the uustat command.

     FILES
          /etc/passwd                      password file
          /usr/lib/uucp/L.sys              list of remote systems
          /usr/spool/uucp/*                spool directories
          /usr/spool/uucp/.Log/uucico/*    log files

     SEE ALSO
          uucp(1C).

     DIAGNOSTICS

     NOTES
          If a uucp request is made to transfer a file and that file is later
          deleted or moved and the -C option was not given with the uucp
          command, uustat will show a file size of -99999 to indicate that
          it could not find that file.  That part of the job will fail when
          uucp tries to process the job because it will not be able to find
          the file.
          
